/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.DeprecationLevel;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"'\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0011=)\u0001!\u0004\r\t\u00015\t\u0001\u0014A\u000b\u00021\u0005IJ\u0001c\u0001\u000e\u0003a\u0011\u0001k!\u0001\u001a\n!\u0015Q\"\u0001\r\u0003!\u000e\t\u00114\u0002\u0003\u0002\u0011\ri\u0011\u0001g\u0002Q\u0007\u0007!6\u0001BG\u0011\t\u0005#\u0001\u0012B\u0007\u00021\u0015)B!\u0003\u0002\n\u0003a)\u00014BM\u0005\u0011\u0019i\u0011\u0001\u0007\u0002Q\u0007\u0003!6\u0001\u0002"}, strings={"createDeprecatedAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "message", "", "replaceWith", "level", "Lkotlin/DeprecationLevel;", "AnnotationUtilKt", "get", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "", "parameterName"}, moduleName="kotlin-compiler")
public final class AnnotationUtilKt {
    @NotNull
    public static final AnnotationDescriptor createDeprecatedAnnotation(KotlinBuiltIns $receiver, @NotNull String message, @NotNull String replaceWith, @NotNull DeprecationLevel level) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(replaceWith, "replaceWith");
        Intrinsics.checkParameterIsNotNull((Object)level, "level");
        ClassDescriptor deprecatedAnnotation = $receiver.getDeprecatedAnnotation();
        ConstructorDescriptor constructorDescriptor = deprecatedAnnotation.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            Intrinsics.throwNpe();
        }
        List<ValueParameterDescriptor> parameters2 = constructorDescriptor.getValueParameters();
        ClassDescriptor replaceWithClass = $receiver.getBuiltInClassByName(Name.identifier("ReplaceWith"));
        ConstructorDescriptor constructorDescriptor2 = replaceWithClass.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        List<ValueParameterDescriptor> replaceWithParameters = constructorDescriptor2.getValueParameters();
        KotlinType kotlinType = deprecatedAnnotation.getDefaultType();
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to(AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "message"), new StringValue(message, $receiver));
        ValueParameterDescriptor valueParameterDescriptor = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "replaceWith");
        KotlinType kotlinType2 = replaceWithClass.getDefaultType();
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to(AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)replaceWithParameters, "expression"), new StringValue(replaceWith, $receiver));
        ValueParameterDescriptor valueParameterDescriptor2 = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)replaceWithParameters, "imports");
        List list = CollectionsKt.emptyList();
        KotlinType kotlinType3 = $receiver.getArrayType(Variance.INVARIANT, $receiver.getStringType());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "getArrayType(Variance.INVARIANT, stringType)");
        pairArray2[1] = TuplesKt.to(valueParameterDescriptor2, new ArrayValue(list, kotlinType3, $receiver));
        pairArray[1] = TuplesKt.to(valueParameterDescriptor, new AnnotationValue(new AnnotationDescriptorImpl(kotlinType2, MapsKt.mapOf(pairArray2), SourceElement.NO_SOURCE)));
        ValueParameterDescriptor valueParameterDescriptor3 = AnnotationUtilKt.get((Collection<? extends ValueParameterDescriptor>)parameters2, "level");
        ClassDescriptor classDescriptor = $receiver.getDeprecationLevelEnumEntry(level);
        if (classDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "getDeprecationLevelEnumEntry(level)!!");
        pairArray[2] = TuplesKt.to(valueParameterDescriptor3, new EnumValue(classDescriptor));
        return new AnnotationDescriptorImpl(kotlinType, MapsKt.mapOf(pairArray), SourceElement.NO_SOURCE);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AnnotationDescriptor createDeprecatedAnnotation$default(KotlinBuiltIns kotlinBuiltIns, String string, String string2, DeprecationLevel deprecationLevel, int n) {
        if ((n & 4) != 0) {
            deprecationLevel = DeprecationLevel.WARNING;
        }
        return AnnotationUtilKt.createDeprecatedAnnotation(kotlinBuiltIns, string, string2, deprecationLevel);
    }

    private static final ValueParameterDescriptor get(Collection<? extends ValueParameterDescriptor> $receiver, String parameterName) {
        Iterable $receiver$iv = $receiver;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!Intrinsics.areEqual(it.getName().asString(), parameterName)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection doesn't contain any element matching predicate.");
        }
        return (ValueParameterDescriptor)((Object)single$iv);
    }
}

