/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Iterator;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ConstructorHeaderCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\t\r\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\u000b\u0005\u0017!\rQ\"\u0001\r\u0003#\u0011!\u0001\u0001#\u0002\u0016\u0003a\u0019\u0011D\u0002E\u0004\u001b\u0011I!!C\u0001%\u0006a!\u0011d\u0001E\u0005\u001b\u0005AR\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;"}, moduleName="kotlin-compiler")
public final class ConstructorHeaderCallChecker
implements CallChecker {
    public static final ConstructorHeaderCallChecker INSTANCE;
    public static final ConstructorHeaderCallChecker INSTANCE$;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        boolean bl;
        ClassDescriptor labelReferenceClass;
        ClassDescriptor classDescriptor;
        Sequence<HierarchicalScope> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassDescriptor dispatchReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall.getDispatchReceiver());
        ClassDescriptor extensionReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall.getExtensionReceiver());
        KtElement ktElement = resolvedCall.getCall().getCallElement();
        if (!(ktElement instanceof KtInstanceExpressionWithLabel)) {
            ktElement = null;
        }
        KtInstanceExpressionWithLabel ktInstanceExpressionWithLabel = (KtInstanceExpressionWithLabel)ktElement;
        if (ktInstanceExpressionWithLabel != null) {
            KtInstanceExpressionWithLabel ktInstanceExpressionWithLabel2 = ktInstanceExpressionWithLabel;
            KtInstanceExpressionWithLabel instanceExpressionWithLabel = (KtInstanceExpressionWithLabel)((Object)$receiver$iv);
            Object v = context.trace.get(BindingContext.REFERENCE_TARGET, instanceExpressionWithLabel.getInstanceReference());
            if (!(v instanceof ClassDescriptor)) {
                v = null;
            }
            classDescriptor = (ClassDescriptor)v;
        } else {
            classDescriptor = labelReferenceClass = null;
        }
        if (dispatchReceiverClass == null && extensionReceiverClass == null && labelReferenceClass == null) {
            return;
        }
        $receiver$iv = ScopeUtilsKt.getParentsWithSelf(context.scope);
        Iterator<HierarchicalScope> iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return;
            HierarchicalScope element$iv = iterator2.next();
            HierarchicalScope it = element$iv;
            if (it instanceof LexicalScope && Intrinsics.areEqual((Object)((LexicalScope)it).getKind(), (Object)LexicalScopeKind.CONSTRUCTOR_HEADER)) {
                DeclarationDescriptor declarationDescriptor = ((LexicalScope)it).getOwnerDescriptor();
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
                }
                if (SetsKt.setOf(dispatchReceiverClass, extensionReceiverClass, labelReferenceClass).contains(((ConstructorDescriptor)declarationDescriptor).getContainingDeclaration())) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        boolean bl2 = true;
        if (!bl2) return;
        KtExpression ktExpression = context.call.getCalleeExpression();
        if (ktExpression == null) return;
        context.trace.report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(ktExpression, (DeclarationDescriptor)resolvedCall.getResultingDescriptor()));
    }

    private ConstructorHeaderCallChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new ConstructorHeaderCallChecker();
    }
}

