/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u00031\tA\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)C\u0003B\u0006\t\u00045\t\u0001DA\t\u0005\t\u0001A)!F\u0001\u0019\u0007e1\u0001rA\u0007\u0005\u0013\tI\u0011\u0001*\u0002\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015)s\u0001B\u0001\t\f5\t\u0001DB\u000b\u0003\u0019\u0003Aj\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallReturnsArrayOfNothingChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "containsArrayOfNothing", "", "Lorg/jetbrains/kotlin/types/KotlinType;"}, moduleName="kotlin-compiler")
public final class CallReturnsArrayOfNothingChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KotlinType returnType2 = resolvedCall.getResultingDescriptor().getReturnType();
        if (this.containsArrayOfNothing(returnType2)) {
            KtElement callElement = resolvedCall.getCall().getCallElement();
            ParametrizedDiagnostic<PsiElement> diagnostic = Errors.UNSUPPORTED.on(callElement, "Array<Nothing> in return type is illegal");
            context.trace.report(diagnostic);
        }
    }

    private final boolean containsArrayOfNothing(KotlinType $receiver) {
        boolean bl;
        block3: {
            if ($receiver == null || $receiver instanceof DeferredType && ((DeferredType)$receiver).isComputing()) {
                return false;
            }
            if (TypeUtilsKt.isArrayOfNothing($receiver)) {
                return true;
            }
            Iterable $receiver$iv = $receiver.getArguments();
            for (Object element$iv : $receiver$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                if (!(!it.isStarProjection() && this.containsArrayOfNothing(it.getType()))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }
}

