/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!9Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\t-a\u0001!G\u0001\u0019\u0002\u0005.\u0012b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA\u0005\u000b\u0011\ri\u0001\"\u0003\u0002\n\u0003a!\u0011bA\u0005\u0003\u0019\u0003AJ\u0001g\u0002R\u0007\u0005AQ!J\u0005\u0005\u0017!-QB\u0001G\u00011\u0019I2\u0001#\u0004\u000e\u0003a9\u0011F\u0004\u0003B\u0011!\u0019Q\u0002C\u0005\u0003\u0013\u0005AB!C\u0002\n\u00051\u0005\u0001\u0014\u0002M\u0004#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/deserialization/ResourceLoadingClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "serializedResourcePaths", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "loadResource", "Lkotlin/Function1;", "", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;Lkotlin/jvm/functions/Function1;)V", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;"}, moduleName="kotlin-compiler")
public class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<String, InputStream> loadResource;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.getPackageFqName()");
        PackageFragmentDescriptor packageFragmentDescriptor = CollectionsKt.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(packageFragmentDescriptor instanceof DeserializedPackageFragment)) {
            packageFragmentDescriptor = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)packageFragmentDescriptor;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        InputStream inputStream = this.loadResource.invoke(this.serializedResourcePaths.getClassMetadataPath(classId));
        if (inputStream == null) {
            return null;
        }
        InputStream stream = inputStream;
        NameResolver nameResolver = packageFragment.getNameResolver();
        ProtoBuf.Class clazz = ProtoBuf.Class.parseFrom(stream, this.serializedResourcePaths.getExtensionRegistry());
        Intrinsics.checkExpressionValueIsNotNull(clazz, "ProtoBuf.Class.parseFrom\u2026ePaths.extensionRegistry)");
        ClassData classData = new ClassData(nameResolver, clazz);
        return new ClassDataWithSource(classData, null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull(serializedResourcePaths, "serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, "loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

