/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonRefactoringUtil {
    private CommonRefactoringUtil() {
    }

    public static void showErrorMessage(String title, String message, @Nullable String helpId, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "showErrorMessage"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(title, message, helpId, "OptionPane.errorIcon", false, project);
        dialog.show();
    }

    public static void sortDepthFirstRightLeftOrder(UsageInfo[] usages) {
        Arrays.sort(usages, new Comparator<UsageInfo>(){

            @Override
            public int compare(UsageInfo usage1, UsageInfo usage2) {
                PsiElement element2;
                PsiElement element1 = usage1.getElement();
                if (element1 == (element2 = usage2.getElement())) {
                    return 0;
                }
                if (element1 == null) {
                    return 1;
                }
                if (element2 == null) {
                    return -1;
                }
                return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
            }
        });
    }

    public static void showErrorHint(final Project project, final @Nullable Editor editor, final @Nls String message, final @Nls String title, final @Nullable String helpId) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RefactoringErrorHintException(message);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (editor == null || editor.getComponent().getRootPane() == null) {
                    CommonRefactoringUtil.showErrorMessage(title, message, helpId, project);
                } else {
                    HintManager.getInstance().showErrorHint(editor, message);
                }
            }
        });
    }

    public static String htmlEmphasize(String text) {
        return StringUtil.htmlEmphasize((String)text);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        return file != null && !ReadonlyStatusHandler.getInstance(element.getProject()).ensureFilesWritable(file).hasReadonlyFiles();
    }

    @NotNull
    public static Collection<PsiElement> mapFilesToParents(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "mapFilesToParents"));
        }
        Set set = JBIterable.from(elements).transform((Function)new Function<PsiElement, PsiElement>(){

            public PsiElement fun(PsiElement e) {
                return e instanceof PsiFileSystemItem && e.getParent() != null ? e.getParent() : e;
            }
        }).toSet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CommonRefactoringUtil", "mapFilesToParents"));
        }
        return set;
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(element, project, RefactoringBundle.message("refactoring.cannot.be.performed"));
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, PsiElement ... elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(Arrays.asList(elements), project, RefactoringBundle.message("refactoring.cannot.be.performed"), false, true);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(elements, project, RefactoringBundle.message("refactoring.cannot.be.performed"), false, notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @NotNull Project project, String messagePrefix) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return element.isWritable() || CommonRefactoringUtil.checkReadOnlyStatus(Collections.singleton(element), project, messagePrefix, false, true);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(elements, project, RefactoringBundle.message("refactoring.cannot.be.performed"), true, false);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(elements, project, RefactoringBundle.message("refactoring.cannot.be.performed"), true, notifyOnFail);
    }

    private static boolean checkReadOnlyStatus(@NotNull Collection<? extends PsiElement> elements, @NotNull Project project, @NotNull String messagePrefix, boolean recursively, boolean notifyOnFail) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (messagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagePrefix", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        THashSet readonly = new THashSet();
        THashSet failed = new THashSet();
        boolean seenNonWritablePsiFilesWithoutVirtualFile = false;
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                VirtualFile virtualFile = dir.getVirtualFile();
                if (virtualFile.getFileSystem().isReadOnly()) {
                    failed.add(virtualFile);
                    continue;
                }
                if (recursively) {
                    CommonRefactoringUtil.collectReadOnlyFiles(virtualFile, (Collection<VirtualFile>)readonly);
                    continue;
                }
                readonly.add(virtualFile);
                continue;
            }
            if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                    VirtualFile virtualFile = directory.getVirtualFile();
                    if (recursively) {
                        if (virtualFile.getFileSystem().isReadOnly()) {
                            failed.add(virtualFile);
                            continue;
                        }
                        CommonRefactoringUtil.collectReadOnlyFiles(virtualFile, (Collection<VirtualFile>)readonly);
                        continue;
                    }
                    if (virtualFile.getFileSystem().isReadOnly()) {
                        failed.add(virtualFile);
                        continue;
                    }
                    readonly.add(virtualFile);
                }
                continue;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null) {
                if (psiElement.isWritable()) continue;
                seenNonWritablePsiFilesWithoutVirtualFile = true;
                continue;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                readonly.add(virtualFile);
                continue;
            }
            if (psiElement.isWritable()) continue;
            seenNonWritablePsiFilesWithoutVirtualFile = true;
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable((Collection<VirtualFile>)readonly);
        ContainerUtil.addAll((Collection)failed, (Object[])status.getReadonlyFiles());
        if (notifyOnFail && (!failed.isEmpty() || seenNonWritablePsiFilesWithoutVirtualFile && readonly.isEmpty())) {
            StringBuilder stringBuilder = new StringBuilder(messagePrefix).append('\n');
            int i = 0;
            for (VirtualFile virtualFile : failed) {
                String subj = RefactoringBundle.message(virtualFile.isDirectory() ? "directory.description" : "file.description", virtualFile.getPresentableUrl());
                if (virtualFile.getFileSystem().isReadOnly()) {
                    stringBuilder.append(RefactoringBundle.message("0.is.located.in.a.jar.file", subj)).append('\n');
                } else {
                    stringBuilder.append(RefactoringBundle.message("0.is.read.only", subj)).append('\n');
                }
                if (i++ <= 20) continue;
                stringBuilder.append("...\n");
                break;
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("error.title"), stringBuilder.toString(), null, project);
            return false;
        }
        return failed.isEmpty();
    }

    public static void collectReadOnlyFiles(@NotNull VirtualFile vFile, final @NotNull Collection<VirtualFile> list) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/refactoring/util/CommonRefactoringUtil", "collectReadOnlyFiles"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/refactoring/util/CommonRefactoringUtil", "collectReadOnlyFiles"));
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/util/CommonRefactoringUtil$4", "visitFile"));
                }
                boolean ignored = fileTypeManager.isFileIgnored(file);
                if (!file.isWritable() && !ignored) {
                    list.add(file);
                }
                return !ignored;
            }
        });
    }

    public static String capitalize(String text) {
        return StringUtil.capitalize((String)text);
    }

    public static boolean isAncestor(PsiElement resolved, Collection<? extends PsiElement> scopes) {
        for (PsiElement psiElement : scopes) {
            if (!PsiTreeUtil.isAncestor(psiElement, resolved, false)) continue;
            return true;
        }
        return false;
    }

    public static class RefactoringErrorHintException
    extends RuntimeException {
        public RefactoringErrorHintException(String message) {
            super(message);
        }
    }
}

