/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.AbstractScrollBarUI;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.TwoWayAnimator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import javax.swing.JComponent;

final class DefaultScrollBarUI
extends AbstractScrollBarUI {
    private static final JBColor THUMB_BACKGROUND = new JBColor(0x808080, 0x808080);
    private static final JBColor THUMB_FOREGROUND = new JBColor(0x6E6E6E, 0x949494);
    private float myTrackValue;
    private float myThumbValue;
    private TwoWayAnimator myTrackAnimator = new TwoWayAnimator("ScrollBarTrack", 6, 300, 300, 1000){

        @Override
        void onFrame(int frame, int maxFrame) {
            DefaultScrollBarUI.this.myTrackValue = (float)frame / (float)maxFrame;
            DefaultScrollBarUI.this.setTrackVisible(frame > 0);
            DefaultScrollBarUI.this.repaint();
        }
    };
    private TwoWayAnimator myThumbAnimator = new TwoWayAnimator("ScrollBarThumb", 5, 125, 300, 1000){

        @Override
        void onFrame(int frame, int maxFrame) {
            DefaultScrollBarUI.this.myThumbValue = (float)frame / (float)maxFrame;
            DefaultScrollBarUI.this.repaint();
        }
    };

    DefaultScrollBarUI() {
    }

    @Override
    int getThickness() {
        return this.scale(14);
    }

    @Override
    int getMinimalThickness() {
        return this.scale(10);
    }

    @Override
    void onTrackHover(boolean hover) {
        if (hover) {
            this.myTrackAnimator.startForward();
        } else {
            this.myTrackAnimator.startBackward();
        }
    }

    @Override
    void onThumbHover(boolean hover) {
        if (hover) {
            this.myThumbAnimator.startForward();
        } else {
            this.myThumbAnimator.startBackward();
        }
    }

    @Override
    void paintTrack(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.1f * this.myTrackValue));
        g.setColor((Color)Gray.x80);
        g.fillRect(x, y, width, height);
        g.setComposite(old);
    }

    @Override
    void paintThumb(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.4f + 0.1f * this.myThumbValue));
        if (!c.isOpaque()) {
            JBScrollBar.Alignment alignment = JBScrollBar.Alignment.get(c);
            if (alignment == JBScrollBar.Alignment.LEFT || alignment == JBScrollBar.Alignment.RIGHT) {
                int offset = width - this.getMinimalThickness();
                if (offset > 0) {
                    offset = (int)((float)offset * (1.0f - this.myThumbValue));
                    width -= offset;
                    if (alignment == JBScrollBar.Alignment.RIGHT) {
                        x += offset;
                    }
                }
            } else {
                int offset = height - this.getMinimalThickness();
                if (offset > 0) {
                    offset = (int)((float)offset * (1.0f - this.myThumbValue));
                    height -= offset;
                    if (alignment == JBScrollBar.Alignment.BOTTOM) {
                        y += offset;
                    }
                }
            }
        }
        g.setColor((Color)THUMB_BACKGROUND);
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor((Color)THUMB_FOREGROUND);
        g.drawRect(x, y, width - 1, height - 1);
        g.setComposite(old);
    }
}

