/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.RegionPainter;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.intellij.lang.annotations.JdkConstants;

public class JBScrollBar
extends JScrollBar {
    public static final Key<RegionPainter<Object>> TRACK = Key.create((String)"JB_SCROLL_BAR_TRACK");

    public JBScrollBar() {
        this(1);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation, int value, int extent, int min, int max) {
        super(orientation, value, extent, min, max);
        this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
    }

    @Override
    public void updateUI() {
        this.setUI(ButtonlessScrollBarUI.createNormal());
    }

    static enum Alignment {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        static Alignment get(JComponent component) {
            if (component instanceof JScrollBar) {
                Object property = component.getClientProperty(Alignment.class);
                if (property instanceof Alignment) {
                    return (Alignment)((Object)property);
                }
                if (component.getParent() instanceof JScrollPane) {
                    switch (((JScrollBar)component).getOrientation()) {
                        case 0: {
                            return BOTTOM;
                        }
                        case 1: {
                            return component.getParent().getComponentOrientation().isLeftToRight() ? RIGHT : LEFT;
                        }
                    }
                }
            }
            return null;
        }
    }
}

