/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.google.common.collect.Iterables;
import com.intellij.dvcs.actions.DvcsCompareWithBranchAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCompareWithBranchAction
extends DvcsCompareWithBranchAction<HgRepository> {
    protected boolean noBranchesToCompare(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "noBranchesToCompare"));
        }
        Map<String, LinkedHashSet<Hash>> branches = repository.getBranches();
        if (branches.size() > 1) {
            return false;
        }
        Hash currentRevisionHash = HgCompareWithBranchAction.getCurrentHash(repository);
        List<HgNameWithHashInfo> other_bookmarks = HgCompareWithBranchAction.getOtherBookmarks(repository, currentRevisionHash);
        if (!other_bookmarks.isEmpty()) {
            return false;
        }
        return HgCompareWithBranchAction.getBranchMainHash(repository, repository.getCurrentBranch()).equals(currentRevisionHash);
    }

    @NotNull
    private static Hash getCurrentHash(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getCurrentHash"));
        }
        String currentRevision = repository.getCurrentRevision();
        assert (currentRevision != null) : "Compare With Branch couldn't be performed for newly created repository";
        Hash hash = HashImpl.build((String)repository.getCurrentRevision());
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getCurrentHash"));
        }
        return hash;
    }

    @NotNull
    private static List<HgNameWithHashInfo> getOtherBookmarks(@NotNull HgRepository repository, final @NotNull Hash currentRevisionHash) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getOtherBookmarks"));
        }
        if (currentRevisionHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRevisionHash", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getOtherBookmarks"));
        }
        List list = ContainerUtil.filter(repository.getBookmarks(), (Condition)new Condition<HgNameWithHashInfo>(){

            public boolean value(HgNameWithHashInfo info) {
                return !info.getHash().equals(currentRevisionHash);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getOtherBookmarks"));
        }
        return list;
    }

    @NotNull
    private static Hash getBranchMainHash(@NotNull HgRepository repository, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getBranchMainHash"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getBranchMainHash"));
        }
        Hash hash = (Hash)ObjectUtils.assertNotNull((Object)Iterables.getLast((Iterable)repository.getBranches().get(branchName)));
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getBranchMainHash"));
        }
        return hash;
    }

    @NotNull
    protected List<String> getBranchNamesExceptCurrent(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getBranchNamesExceptCurrent"));
        }
        ArrayList<String> namesToCompare = new ArrayList<String>(repository.getBranches().keySet());
        String currentBranchName = repository.getCurrentBranchName();
        assert (currentBranchName != null);
        Hash currentBranchHash = HgCompareWithBranchAction.getBranchMainHash(repository, currentBranchName);
        if (currentBranchHash.equals(HgCompareWithBranchAction.getCurrentHash(repository))) {
            namesToCompare.remove(currentBranchName);
        }
        namesToCompare.addAll(HgUtil.getNamesWithoutHashes(HgCompareWithBranchAction.getOtherBookmarks(repository, currentBranchHash)));
        ArrayList<String> arrayList = namesToCompare;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getBranchNamesExceptCurrent"));
        }
        return arrayList;
    }

    @NotNull
    protected HgRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getRepositoryManager"));
        }
        HgRepositoryManager hgRepositoryManager = HgUtil.getRepositoryManager(project);
        if (hgRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getRepositoryManager"));
        }
        return hgRepositoryManager;
    }

    @NotNull
    protected Collection<Change> getDiffChanges(@NotNull Project project, @NotNull VirtualFile file, @NotNull String branchToCompare) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getDiffChanges"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getDiffChanges"));
        }
        if (branchToCompare == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToCompare", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getDiffChanges"));
        }
        HgRepository repository = (HgRepository)this.getRepositoryManager(project).getRepositoryForFile(file);
        if (repository == null) {
            throw new VcsException("Couldn't find repository for " + file.getName());
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        VirtualFile repositoryRoot = repository.getRoot();
        HgFile hgFile = new HgFile(repositoryRoot, filePath);
        HgRevisionNumber compareWithRevisionNumber = HgRevisionNumber.getInstance(branchToCompare, HgCompareWithBranchAction.getBranchMainHash(repository, branchToCompare).toString());
        List changes = HgUtil.getDiff(project, repositoryRoot, filePath, compareWithRevisionNumber, null);
        if (changes.isEmpty() && !HgCompareWithBranchAction.existInBranch(repository, filePath, compareWithRevisionNumber)) {
            throw new VcsException(HgCompareWithBranchAction.fileDoesntExistInBranchError((VirtualFile)file, (String)branchToCompare));
        }
        List list = changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)HgContentRevision.create(project, hgFile, compareWithRevisionNumber)) : changes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "getDiffChanges"));
        }
        return list;
    }

    private static boolean existInBranch(@NotNull HgRepository repository, @NotNull FilePath path, @NotNull HgRevisionNumber compareWithRevisionNumber) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "existInBranch"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "existInBranch"));
        }
        if (compareWithRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compareWithRevisionNumber", "org/zmlx/hg4idea/action/HgCompareWithBranchAction", "existInBranch"));
        }
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(!path.isDirectory()).baseRevision(compareWithRevisionNumber).targetRevision(null).build(repository.getProject());
        statusCommand.cleanFilesOption(true);
        return !statusCommand.execute(repository.getRoot(), Collections.singleton(path)).isEmpty();
    }
}

