/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils.addToStdlib;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.IntProgression;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddToStdlibKt {
    private static final ConcurrentHashMap<Function0<?>, Object> constantMap = new ConcurrentHashMap();

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(T $receiver) {
        return $receiver != null ? Collections.singletonList($receiver) : Collections.emptyList();
    }

    @NotNull
    public static final <T> List<T> singletonList(T $receiver) {
        List<T> list = Collections.singletonList($receiver);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.singletonList(this)");
        return list;
    }

    @NotNull
    public static final <T> Set<T> singletonOrEmptySet(T $receiver) {
        return $receiver != null ? Collections.singleton($receiver) : Collections.emptySet();
    }

    @Nullable
    public static final <T> T firstIsInstanceOrNull(Sequence<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterator<?> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            Object element = iterator2.next();
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static final <T> T firstIsInstanceOrNull(Iterable<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (Object element : $receiver) {
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static final <T> T firstIsInstanceOrNull(Object[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (int i = 0; i < $receiver.length; ++i) {
            Object element = $receiver[i];
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        return null;
    }

    public static final <T> T firstIsInstance(Sequence<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterator<?> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            Object element = iterator2.next();
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    public static final <T> T firstIsInstance(Iterable<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (Object element : $receiver) {
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    public static final <T> T firstIsInstance(Object[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (int i = 0; i < $receiver.length; ++i) {
            Object element = $receiver[i];
            Intrinsics.reifyInstanceof("T");
            if (!(element instanceof Object)) continue;
            return (T)element;
        }
        throw (Throwable)new NoSuchElementException("No element of given type found");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T lastIsInstanceOrNull(Iterable<?> $receiver) {
        T t;
        block5: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Iterable<?> iterable = $receiver;
            if (iterable instanceof List) {
                IntProgression intProgression = RangesKt.reversed((IntProgression)CollectionsKt.getIndices((Collection)$receiver));
                int n = intProgression.getFirst();
                int n2 = intProgression.getLast();
                int n3 = intProgression.getStep();
                int n4 = n;
                int n5 = n2;
                if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                    while (true) {
                        void i;
                        Object element = ((List)$receiver).get((int)i);
                        Intrinsics.reifyInstanceof("T");
                        if (element instanceof Object) {
                            return (T)element;
                        }
                        if (i == n2) break;
                        i += n3;
                    }
                }
                return null;
            }
            Iterable $receiver$iv = CollectionsKt.reversed($receiver);
            for (Object element$iv : $receiver$iv) {
                Intrinsics.reifyInstanceof("T");
                if (!(element$iv instanceof Object)) continue;
                t = element$iv;
                break block5;
            }
            t = null;
        }
        return t;
    }

    @NotNull
    public static final <T> Sequence<T> sequenceOfLazyValues(Function0<? extends T> ... elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return SequencesKt.map(ArraysKt.asSequence((Object[])elements), sequenceOfLazyValues.1.INSTANCE);
    }

    @NotNull
    public static final <T1, T2> Pair<T2, T1> swap(Pair<? extends T1, ? extends T2> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new Pair<T2, T1>($receiver.getSecond(), $receiver.getFirst());
    }

    @Nullable
    public static final <T> T check(T $receiver, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        return (T)(predicate.invoke($receiver) != false ? $receiver : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> T constant(@NotNull Function0<? extends T> calculator) {
        Unit unit;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(calculator, "calculator");
        Object cached = constantMap.get(calculator);
        if (cached != null) {
            Object object = cached;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)object;
        }
        Object[] $receiver$iv = calculator.getClass().getDeclaredFields();
        Object[] objectArray = $receiver$iv;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            Field it = (Field)element$iv$iv;
            if (!((it.getModifiers() & 8) == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fields2 = (List)destination$iv$iv;
        boolean value$iv = fields2.isEmpty();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "No fields in the passed lambda expected but " + CollectionsKt.joinToString$default((Iterable)fields2, null, null, null, 0, null, null, 63) + " found";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        T value = calculator.invoke();
        MapsKt.set(constantMap, calculator, value);
        return value;
    }

    @Nullable
    public static final Integer indexOfOrNull(String $receiver, char c, int startIndex, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int index = StringsKt.indexOf((CharSequence)$receiver, c, startIndex, ignoreCase);
        return index >= 0 ? Integer.valueOf(index) : (Integer)null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Integer indexOfOrNull$default(String string, char c, int n, boolean bl, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return AddToStdlibKt.indexOfOrNull(string, c, n, bl);
    }

    @Nullable
    public static final Integer lastIndexOfOrNull(String $receiver, char c, int startIndex, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int index = StringsKt.lastIndexOf((CharSequence)$receiver, c, startIndex, ignoreCase);
        return index >= 0 ? Integer.valueOf(index) : (Integer)null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Integer lastIndexOfOrNull$default(String string, char c, int n, boolean bl, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return AddToStdlibKt.lastIndexOfOrNull(string, c, n, bl);
    }

    @Nullable
    public static final <T, R> R firstNotNullResult(Iterable<? extends T> $receiver, @NotNull Function1<? super T, ? extends R> transform) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        for (T element : $receiver) {
            R result = transform.invoke(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

