/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitAbortRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitAbortRebaseProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsNotifier myNotifier;
    @Nullable
    private final GitRepository myRepositoryToAbort;
    @NotNull
    private final Map<GitRepository, String> myRepositoriesToRollback;
    @NotNull
    private final ProgressIndicator myIndicator;
    @Nullable
    private final GitChangesSaver mySaver;

    GitAbortRebaseProcess(@NotNull Project project, @Nullable GitRepository repositoryToAbort, @NotNull Map<GitRepository, String> repositoriesToRollback, @NotNull ProgressIndicator progressIndicator, @Nullable GitChangesSaver changesSaver) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitAbortRebaseProcess", "<init>"));
        }
        if (repositoriesToRollback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoriesToRollback", "git4idea/rebase/GitAbortRebaseProcess", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "git4idea/rebase/GitAbortRebaseProcess", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryToAbort = repositoryToAbort;
        this.myRepositoriesToRollback = repositoriesToRollback;
        this.myIndicator = progressIndicator;
        this.mySaver = changesSaver;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    void abortWithConfirmation() {
        LOG.debug("Abort rebase. " + (this.myRepositoryToAbort == null ? "Nothing to abort" : DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort)) + ". Roots to rollback: " + DvcsUtil.joinShortNames(this.myRepositoriesToRollback.keySet()));
        final Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ref.set((Object)GitAbortRebaseProcess.this.confirmAbort());
            }
        }, ModalityState.defaultModalityState());
        LOG.debug("User choice: " + ref.get());
        if (ref.get() == AbortChoice.ROLLBACK_AND_ABORT) {
            this.doAbort(true);
        } else if (ref.get() == AbortChoice.ABORT) {
            this.doAbort(false);
        }
    }

    @NotNull
    private AbortChoice confirmAbort() {
        String title = "Abort Rebase";
        if (this.myRepositoryToAbort != null) {
            if (this.myRepositoriesToRollback.isEmpty()) {
                String message = "Are you sure you want to abort rebase" + GitUtil.mention(this.myRepositoryToAbort) + "?";
                int choice = DialogManager.showOkCancelDialog(this.myProject, message, title, "Abort", CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
                if (choice == 0) {
                    AbortChoice abortChoice = AbortChoice.ABORT;
                    if (abortChoice == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitAbortRebaseProcess", "confirmAbort"));
                    }
                    return abortChoice;
                }
            } else {
                String message = "Do you want just to abort rebase" + GitUtil.mention(this.myRepositoryToAbort) + ",\n" + "or also rollback the successful rebase" + GitUtil.mention(this.myRepositoriesToRollback.keySet()) + "?";
                int choice = DialogManager.showYesNoCancelDialog(this.myProject, message, title, "Abort & Rollback", "Abort", CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
                if (choice == 0) {
                    AbortChoice abortChoice = AbortChoice.ROLLBACK_AND_ABORT;
                    if (abortChoice == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitAbortRebaseProcess", "confirmAbort"));
                    }
                    return abortChoice;
                }
                if (choice == 1) {
                    AbortChoice abortChoice = AbortChoice.ABORT;
                    if (abortChoice == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitAbortRebaseProcess", "confirmAbort"));
                    }
                    return abortChoice;
                }
            }
        } else if (this.myRepositoriesToRollback.isEmpty()) {
            LOG.error(new Throwable());
        } else {
            String description = "Do you want rollback the successful rebase" + GitUtil.mention(this.myRepositoriesToRollback.keySet()) + "?";
            int choice = DialogManager.showOkCancelDialog(this.myProject, description, title, "Rollback", CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
            if (choice == 0) {
                AbortChoice abortChoice = AbortChoice.ROLLBACK_AND_ABORT;
                if (abortChoice == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitAbortRebaseProcess", "confirmAbort"));
                }
                return abortChoice;
            }
        }
        AbortChoice abortChoice = AbortChoice.CANCEL;
        if (abortChoice == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitAbortRebaseProcess", "confirmAbort"));
        }
        return abortChoice;
    }

    private void doAbort(final boolean rollback) {
        new GitFreezingProcess(this.myProject, (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class), "rebase", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)GitAbortRebaseProcess.this.myProject);
                ArrayList repositoriesToRefresh = ContainerUtil.newArrayList();
                try {
                    if (GitAbortRebaseProcess.this.myRepositoryToAbort != null) {
                        GitAbortRebaseProcess.this.myIndicator.setText2("git rebase --abort" + GitUtil.mention(GitAbortRebaseProcess.this.myRepositoryToAbort));
                        GitCommandResult result = GitAbortRebaseProcess.this.myGit.rebase(GitAbortRebaseProcess.this.myRepositoryToAbort, GitRebaseParams.abort(), new GitLineHandlerListener[0]);
                        repositoriesToRefresh.add(GitAbortRebaseProcess.this.myRepositoryToAbort);
                        if (!result.success()) {
                            GitAbortRebaseProcess.this.myNotifier.notifyError("Rebase Abort Failed", result.getErrorOutputAsHtmlString() + GitRebaseUtils.mentionLocalChangesRemainingInStash(GitAbortRebaseProcess.this.mySaver));
                            return;
                        }
                    }
                    if (rollback) {
                        for (GitRepository repo : GitAbortRebaseProcess.this.myRepositoriesToRollback.keySet()) {
                            GitAbortRebaseProcess.this.myIndicator.setText2("git reset --keep" + GitUtil.mention(repo));
                            GitCommandResult res = GitAbortRebaseProcess.this.myGit.reset(repo, GitResetMode.KEEP, (String)GitAbortRebaseProcess.this.myRepositoriesToRollback.get(repo), new GitLineHandlerListener[0]);
                            repositoriesToRefresh.add(repo);
                            if (res.success()) continue;
                            String description = GitAbortRebaseProcess.this.myRepositoryToAbort != null ? "Rebase abort was successful" + GitUtil.mention(GitAbortRebaseProcess.this.myRepositoryToAbort) + ", but rollback failed" : "Rollback failed";
                            description = description + GitUtil.mention(repo) + ":" + res.getErrorOutputAsHtmlString() + GitRebaseUtils.mentionLocalChangesRemainingInStash(GitAbortRebaseProcess.this.mySaver);
                            GitAbortRebaseProcess.this.myNotifier.notifyImportantWarning("Rebase Rollback Failed", description);
                            return;
                        }
                    }
                    if (GitAbortRebaseProcess.this.mySaver != null) {
                        GitAbortRebaseProcess.this.mySaver.load();
                    }
                    GitAbortRebaseProcess.this.myNotifier.notifySuccess("Rebase abort succeeded");
                }
                finally {
                    GitAbortRebaseProcess.refresh(repositoriesToRefresh);
                    DvcsUtil.workingTreeChangeFinished((Project)GitAbortRebaseProcess.this.myProject, (AccessToken)token);
                }
            }
        }).execute();
    }

    private static void refresh(@NotNull List<GitRepository> toRefresh) {
        if (toRefresh == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRefresh", "git4idea/rebase/GitAbortRebaseProcess", "refresh"));
        }
        for (GitRepository repository : toRefresh) {
            repository.update();
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(GitUtil.getRootsFromRepositories(toRefresh)));
    }

    static enum AbortChoice {
        ABORT,
        ROLLBACK_AND_ABORT,
        CANCEL;

    }
}

