/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.rebase.GitAbortRebaseProcess;
import git4idea.rebase.GitRebaseProcess;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseUtils {
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUtils.class.getName());

    private GitRebaseUtils() {
    }

    public static void rebase(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull GitRebaseParams params, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseUtils", "rebase"));
        }
        if (!GitRebaseUtils.isRebaseAllowed(project, repositories)) {
            return;
        }
        new GitRebaseProcess(project, repositories, params, indicator).rebase();
    }

    public static void abort(@NotNull Project project, @Nullable GitRepository repositoryToAbort, @NotNull Map<GitRepository, String> repositoriesToRollback, @NotNull ProgressIndicator progressIndicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "abort"));
        }
        if (repositoriesToRollback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoriesToRollback", "git4idea/rebase/GitRebaseUtils", "abort"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "git4idea/rebase/GitRebaseUtils", "abort"));
        }
        new GitAbortRebaseProcess(project, repositoryToAbort, repositoriesToRollback, progressIndicator, null).abortWithConfirmation();
    }

    private static boolean isRebaseAllowed(@NotNull Project project, @NotNull Collection<GitRepository> repositories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseUtils", "isRebaseAllowed"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseUtils", "isRebaseAllowed"));
        }
        for (GitRepository repository : repositories) {
            Repository.State state = repository.getState();
            String in = GitUtil.mention(repository);
            String message = null;
            switch (state) {
                case NORMAL: {
                    if (!repository.isFresh()) break;
                    message = "Repository" + in + " is empty.";
                    break;
                }
                case MERGING: {
                    message = "There is an unfinished merge process" + in + ".<br/>You should complete the merge before starting a rebase";
                    break;
                }
                case REBASING: {
                    message = "There is an unfinished rebase process" + in + ".<br/>You should complete it before starting another rebase";
                    break;
                }
                case GRAFTING: {
                    message = "There is an unfinished cherry-pick process" + in + ".<br/>You should finish it before starting a rebase.";
                    break;
                }
                case DETACHED: {
                    message = "You are in the detached HEAD state" + in + ".<br/>Rebase is not possible.";
                    break;
                }
                default: {
                    LOG.error("Unknown state [" + state.name() + "]");
                    message = "Rebase is not possible" + in;
                }
            }
            if (message == null) continue;
            VcsNotifier.getInstance((Project)project).notifyError("Rebase not Allowed", message);
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isRebaseInTheProgress(VirtualFile root) {
        return GitRebaseUtils.getRebaseDir(root) != null;
    }

    @Nullable
    private static File getRebaseDir(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaseUtils", "getRebaseDir"));
        }
        File gitDir = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), ".git");
        File f = new File(gitDir, "rebase-apply");
        if (f.exists()) {
            return f;
        }
        f = new File(gitDir, "rebase-merge");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CommitInfo getCurrentRebaseCommit(@NotNull VirtualFile root) {
        int next;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/rebase/GitRebaseUtils", "getCurrentRebaseCommit"));
        }
        File rebaseDir = GitRebaseUtils.getRebaseDir(root);
        if (rebaseDir == null) {
            LOG.warn("No rebase dir found for " + root.getPath());
            return null;
        }
        File nextFile = new File(rebaseDir, "next");
        try {
            next = Integer.parseInt(FileUtil.loadFile((File)nextFile, (Charset)CharsetToolkit.UTF8_CHARSET).trim());
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + nextFile.getPath(), (Throwable)e);
            return null;
        }
        File commitFile = new File(rebaseDir, String.format("%04d", next));
        String hash = null;
        String subject = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(commitFile), CharsetToolkit.UTF8_CHARSET));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("From ")) {
                        hash = line.substring(5, 45);
                    }
                    if (line.startsWith("Subject: ")) {
                        subject = line.substring("Subject: ".length());
                    }
                    if (hash == null || subject == null) continue;
                    break;
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + commitFile, (Throwable)e);
            return null;
        }
        if (subject == null || hash == null) {
            LOG.info("Unable to extract information from " + commitFile + " " + hash + ": " + subject);
            return null;
        }
        return new CommitInfo(new GitRevisionNumber(hash), subject);
    }

    @NotNull
    static String mentionLocalChangesRemainingInStash(@Nullable GitChangesSaver saver) {
        String string = saver != null && saver.wereChangesSaved() ? "<br/>Note that some local changes were <a href='stash'>" + GitRebaseUtils.toPast(saver.getOperationName()) + "</a> before rebase." : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseUtils", "mentionLocalChangesRemainingInStash"));
        }
        return string;
    }

    @NotNull
    private static String toPast(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "git4idea/rebase/GitRebaseUtils", "toPast"));
        }
        String string = word.endsWith("e") ? word + "d" : word + "ed";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseUtils", "toPast"));
        }
        return string;
    }

    public static class CommitInfo {
        public final GitRevisionNumber revision;
        public final String subject;

        public CommitInfo(GitRevisionNumber revision, String subject) {
            this.revision = revision;
            this.subject = subject;
        }

        public String toString() {
            return this.revision.toString();
        }
    }
}

