/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBLoadingPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LoadingCallback<T>
implements FutureCallback<T> {
    @Nullable
    private final Logger myLogger;
    @Nullable
    private final LoadingDone myLoading;

    public LoadingCallback(@Nullable Logger logger) {
        this.myLogger = logger;
        this.myLoading = null;
    }

    public LoadingCallback(@Nullable Logger logger, JBLoadingPanel loading) {
        this.myLogger = logger;
        this.myLoading = new LoadingDonePanel(loading);
    }

    public LoadingCallback(@Nullable Logger logger, @Nullable LoadingDone loading) {
        this.myLogger = logger;
        this.myLoading = loading;
    }

    public void onFailure(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/editors/gfxtrace/LoadingCallback", "onFailure"));
        }
        if (this.myLogger != null) {
            this.myLogger.error(t);
        }
        if (this.myLoading != null) {
            this.myLoading.stopLoading();
        }
    }

    private static class LoadingDonePanel
    implements LoadingDone {
        @Nullable
        private final JBLoadingPanel myLoadingPanel;

        private LoadingDonePanel(@Nullable JBLoadingPanel loadingPanel) {
            this.myLoadingPanel = loadingPanel;
        }

        @Override
        public void stopLoading() {
            if (this.myLoadingPanel != null) {
                this.myLoadingPanel.stopLoading();
            }
        }
    }

    public static interface LoadingDone {
        public void stopLoading();
    }
}

