/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import kotlin.IntProgression;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaDecompiler;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.LegalNoticeDialog;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!5Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t%\u0015\t\u0001bB\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0011\u0005)\u0011\u0001\u0002\u0002\r\u0001Aq\u0011$\u0001M\u0001;\tqibd\b\"\u0006E\u001b\u0011\u0001C\u0001&\u0011\u0011Y\u0001RC\u0007\u00021\u0017I2\u0001C\u0006\u000e\u0003a\u0015Q\u0005\u0003\u0003\u0002\u0011/i\u0011\u0001\u0007\u0003\u001a\u0007!YQ\"\u0001M\u0003K%!9\u0001\u0003\u0007\u000e\u00051\u0005\u0001DC\r\u0004\u0011-i\u0011\u0001'\u0002&\u0011\u0011Y\u0001\u0012D\u0007\u00021\u0011I2\u0001C\u0006\u000e\u0003a\u0015Q\u0005\u0002\u0003\u0002\u00115i\u0011\u0001g\u0007*<\u0011\t\u0005\u0002c\u0001\u000e0%1\u0011\"\u0002\t\u0004+\ta\t\u0001'\u0002\u0019\u0006%a\u0011bC\u0005\u0003\u0013\u0005AB\u0001E\u0002\u0016\u000b%\u0011\u0011\"\u0001\r\u0005\u0019\u0003A:\u0001g\u0002\u0019\u0005E\u001b\u0011\u0001\"\u0003R\u0007\u0005)\u0001!K\u0005\u0005\u0004rAQ!D\u0001\u0019\fq\t\u0001%A)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!1Q\u0002B\u0005\u0003\u0013\u0005Ar\u0001'\u0004R\u0007\u0005)\u0001!\u000b\t\u0005\u0003\"Ay!\u0004\u0006\n\u0011%9\u0011BA\u0005\u00021#I!!C\u0001\u0019\u0013aA\u0001TB)\u0004\u0003\u0015\u0001\u0011v\u0006\u0003B\u0011!MQ2E\u0005\u0007\u0013\u0015\u00012!\u0006\u0002\r\u0002a\u0015\u0001TA\u0005\u0007\u0013\u0015\u00012!\u0006\u0002\r\u0002aQ\u0001D\u0003\r\u0003#\u000e\tA\u0011B)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/java/decompiler/IdeaDecompiler;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Light;", "()V", "myFutures", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/Future;", "", "Lorg/jetbrains/annotations/NotNull;", "myLegalNoticeAccepted", "", "myLogger", "Lkotlin/Lazy;", "Lorg/jetbrains/java/decompiler/IdeaLogger;", "myOptions", "", "", "", "myProgress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "accepts", "file", "decompile", "getProgress", "getText", "intercept", "", "Companion", "ExactMatchLineNumbersMapping", "MyBytecodeProvider", "MyResultSaver"}, moduleName="java-decompiler-plugin")
public final class IdeaDecompiler
extends ClassFileDecompilers.Light {
    private final Lazy<IdeaLogger> myLogger = LazyKt.lazy((Function0)myLogger.1.INSTANCE);
    private final Lazy<Map<String, Object>> myOptions = LazyKt.lazy((Function0)myOptions.1.INSTANCE);
    private final ConcurrentMap<VirtualFile, ProgressIndicator> myProgress = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<VirtualFile, Future<CharSequence>> myFutures = ContainerUtil.newConcurrentMap();
    private volatile boolean myLegalNoticeAccepted;
    @NotNull
    public static final String BANNER = "//\n// Source code recreated from a .class file by IntelliJ IDEA\n// (powered by Fernflower decompiler)\n//\n\n";
    private static final String LEGAL_NOTICE_KEY = "decompiler.legal.notice.accepted";
    public static final Companion Companion = org.jetbrains.java.decompiler.IdeaDecompiler$Companion.INSTANCE;

    private final void intercept() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before.Adapter(this, app, connection){
            final /* synthetic */ IdeaDecompiler this$0;
            final /* synthetic */ Application $app;
            final /* synthetic */ MessageBusConnection $connection;

            public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (!IdeaDecompiler.access$getMyLegalNoticeAccepted$p(this.this$0) && file.getFileType() == StdFileTypes.CLASS && ClassFileDecompilers.find((VirtualFile)file) == this.this$0) {
                    IdeaDecompiler.access$getMyFutures$p(this.this$0).put(file, this.$app.executeOnPooledThread((Callable)new Callable<CharSequence>(this, file){
                        final /* synthetic */ intercept.1 this$0;
                        final /* synthetic */ VirtualFile $file;

                        @NotNull
                        public final CharSequence call() {
                            return IdeaDecompiler.access$decompile(this.this$0.this$0, this.$file);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$file = virtualFile;
                        }
                    }));
                    LegalNoticeDialog dialog = new LegalNoticeDialog(source.getProject(), file);
                    dialog.show();
                    switch (dialog.getExitCode()) {
                        case 0: {
                            PropertiesComponent.getInstance().setValue(org.jetbrains.java.decompiler.IdeaDecompiler$Companion.access$getLEGAL_NOTICE_KEY$p(IdeaDecompiler.Companion), true);
                            IdeaDecompiler.access$setMyLegalNoticeAccepted$p(this.this$0, true);
                            this.$app.invokeLater(new Runnable(this, file){
                                final /* synthetic */ intercept.1 this$0;
                                final /* synthetic */ VirtualFile $file;

                                public final void run() {
                                    RefreshQueue.getInstance().processSingleEvent((VFileEvent)new VFileContentChangeEvent((Object)((Object)this.this$0.this$0), this.$file, this.$file.getModificationStamp(), (long)(-1), false));
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$file = virtualFile;
                                }
                            }, ModalityState.any());
                            this.$connection.disconnect();
                            break;
                        }
                        case 2: {
                            Future future = (Future)IdeaDecompiler.access$getMyFutures$p(this.this$0).remove(file);
                            Boolean bl = future != null ? Boolean.valueOf(future.cancel(true)) : null;
                            PluginManagerCore.disablePlugin((String)"org.jetbrains.java.decompiler");
                            ApplicationManagerEx.getApplicationEx().restart(true);
                            break;
                        }
                        case 1: {
                            Future future = (Future)IdeaDecompiler.access$getMyFutures$p(this.this$0).remove(file);
                            Boolean bl = future != null ? Boolean.valueOf(future.cancel(true)) : null;
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$app = $captured_local_variable$1;
                this.$connection = $captured_local_variable$2;
            }
        });
    }

    public boolean accepts(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return true;
    }

    @NotNull
    public CharSequence getText(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.myLegalNoticeAccepted) {
            object = (Future)this.myFutures.remove(file);
            if (object == null || (object = (CharSequence)object.get()) == null) {
                object = this.decompile(file);
            }
        } else {
            CharSequence charSequence = ClsFileImpl.decompile((VirtualFile)file);
            object = charSequence;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"ClsFileImpl.decompile(file)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CharSequence decompile(VirtualFile file) {
        if (Intrinsics.areEqual((Object)"package-info.class", (Object)file.getName())) {
            CharSequence charSequence = ClsFileImpl.decompile((VirtualFile)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"ClsFileImpl.decompile(file)");
            return charSequence;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            this.myProgress.put(file, indicator);
        }
        try {
            void $receiver$iv;
            Object item$iv$iv2;
            Collection destination$iv$iv;
            VirtualFile it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv2;
            String mask = file.getNameWithoutExtension() + "$";
            Object[] objectArray = file.getParent().getChildren();
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)file.getPath(), (Object)file));
            void var6_9 = $receiver$iv2;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                it = (VirtualFile)element$iv$iv;
                if (!(StringsKt.startsWith$default((String)it.getNameWithoutExtension(), (String)mask, (boolean)false, (int)2) && it.getFileType() == StdFileTypes.CLASS)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Pair> collection2 = (List)destination$iv$iv;
            $receiver$iv2 = collection2;
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                it = (VirtualFile)item$iv$iv2;
                collection2 = destination$iv$iv;
                Pair pair = TuplesKt.to((Object)it.getPath(), (Object)it);
                collection2.add(pair);
            }
            collection2 = (List)destination$iv$iv;
            Map files = MapsKt.plus((Map)map, (Iterable)collection2);
            HashMap<String, String> options = new HashMap<String, String>((Map)this.myOptions.getValue());
            if (Registry.is((String)"decompiler.use.line.mapping")) {
                options.put("bsm", "1");
            }
            if (Registry.is((String)"decompiler.dump.original.lines")) {
                options.put("__dump_original_lines__", "1");
            }
            MyBytecodeProvider provider = new MyBytecodeProvider(files);
            MyResultSaver saver = new MyResultSaver();
            BaseDecompiler decompiler = new BaseDecompiler(provider, saver, (Map<String, Object>)options, (IFernflowerLogger)this.myLogger.getValue());
            item$iv$iv2 = files.keySet();
            for (Object element$iv : $receiver$iv) {
                String path = (String)element$iv;
                decompiler.addSpace(new File(path), true);
            }
            decompiler.decompileContext();
            int[] mapping = saver.getMyMapping();
            if (mapping != null) {
                file.putUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY, (Object)new ExactMatchLineNumbersMapping(mapping));
            }
            CharSequence charSequence = saver.getMyResult();
            return charSequence;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)((Object)new AssertionError(file.getUrl(), e));
            }
            throw (Throwable)new ClassFileDecompilers.Light.CannotDecompileException((Throwable)e);
        }
        finally {
            this.myProgress.remove(file);
        }
    }

    @Nullable
    public final ProgressIndicator getProgress(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return (ProgressIndicator)this.myProgress.get(file);
    }

    public IdeaDecompiler() {
        boolean bl = this.myLegalNoticeAccepted = ApplicationManager.getApplication().isUnitTestMode() || PropertiesComponent.getInstance().isValueSet(IdeaDecompiler.Companion.getLEGAL_NOTICE_KEY());
        if (!this.myLegalNoticeAccepted) {
            this.intercept();
        }
    }

    static {
        LEGAL_NOTICE_KEY = LEGAL_NOTICE_KEY;
    }

    public static final /* synthetic */ boolean access$getMyLegalNoticeAccepted$p(IdeaDecompiler $this) {
        return $this.myLegalNoticeAccepted;
    }

    public static final /* synthetic */ void access$setMyLegalNoticeAccepted$p(IdeaDecompiler $this, boolean bl) {
        $this.myLegalNoticeAccepted = bl;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap access$getMyFutures$p(IdeaDecompiler $this) {
        return $this.myFutures;
    }

    @NotNull
    public static final /* synthetic */ CharSequence access$decompile(IdeaDecompiler $this, @NotNull VirtualFile file) {
        return $this.decompile(file);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t%\u0015\t\u0001bB\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!IQ!\u0001\u0003\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005f\u0011\"\u0003\u0005\u0002\u001b\u001dI!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001M\u00031\u0007\t6!\u0001\u0005\u0004K5!1\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005A\"!\u0007\u0003\t\u000b5\u0011A\u0012\u0001\r\u0003S5!\u0011\t\u0003\u0005\u0002\u001b\u001dI!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001M\u00031\u0007\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyBytecodeProvider;", "Lorg/jetbrains/java/decompiler/main/extern/IBytecodeProvider;", "files", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/Map;)V", "getBytecode", "", "externalPath", "internalPath"}, moduleName="java-decompiler-plugin")
    private static final class MyBytecodeProvider
    implements IBytecodeProvider {
        private final Map<String, VirtualFile> files;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public byte[] getBytecode(@NotNull String externalPath, @Nullable String internalPath) {
            Unit unit;
            Intrinsics.checkParameterIsNotNull((Object)externalPath, (String)"externalPath");
            String path = FileUtil.toSystemIndependentName((String)externalPath);
            VirtualFile file = this.files.get(path);
            boolean bl = file != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = path + " not in " + this.files.keySet();
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = virtualFile.contentsToByteArray(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file!!.contentsToByteArray(false)");
            return byArray;
        }

        public MyBytecodeProvider(@NotNull Map<String, ? extends VirtualFile> files) {
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            this.files = files;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!UQ!\u0001C\u0003\u000b\u0005Aq!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0002\t\u0013)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dA!\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u0007\u0005\u0017!=Q\"\u0001\r\t3\rA\t\"D\u0001\u0019\u000be\u0019\u0001\"C\u0007\u00021\u0015)C\u0003B\u0006\t\u00145\t\u0001\u0004C\r\u0004\u0011)i\u0011\u0001G\u0003\u001a\u0007!EQ\"\u0001\r\u00063\rA\u0011\"D\u0001\u0019\u000be\u0019\u0001RC\u0007\u00021\u0015)\u0003\u0003B\u0006\t\u00175\t\u0001\u0004C\r\u0004\u0011)i\u0011\u0001G\u0003\u001a\u0007!EQ\"\u0001\r\u00063\rA9\"D\u0001\u0019\u000b\u0015\u0002Ba\u0003\u0005\r\u001b\u0005A\u0002\"G\u0002\t\u00125\t\u0001$B\r\u0004\u0011%i\u0011\u0001G\u0003\u001a\u0007!eQ\"\u0001\r\u000eKa!1\u0002c\u0007\u000e\u0003aA\u0011d\u0001E\t\u001b\u0005AR!G\u0002\t\u00135\t\u0001$B\r\u0004\u00119i\u0011\u0001G\u0003\u001a\u0007!]Q\"\u0001\r\u00063\rAi\"D\u0001\u0019\u000b\u0015JBa\u0003\u0005\u0010\u001b\u0005A\u0002\"G\u0002\t\u00125\t\u0001$B\r\u0004\u00119i\u0011\u0001G\u0003\u001a\u0007!]Q\"\u0001\r\u00063\rAi\"D\u0001\u0019\u000be!\u0001rD\u0007\u0003\u0019\u0003A\"!\n\t\u0005\u0017!\u0001R\"\u0001\r\t3\rA\t\"D\u0001\u0019\u000be\u0019\u0001\"C\u0007\u00021\u0015I2\u0001c\u0006\u000e\u0003a)Q\u0005\u0003\u0003\f\u0011Ci\u0011\u0001\u0007\u0005\u001a\u0007!EQ\"\u0001\r\u0006S9!1\t\bE\u0002\u001b\ta\t\u0001\u0007\u0002R\u0007\u001d)\u0001!\u0004\u0002\u0005\u0006!\u0019\u0011C\u0001C\u0004\u0011\u0011IS\u0002B\"\u001d\u0011\u0013i\u0011\u0001G\u0003R\u0007\u001d)\u0001!\u0004\u0002\u0005\f!1\u0011C\u0001C\u0007\u0011\u001d\u0001"}, strings={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "()V", "myMapping", "", "getMyMapping", "()[I", "setMyMapping", "([I)V", "myResult", "", "getMyResult", "()Ljava/lang/String;", "setMyResult", "(Ljava/lang/String;)V", "closeArchive", "", "path", "archiveName", "copyEntry", "source", "entry", "copyFile", "entryName", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassEntry", "qualifiedName", "content", "saveClassFile", "mapping", "saveDirEntry", "saveFolder"}, moduleName="java-decompiler-plugin")
    private static final class MyResultSaver
    implements IResultSaver {
        @NotNull
        private String myResult = "";
        @Nullable
        private int[] myMapping;

        @NotNull
        public final String getMyResult() {
            return this.myResult;
        }

        public final void setMyResult(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.myResult = string;
        }

        @Nullable
        public final int[] getMyMapping() {
            return this.myMapping;
        }

        public final void setMyMapping(@Nullable int[] nArray) {
            this.myMapping = nArray;
        }

        @Override
        public void saveClassFile(@NotNull String path, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content, @Nullable int[] mapping) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            if (StringsKt.isEmpty((CharSequence)this.myResult)) {
                this.myResult = content;
                this.myMapping = mapping;
            }
        }

        @Override
        public void saveFolder(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        }

        @Override
        public void copyFile(@NotNull String source, @NotNull String path, @NotNull String entryName) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
        }

        @Override
        public void createArchive(@NotNull String path, @NotNull String archiveName, @NotNull Manifest manifest) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        }

        @Override
        public void saveDirEntry(@NotNull String path, @NotNull String archiveName, @NotNull String entryName) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
        }

        @Override
        public void copyEntry(@NotNull String source, @NotNull String path, @NotNull String archiveName, @NotNull String entry) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        }

        @Override
        public void saveClassEntry(@NotNull String path, @NotNull String archiveName, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        }

        @Override
        public void closeArchive(@NotNull String path, @NotNull String archiveName) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0016\u0015\tA!A\u0003\u0002\u0011\u0011)\u0011\u0001B\u0001\u0005\u00031\u0001\u0011$\u0001M\u0001C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015BAa\u0003E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001dA\u0013\t\t-AA!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\rIs\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$ExactMatchLineNumbersMapping;", "Lcom/intellij/execution/filters/LineNumbersMapping;", "mapping", "", "([I)V", "bytecodeToSource", "", "line", "sourceToBytecode"}, moduleName="java-decompiler-plugin")
    private static final class ExactMatchLineNumbersMapping
    implements LineNumbersMapping {
        private final int[] mapping;

        /*
         * WARNING - void declaration
         */
        public int bytecodeToSource(int line) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)ArraysKt.getIndices((int[])this.mapping)), (int)2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    if (this.mapping[i] == line) {
                        return this.mapping[i + true];
                    }
                    if (i == n2) break;
                    n = i + n3;
                }
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        public int sourceToBytecode(int line) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)ArraysKt.getIndices((int[])this.mapping)), (int)2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    if (this.mapping[i + true] == line) {
                        return this.mapping[i];
                    }
                    if (i == n2) break;
                    n = i + n3;
                }
            }
            return -1;
        }

        public ExactMatchLineNumbersMapping(@NotNull int[] mapping) {
            Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
            this.mapping = mapping;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0003\u000b\u0005A!\u0003Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015RA!\u0001E\u0005\u001b\u001dI!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001M\u00011\u0015I;\u0002B\"i\u0003!\rQ\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!)\u0001C\u0002*\u0018\u0011\t\u0005*\u0001E\u0004\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\t!\u0019\u0001"}, strings={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$Companion;", "", "()V", "BANNER", "", "getBANNER", "()Ljava/lang/String;", "LEGAL_NOTICE_KEY", "getLEGAL_NOTICE_KEY", "getOptions", ""}, moduleName="java-decompiler-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getBANNER() {
            return BANNER;
        }

        private final String getLEGAL_NOTICE_KEY() {
            return LEGAL_NOTICE_KEY;
        }

        private final Map<String, Object> getOptions() {
            Project project = DefaultProjectFactory.getInstance().getDefaultProject();
            CommonCodeStyleSettings.IndentOptions options = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getIndentOptions((FileType)JavaFileType.INSTANCE);
            String indent = StringUtil.repeat((String)" ", (int)options.INDENT_SIZE);
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"hdc", (Object)"0"), TuplesKt.to((Object)"dgs", (Object)"1"), TuplesKt.to((Object)"rsy", (Object)"1"), TuplesKt.to((Object)"rbr", (Object)"1"), TuplesKt.to((Object)"lit", (Object)"1"), TuplesKt.to((Object)"nls", (Object)"1"), TuplesKt.to((Object)"ban", (Object)this.getBANNER()), TuplesKt.to((Object)"mpm", (Object)60), TuplesKt.to((Object)"ind", (Object)indent), TuplesKt.to((Object)"__unit_test_mode__", (Object)(ApplicationManager.getApplication().isUnitTestMode() ? "1" : "0"))});
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }

        @NotNull
        public static final /* synthetic */ Map access$getOptions(Companion $this) {
            return $this.getOptions();
        }
    }
}

