/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.IdeaDecompilerBundle;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQ\u0005\u0003\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004K)!\u0011\u0001c\u0002\u000e\u00051\u0005\u0001\u0004B\r\u0005\u0011\u0013i!\u0001$\u0001\u0019\u000b\u0015JA!\u0001E\u0006\u001b\ta\t\u0001G\u0003\u001a\u0007!\u0015Q\"\u0001\r\u0004K!!1\u0002\u0003\u0004\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2\u0001"}, strings={"Lorg/jetbrains/java/decompiler/ShowDecompiledClassAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getOriginalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getPsiElement", "update"}, moduleName="java-decompiler-plugin")
public final class ShowDecompiledClassAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiElement psiElement2 = psiElement = this.getPsiElement(e);
        boolean visible = (psiElement2 != null ? psiElement2.getContainingFile() : null) instanceof PsiClassOwner;
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && this.getOriginalFile(psiElement) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null && (file = this.getOriginalFile(this.getPsiElement(e))) != null) {
            new OpenFileDescriptor(project, file, -1).navigate(true);
        }
    }

    private final PsiElement getPsiElement(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        }
        Editor editor2 = editor;
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project2);
        return psiFile != null ? psiFile.findElementAt(editor2.getCaretModel().getOffset()) : null;
    }

    private final VirtualFile getOriginalFile(PsiElement psiElement) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        PsiClass psiClass2 = psiClass;
        VirtualFile file = psiClass2 != null && (psiClass2 = psiClass2.getOriginalElement()) != null && (psiClass2 = psiClass2.getContainingFile()) != null ? psiClass2.getVirtualFile() : null;
        return file != null && Intrinsics.areEqual((Object)file.getFileType(), (Object)JavaClassFileType.INSTANCE) ? file : (VirtualFile)null;
    }

    public ShowDecompiledClassAction() {
        super(IdeaDecompilerBundle.message("action.show.decompiled.name", new Object[0]));
    }
}

