/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.application.options.editor.ExcludeTable;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class JavaAutoImportOptions
implements AutoImportOptionsProvider {
    private static final String INSERT_IMPORTS_ALWAYS = ApplicationBundle.message((String)"combobox.insert.imports.all", (Object[])new Object[0]);
    private static final String INSERT_IMPORTS_ASK = ApplicationBundle.message((String)"combobox.insert.imports.ask", (Object[])new Object[0]);
    private static final String INSERT_IMPORTS_NONE = ApplicationBundle.message((String)"combobox.insert.imports.none", (Object[])new Object[0]);
    private JComboBox mySmartPasteCombo;
    private JCheckBox myCbShowImportPopup;
    private JPanel myWholePanel;
    private JCheckBox myCbAddUnambiguousImports;
    private JCheckBox myCbOptimizeImports;
    private JPanel myExcludeFromImportAndCompletionPanel;
    private final ExcludeTable myExcludePackagesTable;

    public JavaAutoImportOptions(Project project2) {
        this.$$$setupUI$$$();
        this.mySmartPasteCombo.addItem(INSERT_IMPORTS_ALWAYS);
        this.mySmartPasteCombo.addItem(INSERT_IMPORTS_ASK);
        this.mySmartPasteCombo.addItem(INSERT_IMPORTS_NONE);
        this.myExcludePackagesTable = new ExcludeTable(project2);
        this.myExcludeFromImportAndCompletionPanel.add((Component)this.myExcludePackagesTable.getComponent(), "Center");
    }

    public void addExcludePackage(String packageName) {
        this.myExcludePackagesTable.addExcludePackage(packageName);
    }

    public void reset() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        DaemonCodeAnalyzerSettings daemonSettings = DaemonCodeAnalyzerSettings.getInstance();
        switch (codeInsightSettings.ADD_IMPORTS_ON_PASTE) {
            case 1: {
                this.mySmartPasteCombo.setSelectedItem(INSERT_IMPORTS_ALWAYS);
                break;
            }
            case 2: {
                this.mySmartPasteCombo.setSelectedItem(INSERT_IMPORTS_NONE);
                break;
            }
            case 3: {
                this.mySmartPasteCombo.setSelectedItem(INSERT_IMPORTS_ASK);
            }
        }
        this.myCbShowImportPopup.setSelected(daemonSettings.isImportHintEnabled());
        this.myCbOptimizeImports.setSelected(codeInsightSettings.OPTIMIZE_IMPORTS_ON_THE_FLY);
        this.myCbAddUnambiguousImports.setSelected(codeInsightSettings.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY);
        this.myExcludePackagesTable.reset();
    }

    public void disposeUIResources() {
    }

    public void apply() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        DaemonCodeAnalyzerSettings daemonSettings = DaemonCodeAnalyzerSettings.getInstance();
        codeInsightSettings.ADD_IMPORTS_ON_PASTE = this.getSmartPasteValue();
        daemonSettings.setImportHintEnabled(this.myCbShowImportPopup.isSelected());
        codeInsightSettings.OPTIMIZE_IMPORTS_ON_THE_FLY = this.myCbOptimizeImports.isSelected();
        codeInsightSettings.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY = this.myCbAddUnambiguousImports.isSelected();
        this.myExcludePackagesTable.apply();
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
    }

    public JComponent createComponent() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        DaemonCodeAnalyzerSettings daemonSettings = DaemonCodeAnalyzerSettings.getInstance();
        boolean isModified = JavaAutoImportOptions.isModified(this.myCbShowImportPopup, daemonSettings.isImportHintEnabled());
        isModified |= JavaAutoImportOptions.isModified(this.myCbOptimizeImports, codeInsightSettings.OPTIMIZE_IMPORTS_ON_THE_FLY);
        isModified |= JavaAutoImportOptions.isModified(this.myCbAddUnambiguousImports, codeInsightSettings.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY);
        isModified |= this.getSmartPasteValue() != codeInsightSettings.ADD_IMPORTS_ON_PASTE;
        return isModified |= this.myExcludePackagesTable.isModified();
    }

    private int getSmartPasteValue() {
        Object selectedItem = this.mySmartPasteCombo.getSelectedItem();
        if (INSERT_IMPORTS_ALWAYS.equals(selectedItem)) {
            return 1;
        }
        if (INSERT_IMPORTS_NONE.equals(selectedItem)) {
            return 2;
        }
        return 3;
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JComboBox jComboBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Java", (int)0, (int)0, null, null));
        this.myCbShowImportPopup = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.import.popup"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbAddUnambiguousImports = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.add.unambiguous.imports.on.the.fly"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.paste.insert.imports"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySmartPasteCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myExcludeFromImportAndCompletionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(400, 150), null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messages/ApplicationBundle").getString("exclude.from.completion.group"));
        jPanel2.add((Component)titledSeparator, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCbOptimizeImports = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.optimize.imports.on.the.fly"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

