/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoPopupController
implements Disposable {
    private final Project myProject;
    private final Alarm myAlarm = new Alarm();

    public static AutoPopupController getInstance(Project project2) {
        return (AutoPopupController)ServiceManager.getService((Project)project2, AutoPopupController.class);
    }

    public AutoPopupController(Project project2) {
        this.myProject = project2;
        this.setupListeners();
    }

    private void setupListeners() {
        ActionManagerEx.getInstanceEx().addAnActionListener(new AnActionListener(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                AutoPopupController.this.cancelAllRequest();
            }

            public void beforeEditorTyping(char c, DataContext dataContext) {
                AutoPopupController.this.cancelAllRequest();
            }

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            }
        }, (Disposable)this);
        IdeEventQueue.getInstance().addActivityListener(new Runnable(){

            @Override
            public void run() {
                AutoPopupController.this.cancelAllRequest();
            }
        }, this);
    }

    public void autoPopupMemberLookup(Editor editor, @Nullable Condition<PsiFile> condition) {
        this.scheduleAutoPopup(editor, condition);
    }

    public void scheduleAutoPopup(final Editor editor, final @Nullable Condition<PsiFile> condition) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !CompletionAutoPopupHandler.ourTestingAutopopup) {
            return;
        }
        if (!CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        if (!CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class, CompletionPhase.NoCompletion.getClass())) {
            return;
        }
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (currentCompletion != null) {
            currentCompletion.closeAndFinish(true);
        }
        final CompletionPhase.CommittingDocuments phase = new CompletionPhase.CommittingDocuments(null, editor);
        CompletionServiceImpl.setCompletionPhase(phase);
        phase.ignoreCurrentDocumentChange();
        CompletionAutoPopupHandler.runLaterWithCommitted(this.myProject, editor.getDocument(), new Runnable(){

            @Override
            public void run() {
                if (phase.checkExpired()) {
                    return;
                }
                PsiFile file2 = PsiDocumentManager.getInstance((Project)AutoPopupController.this.myProject).getPsiFile(editor.getDocument());
                if (file2 != null && condition != null && !condition.value((Object)file2)) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                    return;
                }
                CompletionAutoPopupHandler.invokeCompletion(CompletionType.BASIC, true, AutoPopupController.this.myProject, editor, 0, false);
            }
        });
    }

    public void scheduleAutoPopup(Editor editor) {
        this.scheduleAutoPopup(editor, null);
    }

    private void addRequest(final Runnable request, final int delay) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                AutoPopupController.this.myAlarm.addRequest(request, delay);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    private void cancelAllRequest() {
        this.myAlarm.cancelAllRequests();
    }

    public void autoPopupParameterInfo(final @NotNull Editor editor, final @Nullable PsiElement highlightedMethod) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/AutoPopupController", "autoPopupParameterInfo"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_PARAMETER_INFO) {
            final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            if (!documentManager.isUncommited(editor.getDocument()) && (file2 = documentManager.getPsiFile(InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2).getDocument())) == null) {
                return;
            }
            final PsiFile file1 = file2;
            Runnable request = new Runnable(){

                @Override
                public void run() {
                    if (AutoPopupController.this.myProject.isDisposed() || DumbService.isDumb((Project)AutoPopupController.this.myProject)) {
                        return;
                    }
                    documentManager.commitAllDocuments();
                    if (editor.isDisposed() || !editor.getComponent().isShowing()) {
                        return;
                    }
                    int lbraceOffset = editor.getCaretModel().getOffset() - 1;
                    try {
                        ShowParameterInfoHandler.invoke(AutoPopupController.this.myProject, editor, file1, lbraceOffset, highlightedMethod);
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                }
            };
            this.addRequest(request, settings.PARAMETER_INFO_DELAY);
        }
    }

    public void dispose() {
    }
}

