/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsAwareFormatChangedTextUtil
extends FormatChangedTextUtil {
    VcsAwareFormatChangedTextUtil() {
    }

    @Override
    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project2, @NotNull PsiFile file2) throws FilesTooBigForDiffException {
        CharSequence testContent;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
            }
            return list;
        }
        List<TextRange> cachedChangedLines = VcsAwareFormatChangedTextUtil.getCachedChangedLines(project2, document);
        if (cachedChangedLines != null) {
            List<TextRange> list = cachedChangedLines;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
            }
            return list;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file2.getUserData(TEST_REVISION_CONTENT)) != null) {
            List<TextRange> list = VcsAwareFormatChangedTextUtil.calculateChangedTextRanges(document, testContent);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
            }
            return list;
        }
        Change change = ChangeListManager.getInstance((Project)project2).getChange(file2.getVirtualFile());
        if (change == null) {
            List list = ContainerUtilRt.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
            }
            return list;
        }
        if (change.getType() == Change.Type.NEW) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
            }
            return arrayList;
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        List<TextRange> list = contentFromVcs != null ? VcsAwareFormatChangedTextUtil.calculateChangedTextRanges(document, contentFromVcs) : ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        return list;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRevisionedContentFrom"));
        }
        ContentRevision revision = change.getBeforeRevision();
        if (revision == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static List<TextRange> getCachedChangedLines(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getCachedChangedLines"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getCachedChangedLines"));
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(document);
        if (tracker != null && tracker.isValid()) {
            List<Range> ranges = tracker.getRanges();
            return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    protected static List<TextRange> calculateChangedTextRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) throws FilesTooBigForDiffException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateChangedTextRanges"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateChangedTextRanges"));
        }
        List<TextRange> list = VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateChangedTextRanges"));
        }
        return list;
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) throws FilesTooBigForDiffException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRanges"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRanges"));
        }
        Document documentFromVcs = ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(contentFromVcs, true, false);
        List<Range> list = new RangesBuilder(document, documentFromVcs).getRanges();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRanges"));
        }
        return list;
    }

    @Override
    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateChangedLinesNumber"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateChangedLinesNumber"));
        }
        try {
            List<Range> changedRanges = VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
            int linesChanges = 0;
            for (Range range : changedRanges) {
                linesChanges += VcsAwareFormatChangedTextUtil.countLines(range);
            }
            return linesChanges;
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info("File too big, can not calculate changed lines number");
            return -1;
        }
    }

    private static int countLines(Range range) {
        byte rangeType = range.getType();
        if (rangeType == 1) {
            int currentChangedLines = range.getLine2() - range.getLine1();
            int revisionLinesChanged = range.getVcsLine2() - range.getVcsLine1();
            return Math.max(currentChangedLines, revisionLinesChanged);
        }
        if (rangeType == 3) {
            return range.getVcsLine2() - range.getVcsLine1();
        }
        if (rangeType == 2) {
            return range.getLine2() - range.getLine1();
        }
        return 0;
    }

    @NotNull
    private static List<TextRange> getChangedTextRanges(@NotNull Document document, @NotNull List<Range> changedRanges) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        if (changedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRanges", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        ArrayList ranges = ContainerUtil.newArrayList();
        for (Range range : changedRanges) {
            if (range.getType() == 3) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            ranges.add(new TextRange(lineStartOffset, lineEndOffset));
        }
        ArrayList arrayList = ranges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        return arrayList;
    }

    @Override
    public boolean isChangeNotTrackedForFile(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "isChangeNotTrackedForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "isChangeNotTrackedForFile"));
        }
        boolean isUnderVcs = VcsUtil.isFileUnderVcs((Project)project2, (FilePath)VcsUtil.getFilePath((VirtualFile)file2.getVirtualFile()));
        if (!isUnderVcs) {
            return true;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project2);
        List<VirtualFile> unversionedFiles = changeListManager.getUnversionedFiles();
        return unversionedFiles.contains(file2.getVirtualFile());
    }
}

