/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

class ArrayMemberAccess {
    ArrayMemberAccess() {
    }

    static void addMemberAccessors(final PsiElement element, String prefix, PsiType itemType, PsiElement qualifier, Consumer<LookupElement> result2, PsiModifierListOwner object, PsiType expectedType) throws IncorrectOperationException {
        if (itemType instanceof PsiArrayType && expectedType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression(ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + prefix + "[0]", element);
            result2.consume((Object)new ExpressionLookupItem(conversion, object.getIcon(1), prefix + "[...]", new String[]{prefix}){

                public void handleInsert(InsertionContext context) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.array.member");
                    int tailOffset = context.getTailOffset();
                    String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_BRACKETS);
                    context.getDocument().insertString(tailOffset, (CharSequence)("[" + callSpace + callSpace + "]"));
                    context.getEditor().getCaretModel().moveToOffset(tailOffset + 1 + callSpace.length());
                }
            });
        }
    }

    @Nullable
    static ExpressionLookupItem accessFirstElement(PsiElement element, LookupElement item) {
        if (item.getObject() instanceof PsiLocalVariable) {
            PsiNewExpression newExpression;
            PsiExpression[] dimensions;
            PsiLocalVariable variable = (PsiLocalVariable)item.getObject();
            PsiType type = variable.getType();
            PsiExpression expression = variable.getInitializer();
            if (type instanceof PsiArrayType && expression instanceof PsiNewExpression && (dimensions = (newExpression = (PsiNewExpression)expression).getArrayDimensions()).length == 1 && "1".equals(dimensions[0].getText()) && newExpression.getArrayInitializer() == null) {
                String text = variable.getName() + "[0]";
                return new ExpressionLookupItem(ReferenceExpressionCompletionContributor.createExpression(text, element), variable.getIcon(1), text, text);
            }
        }
        return null;
    }
}

