/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FunctionalExpressionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> LAMBDA = PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("LAMBDA_CONTEXT"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider$1", "accepts"));
            }
            return FunctionalExpressionCompletionProvider.isLambdaContext(element);
        }
    });

    private static boolean isLambdaContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "isLambdaContext"));
        }
        PsiElement rulezzRef = element.getParent();
        return rulezzRef != null && rulezzRef instanceof PsiReferenceExpression && ((PsiReferenceExpression)rulezzRef).getQualifier() == null && LambdaUtil.isValidLambdaContext((PsiElement)rulezzRef.getParent());
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "addCompletions"));
        }
        result2.addAllElements(FunctionalExpressionCompletionProvider.getLambdaVariants(parameters, false));
    }

    static List<LookupElement> getLambdaVariants(@NotNull CompletionParameters parameters, boolean prioritize) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "getLambdaVariants"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters.getOriginalFile()) || !FunctionalExpressionCompletionProvider.isLambdaContext(parameters.getPosition())) {
            return Collections.emptyList();
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (ExpectedTypeInfo expectedType : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            PsiType expectedReturnType;
            PsiType functionalInterfaceType;
            PsiMethod functionalInterfaceMethod;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null) continue;
            assert (functionalInterfaceType != null);
            Object[] params = new PsiParameter[]{};
            final PsiElement originalPosition = parameters.getPosition();
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)functionalInterfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
            if (!functionalInterfaceMethod.hasTypeParameters()) {
                params = functionalInterfaceMethod.getParameterList().getParameters();
                Project project2 = functionalInterfaceMethod.getProject();
                JVMElementFactory jvmElementFactory = JVMElementFactories.getFactory((Language)originalPosition.getLanguage(), (Project)project2);
                final JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
                if (jvmElementFactory != null) {
                    params = GenerateMembersUtil.overriddenParameters((PsiParameter[])params, jvmElementFactory, javaCodeStyleManager, substitutor, originalPosition);
                }
                String paramsString = params.length == 1 ? FunctionalExpressionCompletionProvider.getParamName(params[0], javaCodeStyleManager, originalPosition) : "(" + StringUtil.join((Object[])params, (Function)new Function<PsiParameter, String>(){

                    public String fun(PsiParameter parameter) {
                        return FunctionalExpressionCompletionProvider.getParamName(parameter, javaCodeStyleManager, originalPosition);
                    }
                }, (String)",") + ")";
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(paramsString + " -> {}", null);
                lambdaExpression = (PsiLambdaExpression)codeStyleManager.reformat((PsiElement)lambdaExpression);
                paramsString = lambdaExpression.getParameterList().getText();
                LookupElementBuilder builder = LookupElementBuilder.create((Object)functionalInterfaceMethod, (String)paramsString).withPresentableText(paramsString + " -> {}").withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Editor editor = context.getEditor();
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" -> ");
                    }
                }).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.Function);
                LookupElement lambdaElement = builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                if (prioritize) {
                    lambdaElement = PrioritizedLookupElement.withPriority((LookupElement)lambdaElement, (double)1.0);
                }
                result2.add(lambdaElement);
            }
            if ((expectedReturnType = substitutor.substitute(functionalInterfaceMethod.getReturnType())) == null) continue;
            if (params.length > 0) {
                FunctionalExpressionCompletionProvider.collectVariantsByReceiver(prioritize, functionalInterfaceType, (PsiParameter[])params, originalPosition, substitutor, expectedReturnType, result2);
            }
            FunctionalExpressionCompletionProvider.collectThisVariants(functionalInterfaceType, (PsiParameter[])params, originalPosition, substitutor, expectedReturnType, result2);
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)expectedReturnType);
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            if (expectedReturnType.getArrayDimensions() == 0) {
                PsiMethod[] constructors;
                for (PsiMethod psiMethod : constructors = psiClass.getConstructors()) {
                    if (!FunctionalExpressionCompletionProvider.areParameterTypesAppropriate(psiMethod, (PsiParameter[])params, substitutor, 0)) continue;
                    result2.add(FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, expectedReturnType));
                }
                if (constructors.length != 0 || params.length != 0) continue;
                result2.add(FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, expectedReturnType));
                continue;
            }
            if (params.length != 1 || !PsiType.INT.equals((Object)params[0].getType())) continue;
            result2.add(FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, expectedReturnType));
        }
        return result2;
    }

    private static LookupElement createConstructorReferenceLookup(PsiType functionalInterfaceType, PsiType expectedReturnType) {
        return LookupElementBuilder.create((String)(expectedReturnType.getPresentableText() + "::new")).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
    }

    private static void collectThisVariants(PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType, List<LookupElement> result2) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, PsiClass.class);
        if (psiClass != null) {
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                PsiType returnType = psiMethod.getReturnType();
                if (!FunctionalExpressionCompletionProvider.isInstanceMethodWithAppropriateReturnType(expectedReturnType, psiMethod, returnType) || !FunctionalExpressionCompletionProvider.areParameterTypesAppropriate(psiMethod, params, substitutor, 0)) continue;
                LookupElement methodRefLookupElement = LookupElementBuilder.create((PsiNamedElement)psiMethod).withPresentableText("this::" + psiMethod.getName()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        int startOffset = context.getStartOffset();
                        Document document = context.getDocument();
                        document.insertString(startOffset, (CharSequence)"this::");
                    }
                }).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                result2.add(methodRefLookupElement);
            }
        }
    }

    private static void collectVariantsByReceiver(boolean prioritize, PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType, List<LookupElement> result2) {
        PsiType functionalInterfaceParamType = substitutor.substitute(params[0].getType());
        final PsiClass paramClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)functionalInterfaceParamType);
        if (paramClass != null && !paramClass.hasTypeParameters()) {
            HashSet<String> visited = new HashSet<String>();
            for (PsiMethod psiMethod : paramClass.getAllMethods()) {
                PsiType returnType = psiMethod.getReturnType();
                if (!visited.add(psiMethod.getName()) || !FunctionalExpressionCompletionProvider.isInstanceMethodWithAppropriateReturnType(expectedReturnType, psiMethod, returnType) || !FunctionalExpressionCompletionProvider.areParameterTypesAppropriate(psiMethod, params, substitutor, 1) || !JavaResolveUtil.isAccessible((PsiMember)psiMethod, null, psiMethod.getModifierList(), originalPosition, null, null)) continue;
                LookupElement methodRefLookupElement = LookupElementBuilder.create((PsiNamedElement)psiMethod).withPresentableText(paramClass.getName() + "::" + psiMethod.getName()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        int startOffset = context.getStartOffset();
                        Document document = context.getDocument();
                        PsiFile file2 = context.getFile();
                        document.insertString(startOffset, (CharSequence)"::");
                        JavaCompletionUtil.insertClassReference(paramClass, file2, startOffset);
                    }
                }).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                if (prioritize && psiMethod.getContainingClass() == paramClass) {
                    methodRefLookupElement = PrioritizedLookupElement.withPriority((LookupElement)methodRefLookupElement, (double)1.0);
                }
                result2.add(methodRefLookupElement);
            }
        }
    }

    private static boolean isInstanceMethodWithAppropriateReturnType(PsiType expectedReturnType, PsiMethod psiMethod, PsiType returnType) {
        return returnType != null && !psiMethod.hasModifierProperty("static") && TypeConversionUtil.isAssignable((PsiType)expectedReturnType, (PsiType)returnType);
    }

    private static boolean areParameterTypesAppropriate(PsiMethod psiMethod, PsiParameter[] params, PsiSubstitutor substitutor, int offset) {
        PsiParameterList parameterList = psiMethod.getParameterList();
        if (parameterList.getParametersCount() == params.length - offset) {
            PsiParameter[] referenceMethodParams = parameterList.getParameters();
            for (int i = 0; i < params.length - offset; ++i) {
                if (Comparing.equal((Object)referenceMethodParams[i].getType(), (Object)substitutor.substitute(params[i + offset].getType()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getParamName(PsiParameter param, JavaCodeStyleManager javaCodeStyleManager, PsiElement originalPosition) {
        return javaCodeStyleManager.suggestUniqueVariableName(param.getName(), originalPosition, false);
    }
}

