/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaInheritorsGetter
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaInheritorsGetter");
    private final ConstructorInsertHandler myConstructorInsertHandler;

    public JavaInheritorsGetter(ConstructorInsertHandler constructorInsertHandler) {
        this.myConstructorInsertHandler = constructorInsertHandler;
    }

    private static boolean shouldAddArrayInitializer(PsiElement position) {
        if (!JavaCompletionContributor.isInJavaContext(position) || !JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiNewExpression.class);
        return newExpression != null && newExpression.getParent() instanceof PsiExpressionList;
    }

    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext matchingContext, final @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaInheritorsGetter", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaInheritorsGetter", "addCompletions"));
        }
        ExpectedTypeInfo[] infos = JavaSmartCompletionContributor.getExpectedTypes(parameters);
        final List<ExpectedTypeInfo> infoCollection = Arrays.asList(infos);
        this.generateVariants(parameters, result2.getPrefixMatcher(), infos, new Consumer<LookupElement>(){

            public void consume(LookupElement lookupElement) {
                result2.addElement((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, infoCollection));
            }
        });
    }

    public void generateVariants(CompletionParameters parameters, PrefixMatcher prefixMatcher, Consumer<LookupElement> consumer) {
        this.generateVariants(parameters, prefixMatcher, JavaSmartCompletionContributor.getExpectedTypes(parameters), consumer);
    }

    private void generateVariants(final CompletionParameters parameters, PrefixMatcher prefixMatcher, ExpectedTypeInfo[] infos, final Consumer<LookupElement> consumer) {
        JavaInheritorsGetter.addArrayTypes(parameters.getPosition(), infos, consumer);
        JavaInheritorsGetter.processInheritors(parameters, JavaInheritorsGetter.extractClassTypes(infos), prefixMatcher, new Consumer<PsiType>(){

            public void consume(PsiType type) {
                LookupElement element = JavaInheritorsGetter.this.addExpectedType(type, parameters);
                if (element != null) {
                    consumer.consume((Object)element);
                }
            }
        });
    }

    private static void addArrayTypes(PsiElement identifierCopy, ExpectedTypeInfo[] infos, Consumer<LookupElement> consumer) {
        for (PsiType type : ExpectedTypesGetter.extractTypes(infos, true)) {
            if (!(type instanceof PsiArrayType)) continue;
            consumer.consume((Object)JavaInheritorsGetter.createNewArrayItem(identifierCopy, type));
            if (!JavaInheritorsGetter.shouldAddArrayInitializer(identifierCopy)) continue;
            PsiTypeLookupItem item = JavaInheritorsGetter.createNewArrayItem(identifierCopy, type);
            item.setAddArrayInitializer();
            consumer.consume((Object)item);
        }
    }

    private static PsiTypeLookupItem createNewArrayItem(PsiElement context, PsiType type) {
        return PsiTypeLookupItem.createLookupItem(TypeConversionUtil.erasure((PsiType)type), context).setShowPackage();
    }

    private static List<PsiClassType> extractClassTypes(ExpectedTypeInfo[] infos) {
        SmartList expectedClassTypes = new SmartList();
        for (PsiType type : ExpectedTypesGetter.extractTypes(infos, true)) {
            PsiClassType classType;
            if (!(type instanceof PsiClassType) || (classType = (PsiClassType)type).resolve() == null) continue;
            expectedClassTypes.add(classType);
        }
        return expectedClassTypes;
    }

    @Nullable
    private LookupElement addExpectedType(PsiType type, CompletionParameters parameters) {
        if (!JavaCompletionUtil.hasAccessibleConstructor(type)) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        if (psiClass == null || psiClass.getName() == null) {
            return null;
        }
        PsiElement position = parameters.getPosition();
        if ((parameters.getInvocationCount() < 2 || psiClass instanceof PsiCompiledElement) && HighlightClassUtil.checkCreateInnerClassFromStaticContext(position, null, psiClass) != null && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("new")).afterLeaf(new String[]{"."}))).accepts((Object)position)) {
            return null;
        }
        PsiType psiType = GenericsUtil.eliminateWildcards((PsiType)type);
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)parameters.getOriginalPosition()) && PsiUtil.getLanguageLevel((PsiElement)parameters.getOriginalFile()).isAtLeast(LanguageLevel.JDK_1_7)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            if (psiClass.hasTypeParameters() && !((PsiClassType)type).isRaw()) {
                String erasedText = TypeConversionUtil.erasure((PsiType)psiType).getCanonicalText();
                String canonicalText = psiType.getCanonicalText();
                if (canonicalText.contains("?extends") || canonicalText.contains("?super")) {
                    LOG.error("Malformed canonical text: " + canonicalText + "; presentable text: " + psiType + " of " + psiType.getClass() + "; " + (psiType instanceof PsiClassReferenceType ? ((PsiClassReferenceType)psiType).getReference().getClass() : ""));
                    return null;
                }
                try {
                    PsiDiamondType.DiamondInferenceResult inferenceResult;
                    boolean hasDefaultConstructorOrNoGenericsOne;
                    PsiStatement statement2 = elementFactory.createStatementFromText(canonicalText + " v = new " + erasedText + "<>()", (PsiElement)parameters.getOriginalFile());
                    PsiVariable declaredVar = (PsiVariable)((PsiDeclarationStatement)statement2).getDeclaredElements()[0];
                    PsiNewExpression initializer = (PsiNewExpression)declaredVar.getInitializer();
                    boolean bl = hasDefaultConstructorOrNoGenericsOne = PsiDiamondTypeImpl.hasDefaultConstructor(psiClass) || !PsiDiamondTypeImpl.haveConstructorsGenericsParameters(psiClass);
                    if (hasDefaultConstructorOrNoGenericsOne && (inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(initializer)).getErrorMessage() == null && !psiClass.hasModifierProperty("abstract") && JavaInheritorsGetter.areInferredTypesApplicable(inferenceResult.getTypes(), parameters.getPosition())) {
                        psiType = initializer.getType();
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
        }
        PsiTypeLookupItem item = PsiTypeLookupItem.createLookupItem(psiType, position).setShowPackage();
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract")) {
            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            item.setIndicateAnonymous(true);
        }
        return LookupElementDecorator.withInsertHandler((LookupElement)item, (InsertHandler)this.myConstructorInsertHandler);
    }

    private static boolean areInferredTypesApplicable(@NotNull PsiType[] types, PsiElement position) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/codeInsight/completion/JavaInheritorsGetter", "areInferredTypesApplicable"));
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class);
        if (methodCallExpression != null) {
            PsiNewExpression newExpression;
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)methodCallExpression) && (newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiNewExpression.class, (boolean)false)) != null) {
                PsiType expectedType;
                PsiClass aClass;
                PsiParameter[] parameters;
                JavaResolveResult resolveResult;
                PsiMethod method;
                PsiNewExpression parent = newExpression;
                while (parent.getParent() instanceof PsiParenthesizedExpression) {
                    parent = parent.getParent();
                }
                int idx = ArrayUtil.find((Object[])methodCallExpression.getArgumentList().getExpressions(), (Object)parent);
                if (idx > -1 && (method = (PsiMethod)(resolveResult = methodCallExpression.resolveMethodGenerics()).getElement()) != null && idx < (parameters = method.getParameterList().getParameters()).length && (aClass = PsiUtil.resolveClassInType((PsiType)(expectedType = resolveResult.getSubstitutor().substitute(parameters[idx].getType())))) != null) {
                    PsiClassType inferredArg = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(aClass, types);
                    LOG.assertTrue(expectedType != null);
                    return TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)inferredArg);
                }
            }
            return false;
        }
        return true;
    }

    public static void processInheritors(CompletionParameters parameters, Collection<PsiClassType> expectedClassTypes, PrefixMatcher matcher, Consumer<PsiType> consumer) {
        JavaInheritorsGetter.processInheritors(parameters.getOriginalFile(), parameters.getPosition(), expectedClassTypes, matcher, consumer);
    }

    public static void processInheritors(PsiFile file2, PsiElement context, Collection<PsiClassType> expectedClassTypes, PrefixMatcher matcher, Consumer<PsiType> consumer) {
        if (!JavaInheritorsGetter.processMostProbableInheritors(file2, context, expectedClassTypes, consumer)) {
            return;
        }
        for (PsiClassType type : expectedClassTypes) {
            CodeInsightUtil.processSubTypes((PsiType)type, context, false, matcher, consumer);
        }
    }

    private static boolean processMostProbableInheritors(PsiFile contextFile, PsiElement context, Collection<PsiClassType> expectedClassTypes, Consumer<PsiType> consumer) {
        block0: for (PsiClassType type : expectedClassTypes) {
            StatisticsInfo[] stats;
            consumer.consume((Object)type);
            PsiClassType.ClassResolveResult baseResult = JavaCompletionUtil.originalize(type).resolveGenerics();
            PsiClass baseClass = baseResult.getElement();
            if (baseClass == null) {
                return false;
            }
            PsiSubstitutor baseSubstitutor = baseResult.getSubstitutor();
            Processor<PsiClass> processor2 = CodeInsightUtil.createInheritorsProcessor(context, type, 0, false, consumer, baseClass, baseSubstitutor);
            for (StatisticsInfo statisticsInfo : stats = StatisticsManager.getInstance().getAllValues(JavaStatisticsManager.getAfterNewKey((PsiType)type))) {
                String value = statisticsInfo.getValue();
                if (!value.startsWith("class#")) continue;
                String qname = value.substring("class#".length());
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)contextFile.getProject()).findClass(qname, contextFile.getResolveScope());
                if (psiClass != null && !PsiTreeUtil.isAncestor((PsiElement)contextFile, (PsiElement)psiClass, (boolean)true) && !processor2.process((Object)psiClass)) continue block0;
            }
        }
        return true;
    }
}

