/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.ClassNameReferenceEditor;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class RefactoringCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, final @NotNull CompletionResultSet resultSet) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/RefactoringCompletionContributor", "fillCompletionVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/codeInsight/completion/RefactoringCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getOriginalFile().getUserData(ClassNameReferenceEditor.CLASS_NAME_REFERENCE_FRAGMENT) == null) {
            return;
        }
        resultSet.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

            public void consume(CompletionResult result2) {
                Module module2;
                LookupElement element = result2.getLookupElement();
                Object object = element.getObject();
                if (object instanceof PsiClass && (module2 = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiClass)object))) != null) {
                    resultSet.consume((LookupElement)LookupElementDecorator.withRenderer((LookupElement)element, (LookupElementRenderer)new AppendModuleName(module2)));
                    return;
                }
                resultSet.passResult(result2);
            }
        });
    }

    private static class AppendModuleName
    extends LookupElementRenderer<LookupElementDecorator<LookupElement>> {
        private final Module myModule;

        public AppendModuleName(Module module2) {
            this.myModule = module2;
        }

        public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
            element.getDelegate().renderElement(presentation);
            presentation.appendTailText(" [" + this.myModule.getName() + "]", true);
        }
    }
}

