/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class LineMarkersUtil {
    LineMarkersUtil() {
    }

    static void setLineMarkersToEditor(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, @NotNull Collection<LineMarkerInfo> markers, int group) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (markers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<LineMarkerInfo> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project2);
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>(Math.max(markers.size(), oldMarkers.size()));
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project2, true);
        HighlightersRecycler toReuse = new HighlightersRecycler();
        for (LineMarkerInfo lineMarkerInfo : oldMarkers) {
            boolean toRemove;
            RangeHighlighter highlighter = lineMarkerInfo.highlighter;
            boolean bl = toRemove = !highlighter.isValid() || lineMarkerInfo.updatePass == group && TextRange.containsRange((Segment)bounds, (Segment)highlighter);
            if (toRemove) {
                toReuse.recycleHighlighter(highlighter);
                continue;
            }
            result2.add(lineMarkerInfo);
        }
        for (final LineMarkerInfo lineMarkerInfo : markers) {
            boolean lineSeparatorPlacementChanged;
            TextRange elementRange;
            TextRange textRange;
            PsiElement element = lineMarkerInfo.getElement();
            if (element == null || (textRange = element.getTextRange()) == null || !TextRange.containsRange((Segment)bounds, (Segment)(elementRange = InjectedLanguageManager.getInstance((Project)project2).injectedToHost(element, textRange)))) continue;
            RangeHighlighter marker = toReuse.pickupHighlighterFromGarbageBin(lineMarkerInfo.startOffset, lineMarkerInfo.endOffset, 3000);
            if (marker == null) {
                marker = markupModel.addRangeHighlighter(lineMarkerInfo.startOffset, lineMarkerInfo.endOffset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
            }
            final LineMarkerInfo.LineMarkerGutterIconRenderer newRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)lineMarkerInfo.createGutterRenderer();
            LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer = marker.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)marker.getGutterIconRenderer() : null;
            final boolean rendererChanged = oldRenderer == null || newRenderer == null || !newRenderer.equals((Object)oldRenderer);
            final boolean lineSeparatorColorChanged = !Comparing.equal((Object)marker.getLineSeparatorColor(), (Object)lineMarkerInfo.separatorColor);
            boolean bl = lineSeparatorPlacementChanged = !Comparing.equal((Object)marker.getLineSeparatorPlacement(), (Object)lineMarkerInfo.separatorPlacement);
            if (rendererChanged || lineSeparatorColorChanged || lineSeparatorPlacementChanged) {
                ((MarkupModelEx)markupModel).changeAttributesInBatch((RangeHighlighterEx)marker, new Consumer<RangeHighlighterEx>(){

                    public void consume(RangeHighlighterEx markerEx) {
                        if (rendererChanged) {
                            markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                        }
                        if (lineSeparatorColorChanged) {
                            markerEx.setLineSeparatorColor(lineMarkerInfo.separatorColor);
                        }
                        if (lineSeparatorPlacementChanged) {
                            markerEx.setLineSeparatorPlacement(lineMarkerInfo.separatorPlacement);
                        }
                    }
                });
            }
            lineMarkerInfo.highlighter = marker;
            result2.add(lineMarkerInfo);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
        }
        DaemonCodeAnalyzerImpl.setLineMarkers(document, result2, project2);
    }
}

