/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocateLibraryDialog
extends DialogWrapper {
    private final List<String> myDefaultLibraryPaths;
    private JPanel myContentPane;
    private TextFieldWithBrowseButton myCopyToDir;
    private JBRadioButton myUseBundledRadioButton;
    private JBRadioButton myCopyLibraryFilesRadioButton;
    private final Project myProject;
    private List<String> myResultingLibraryPaths;

    public LocateLibraryDialog(@NotNull Module module2, @NotNull List<String> defaultLibraryPaths, @NotNull @NonNls String presentableName) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/LocateLibraryDialog", "<init>"));
        }
        if (defaultLibraryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultLibraryPaths", "com/intellij/codeInsight/daemon/impl/quickfix/LocateLibraryDialog", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/codeInsight/daemon/impl/quickfix/LocateLibraryDialog", "<init>"));
        }
        super(module2.getProject(), true);
        this.myDefaultLibraryPaths = defaultLibraryPaths;
        Object[] objectArray = new Object[]{presentableName};
        this.$$$setupUI$$$();
        this.setTitle(QuickFixBundle.message("add.library.title.dialog", objectArray));
        this.myProject = module2.getProject();
        this.myUseBundledRadioButton.setText(QuickFixBundle.message("add.library.use.bundled.library.radio.button", presentableName, ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myCopyLibraryFilesRadioButton.setText(QuickFixBundle.message("add.library.copy.files.to.radio.button", presentableName));
        this.myCopyToDir.setText(new File(new File(module2.getModuleFilePath()).getParent(), "lib").getAbsolutePath());
        this.myCopyToDir.addBrowseFolderListener(QuickFixBundle.message("add.library.title.choose.folder", new Object[0]), QuickFixBundle.message("add.library.description.choose.folder", new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocateLibraryDialog.this.updateButtons();
            }
        };
        this.myUseBundledRadioButton.addItemListener(listener);
        this.myCopyLibraryFilesRadioButton.addItemListener(listener);
        this.myCopyToDir.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LocateLibraryDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        this.init();
    }

    @NotNull
    public List<String> showAndGetResult() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            Disposer.dispose((Disposable)this.myDisposable);
            List<String> list = this.myDefaultLibraryPaths;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/LocateLibraryDialog", "showAndGetResult"));
            }
            return list;
        }
        List<String> list = this.showAndGet() ? this.getResultingLibraryPaths() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/LocateLibraryDialog", "showAndGetResult"));
        }
        return list;
    }

    public List<String> getResultingLibraryPaths() {
        return this.myResultingLibraryPaths;
    }

    private void updateButtons() {
        boolean copyFiles = this.myCopyLibraryFilesRadioButton.isSelected();
        this.myCopyToDir.setEnabled(copyFiles);
        this.setOKActionEnabled(!copyFiles || !this.myCopyToDir.getText().isEmpty());
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUseBundledRadioButton;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.myResultingLibraryPaths = this.computeResultingPaths();
            if (!this.myResultingLibraryPaths.isEmpty()) {
                this.close(0);
            }
        }
    }

    private List<String> computeResultingPaths() {
        if (this.myUseBundledRadioButton.isSelected()) {
            return this.myDefaultLibraryPaths;
        }
        String dstDir = this.myCopyToDir.getText();
        if (dstDir.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String path : this.myDefaultLibraryPaths) {
            File srcFile = new File(path);
            if (!srcFile.exists()) {
                Messages.showErrorDialog((Project)this.myProject, (String)QuickFixBundle.message("add.library.error.not.found", srcFile.getPath()), (String)CommonBundle.getErrorTitle());
                return Collections.emptyList();
            }
            File dstFile = new File(dstDir, srcFile.getName());
            try {
                FileUtil.copy((File)srcFile, (File)dstFile);
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)QuickFixBundle.message("add.library.error.cannot.copy", srcFile.getPath(), dstFile.getPath(), e.getMessage()), (String)CommonBundle.getErrorTitle());
                return Collections.emptyList();
            }
            result2.add(FileUtil.toSystemIndependentName((String)dstFile.getAbsolutePath()));
        }
        return result2;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCopyToDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 0, null, null, null, 2));
        this.myUseBundledRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, ResourceBundle.getBundle("messages/QuickFixBundle").getString("add.library.use.bundled.library.radio.button"));
        jBRadioButton2.setSelected(true);
        jPanel.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCopyLibraryFilesRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, ResourceBundle.getBundle("messages/QuickFixBundle").getString("add.library.copy.files.to.radio.button"));
        jPanel.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

