/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StaticImportMethodFix
implements IntentionAction,
HintAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix");
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;
    private List<PsiMethod> candidates;

    public StaticImportMethodFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "<init>"));
        }
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @NotNull
    public String getText() {
        String text = QuickFixBundle.message("static.import.method.text", new Object[0]);
        text = this.candidates != null && this.candidates.size() == 1 ? text + " '" + this.getMethodPresentableText() + "'" : text + "...";
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getText"));
        }
        return string;
    }

    @NotNull
    private String getMethodPresentableText() {
        String string = PsiFormatUtil.formatMethod((PsiMethod)this.candidates.get(0), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMethodPresentableText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "isAvailable"));
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2) && file2 instanceof PsiJavaFile && this.myMethodCall.getElement() != null && ((PsiMethodCallExpression)this.myMethodCall.getElement()).isValid() && ((PsiMethodCallExpression)this.myMethodCall.getElement()).getMethodExpression().getQualifierExpression() == null && ((PsiMethodCallExpression)this.myMethodCall.getElement()).resolveMethod() == null && file2.getManager().isInProject((PsiElement)file2) && !(this.candidates == null ? (this.candidates = this.getMethodsToImport()) : this.candidates).isEmpty();
    }

    private PsiType getExpectedType() {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.myMethodCall.getElement();
        if (methodCall == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        if (parent instanceof PsiVariable) {
            if (methodCall.equals(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)parent).getInitializer()))) {
                return ((PsiVariable)parent).getType();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            if (methodCall.equals(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getRExpression()))) {
                return ((PsiAssignmentExpression)parent).getLExpression().getType();
            }
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)((PsiLambdaExpression)psiElement).getFunctionalInterfaceType());
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else if (parent instanceof PsiExpressionList) {
            JavaResolveResult resolveResult;
            PsiElement psiElement;
            PsiElement pParent = parent.getParent();
            if (pParent instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList()) && (psiElement = (resolveResult = ((PsiCallExpression)pParent).resolveMethodGenerics()).getElement()) instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)psiElement;
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                int idx = ArrayUtilRt.find((Object[])((PsiExpressionList)parent).getExpressions(), (Object)PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall));
                if (idx > -1 && parameters.length > 0) {
                    PsiParameter lastParameter;
                    PsiType parameterType = parameters[Math.min(idx, parameters.length - 1)].getType();
                    if (idx >= parameters.length - 1 && (lastParameter = parameters[parameters.length - 1]).isVarArgs()) {
                        parameterType = ((PsiEllipsisType)lastParameter.getType()).getComponentType();
                    }
                    return resolveResult.getSubstitutor().substitute(parameterType);
                }
                return null;
            }
        } else if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    @NotNull
    private List<PsiMethod> getMethodsToImport() {
        final Project project2 = this.myMethodCall.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project2);
        final PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        PsiReferenceExpression reference = element.getMethodExpression();
        final PsiExpressionList argumentList = element.getArgumentList();
        String name = reference.getReferenceName();
        final ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        if (name == null) {
            ArrayList<PsiMethod> arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMethodsToImport"));
            }
            return arrayList;
        }
        GlobalSearchScope scope = element.getResolveScope();
        final HashMap possibleClasses = new HashMap();
        final PsiType expectedType = this.getExpectedType();
        final ArrayList applicableList = new ArrayList();
        final PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project2).getResolveHelper();
        LinkedMultiMap deprecated = new LinkedMultiMap();
        LinkedMultiMap suggestions = new LinkedMultiMap();
        class RegisterMethodsProcessor {
            RegisterMethodsProcessor() {
            }

            private void registerMethod(PsiClass containingClass, Collection<PsiMethod> methods) {
                Boolean alreadyMentioned = (Boolean)possibleClasses.get(containingClass);
                if (alreadyMentioned == Boolean.TRUE) {
                    return;
                }
                if (alreadyMentioned == null) {
                    list.addAll(methods);
                    possibleClasses.put(containingClass, false);
                }
                for (PsiMethod method : methods) {
                    PsiSubstitutor substitutorForMethod;
                    if (!PsiUtil.isAccessible((Project)project2, (PsiMember)method, (PsiElement)element, (PsiClass)containingClass) || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)(substitutorForMethod = resolveHelper.inferTypeArguments(method.getTypeParameters(), method.getParameterList().getParameters(), argumentList.getExpressions(), PsiSubstitutor.EMPTY, element.getParent(), (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE)), (PsiExpressionList)argumentList)) continue;
                    PsiType returnType = substitutorForMethod.substitute(method.getReturnType());
                    if (expectedType != null && returnType != null && !TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)returnType)) continue;
                    applicableList.add(method);
                    possibleClasses.put(containingClass, true);
                    break;
                }
            }
        }
        RegisterMethodsProcessor registrar = new RegisterMethodsProcessor();
        cache.processMethodsWithName(name, scope, (Processor)new Processor<PsiMethod>((MultiMap)deprecated, (MultiMap)suggestions){
            final /* synthetic */ MultiMap val$deprecated;
            final /* synthetic */ MultiMap val$suggestions;
            {
                this.val$deprecated = multiMap;
                this.val$suggestions = multiMap2;
            }

            public boolean process(PsiMethod method) {
                ProgressManager.checkCanceled();
                if (JavaCompletionUtil.isInExcludedPackage((PsiMember)method, false) || !method.hasModifierProperty("static")) {
                    return true;
                }
                PsiFile file2 = method.getContainingFile();
                PsiClass containingClass = method.getContainingClass();
                if (file2 instanceof PsiJavaFile && !((PsiJavaFile)file2).getPackageName().isEmpty()) {
                    if (this.isEffectivelyDeprecated(method)) {
                        this.val$deprecated.putValue((Object)containingClass, (Object)method);
                        return this.processCondition();
                    }
                    this.val$suggestions.putValue((Object)containingClass, (Object)method);
                }
                return this.processCondition();
            }

            private boolean isEffectivelyDeprecated(PsiMethod method) {
                if (method.isDeprecated()) {
                    return true;
                }
                for (PsiClass aClass = method.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
                    if (!aClass.isDeprecated()) continue;
                    return true;
                }
                return false;
            }

            private boolean processCondition() {
                return this.val$suggestions.size() + this.val$deprecated.size() < 50;
            }
        });
        for (Map.Entry methodEntry : suggestions.entrySet()) {
            registrar.registerMethod((PsiClass)methodEntry.getKey(), (Collection)methodEntry.getValue());
        }
        for (Map.Entry deprecatedMethod : deprecated.entrySet()) {
            registrar.registerMethod((PsiClass)deprecatedMethod.getKey(), (Collection)deprecatedMethod.getValue());
        }
        ArrayList<Object> result2 = applicableList.isEmpty() ? list : applicableList;
        for (int i = result2.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiMethod method = (PsiMethod)result2.get(i);
            if (!StaticImportMethodFix.isExcluded((PsiMember)method)) continue;
            result2.remove(i);
        }
        Collections.sort(result2, new PsiProximityComparator((PsiElement)argumentList));
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMethodsToImport"));
        }
        return arrayList;
    }

    public static boolean isExcluded(PsiMember method) {
        String name = PsiUtil.getMemberQualifiedName((PsiMember)method);
        return name != null && JavaProjectCodeInsightSettings.getSettings(method.getProject()).isExcluded(name);
    }

    public void invoke(final @NotNull Project project2, final Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                List methodsToImport = StaticImportMethodFix.this.getMethodsToImport();
                if (methodsToImport.isEmpty()) {
                    return;
                }
                StaticImportMethodFix.this.createQuestionAction(methodsToImport, project2, editor).execute();
            }
        });
    }

    @NotNull
    private StaticImportMethodQuestionAction createQuestionAction(List<PsiMethod> methodsToImport, @NotNull Project project2, Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "createQuestionAction"));
        }
        StaticImportMethodQuestionAction staticImportMethodQuestionAction = new StaticImportMethodQuestionAction(project2, editor, methodsToImport, this.myMethodCall);
        if (staticImportMethodQuestionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "createQuestionAction"));
        }
        return staticImportMethodQuestionAction;
    }

    private ImportClassFixBase.Result doFix(Editor editor) {
        if (this.candidates.isEmpty()) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        final StaticImportMethodQuestionAction action = this.createQuestionAction(this.candidates, this.myMethodCall.getProject(), editor);
        if (this.candidates.size() == 1) {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    action.execute();
                }
            });
            return ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
        }
        String hintText = ShowAutoImportPass.getMessage(this.candidates.size() > 1, this.getMethodPresentableText());
        if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
            TextRange textRange = element.getTextRange();
            HintManager.getInstance().showQuestionHint(editor, hintText, textRange.getStartOffset(), textRange.getEndOffset(), (QuestionAction)action);
        }
        return ImportClassFixBase.Result.POPUP_SHOWN;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "showHint"));
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)this.myMethodCall.getElement();
        if (callExpression == null || callExpression.getMethodExpression().getQualifierExpression() != null) {
            return false;
        }
        ImportClassFixBase.Result result2 = this.doFix(editor);
        return result2 == ImportClassFixBase.Result.POPUP_SHOWN || result2 == ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
    }
}

