/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportMethodQuestionAction
implements QuestionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + StaticImportMethodQuestionAction.class.getName()));
    private final Project myProject;
    private final Editor myEditor;
    private List<PsiMethod> myCandidates;
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;

    public StaticImportMethodQuestionAction(Project project2, Editor editor, List<PsiMethod> candidates, SmartPsiElementPointer<PsiMethodCallExpression> methodCall) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myCandidates = candidates;
        this.myMethodCall = methodCall;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        for (PsiMethod targetMethod : this.myCandidates) {
            if (targetMethod.isValid()) continue;
            return false;
        }
        if (this.myCandidates.size() == 1) {
            this.doImport(this.myCandidates.get(0));
        } else {
            this.chooseAndImport(this.myEditor, this.myProject);
        }
        return true;
    }

    private void doImport(final PsiMethod toImport) {
        Project project2 = toImport.getProject();
        CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiMethodCallExpression element = (PsiMethodCallExpression)StaticImportMethodQuestionAction.this.myMethodCall.getElement();
                            if (element != null) {
                                AddSingleMemberStaticImportAction.bindAllClassRefs(element.getContainingFile(), (PsiElement)toImport, toImport.getName(), toImport.getContainingClass());
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, QuickFixBundle.message("add.import", new Object[0]), (Object)this);
    }

    private void chooseAndImport(Editor editor, final Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doImport(this.myCandidates.get(0));
            return;
        }
        BaseListPopupStep<PsiMethod> step = new BaseListPopupStep<PsiMethod>(QuickFixBundle.message("method.to.import.chooser.title", new Object[0]), this.myCandidates){

            public PopupStep onChosen(PsiMethod selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                    LOG.assertTrue(selectedValue.isValid());
                    StaticImportMethodQuestionAction.this.doImport(selectedValue);
                    return FINAL_CHOICE;
                }
                String qname = PsiUtil.getMemberQualifiedName((PsiMember)selectedValue);
                if (qname == null) {
                    return FINAL_CHOICE;
                }
                List<String> excludableStrings = AddImportAction.getAllExcludableStrings(qname);
                return new BaseListPopupStep<String>(null, excludableStrings){

                    @NotNull
                    public String getTextFor(String value) {
                        String string = "Exclude '" + value + "' from auto-import";
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodQuestionAction$2$1", "getTextFor"));
                        }
                        return string;
                    }

                    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                        if (finalChoice) {
                            AddImportAction.excludeFromImport(project2, selectedValue);
                        }
                        return super.onChosen((Object)selectedValue, finalChoice);
                    }
                };
            }

            public boolean hasSubstep(PsiMethod selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(PsiMethod value) {
                String string = (String)ObjectUtils.assertNotNull((Object)value.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodQuestionAction$2", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(PsiMethod aValue) {
                return aValue.getIcon(0);
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step){
            final PopupListElementRenderer rightArrow;
            {
                this.rightArrow = new PopupListElementRenderer(this);
            }

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new MethodCellRenderer(true, 1){

                    @Override
                    @Nullable
                    protected TextAttributes getNavigationItemAttributes(Object value) {
                        PsiClass psiClass;
                        TextAttributes attrs = super.getNavigationItemAttributes(value);
                        if (value instanceof PsiMethod && !((PsiMethod)value).isDeprecated() && (psiClass = ((PsiMethod)value).getContainingClass()) != null && psiClass.isDeprecated()) {
                            return TextAttributes.merge((TextAttributes)attrs, (TextAttributes)super.getNavigationItemAttributes(psiClass));
                        }
                        return attrs;
                    }

                    @Override
                    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
                        final DefaultListCellRenderer moduleRenderer = super.getRightCellRenderer(value);
                        return new DefaultListCellRenderer(){

                            @Override
                            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                JPanel panel = new JPanel(new BorderLayout());
                                if (moduleRenderer != null) {
                                    Component moduleComponent = moduleRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                                    if (!isSelected) {
                                        moduleComponent.setBackground(1.getBackgroundColor(value));
                                    }
                                    panel.add(moduleComponent, "Center");
                                }
                                rightArrow.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                                JLabel rightArrowComponent = rightArrow.getNextStepLabel();
                                panel.add((Component)rightArrowComponent, "East");
                                return panel;
                            }
                        };
                    }
                };
            }
        };
        popup.showInBestPositionFor(editor);
    }
}

