/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SurroundWithQuotesAnnotationParameterValueFix
implements IntentionAction {
    private final PsiAnnotationMemberValue myValue;
    private final PsiType myExpectedType;

    public SurroundWithQuotesAnnotationParameterValueFix(PsiAnnotationMemberValue value, PsiType expectedType) {
        this.myValue = value;
        this.myExpectedType = expectedType;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithQuotesAnnotationParameterValueFix", "isAvailable"));
        }
        if (!(this.myValue.isValid() && this.myExpectedType.isValid() && this.myExpectedType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedType = ((PsiClassType)this.myExpectedType).resolve();
        return resolvedType != null && "java.lang.String".equals(resolvedType.getQualifiedName()) && this.myValue instanceof PsiLiteralExpression;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithQuotesAnnotationParameterValueFix", "invoke"));
        }
        String newText = this.myValue.getText();
        newText = StringUtil.stripQuotesAroundValue((String)newText);
        newText = "\"" + newText + "\"";
        PsiExpression newToken = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(newText, null);
        PsiElement newElement = this.myValue.replace((PsiElement)newToken);
        editor.getCaretModel().moveToOffset(newElement.getTextOffset() + newElement.getTextLength());
    }

    @NotNull
    public String getFamilyName() {
        if ("Surround annotation parameter value with quotes" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithQuotesAnnotationParameterValueFix", "getFamilyName"));
        }
        return "Surround annotation parameter value with quotes";
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithQuotesAnnotationParameterValueFix", "getText"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

