/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.reference.SoftReference;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.Alarm;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickDocOnMouseOverManager {
    @NotNull
    private final MyEditorMouseListener myMouseListener;
    @NotNull
    private final VisibleAreaListener myVisibleAreaListener;
    @NotNull
    private final CaretListener myCaretListener;
    @NotNull
    private final DocumentListener myDocumentListener;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final Runnable myRequest;
    @NotNull
    private final Runnable myHintCloseCallback;
    @NotNull
    private final Map<Document, Boolean> myMonitoredDocuments;
    private final Map<Editor, PsiElement> myActiveElements;
    @Nullable
    private WeakReference<DocumentationManager> myDocumentationManager;
    @Nullable
    private DelayedQuickDocInfo myDelayedQuickDocInfo;
    private boolean myEnabled;
    private boolean myApplicationActive;

    public QuickDocOnMouseOverManager(@NotNull Application application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager", "<init>"));
        }
        this.myMouseListener = new MyEditorMouseListener();
        this.myVisibleAreaListener = new MyVisibleAreaListener();
        this.myCaretListener = new MyCaretListener();
        this.myDocumentListener = new MyDocumentListener();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myRequest = new MyShowQuickDocRequest();
        this.myHintCloseCallback = new MyCloseDocCallback();
        this.myMonitoredDocuments = new WeakHashMap();
        this.myActiveElements = new WeakHashMap();
        EditorFactory factory = EditorFactory.getInstance();
        if (factory != null) {
            factory.addEditorFactoryListener((EditorFactoryListener)new MyEditorFactoryListener(), (Disposable)application);
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener.Adapter(){

            public void applicationActivated(IdeFrame ideFrame) {
                QuickDocOnMouseOverManager.this.myApplicationActive = true;
            }

            public void applicationDeactivated(IdeFrame ideFrame) {
                QuickDocOnMouseOverManager.this.myApplicationActive = false;
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        });
    }

    public void setEnabled(boolean enabled) {
        EditorFactory factory;
        this.myEnabled = enabled;
        this.myApplicationActive = enabled;
        if (!enabled) {
            this.closeQuickDocIfPossible();
            this.myAlarm.cancelAllRequests();
        }
        if ((factory = EditorFactory.getInstance()) == null) {
            return;
        }
        for (Editor editor : factory.getAllEditors()) {
            if (enabled) {
                this.registerListeners(editor);
                continue;
            }
            this.unRegisterListeners(editor);
        }
    }

    private void registerListeners(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager", "registerListeners"));
        }
        editor.addEditorMouseListener((EditorMouseListener)this.myMouseListener);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.myMouseListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        editor.getCaretModel().addCaretListener(this.myCaretListener);
        Document document = editor.getDocument();
        if (this.myMonitoredDocuments.put(document, Boolean.TRUE) == null) {
            document.addDocumentListener(this.myDocumentListener);
        }
    }

    private void unRegisterListeners(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager", "unRegisterListeners"));
        }
        editor.removeEditorMouseListener((EditorMouseListener)this.myMouseListener);
        editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this.myMouseListener);
        editor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        editor.getCaretModel().removeCaretListener(this.myCaretListener);
        Document document = editor.getDocument();
        if (this.myMonitoredDocuments.remove(document) != null) {
            document.removeDocumentListener(this.myDocumentListener);
        }
    }

    private void processMouseExited() {
        this.myDelayedQuickDocInfo = null;
    }

    private void processMouseMove(@NotNull EditorMouseEvent e) {
        PsiFile psiFile;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager", "processMouseMove"));
        }
        if (!this.myApplicationActive || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
            this.closeQuickDocIfPossible();
            return;
        }
        if (e.getMouseEvent().getModifiers() != 0) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.getComponent().getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING) != null) {
            return;
        }
        if (editor.isOneLineMode()) {
            return;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return;
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance(project2);
        JBPopup hint = documentationManager.getDocInfoHint();
        if (hint != null) {
            DocumentationManager manager = this.getDocManager();
            if (manager == null || !manager.isCloseOnSneeze()) {
                return;
            }
            Point hintLocation = hint.getLocationOnScreen();
            Dimension hintSize = hint.getSize();
            int mouseX = e.getMouseEvent().getXOnScreen();
            int mouseY = e.getMouseEvent().getYOnScreen();
            if (mouseX >= hintLocation.x && mouseX <= hintLocation.x + hintSize.width && mouseY >= hintLocation.y && mouseY <= hintLocation.y + hintSize.height) {
                return;
            }
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) == null) {
            this.closeQuickDocIfPossible();
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (editor instanceof EditorEx && ((EditorEx)editor).getFoldingModel().getFoldingPlaceholderAt(point) != null) {
            this.closeQuickDocIfPossible();
            return;
        }
        VisualPosition visualPosition = editor.xyToVisualPosition(point);
        if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(visualPosition)) {
            this.closeQuickDocIfPossible();
            return;
        }
        int mouseOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(visualPosition));
        PsiElement elementUnderMouse = psiFile.findElementAt(mouseOffset);
        if (elementUnderMouse == null || elementUnderMouse instanceof PsiWhiteSpace || elementUnderMouse instanceof PsiPlainText) {
            this.closeQuickDocIfPossible();
            return;
        }
        PsiElement targetElementUnderMouse = documentationManager.findTargetElement(editor, mouseOffset, psiFile, elementUnderMouse);
        if (targetElementUnderMouse == null) {
            this.closeQuickDocIfPossible();
            return;
        }
        PsiElement activeElement = this.myActiveElements.get(editor);
        if (targetElementUnderMouse.equals(activeElement) && (!this.myAlarm.isEmpty() || hint != null)) {
            return;
        }
        this.allowUpdateFromContext(project2, false);
        this.closeQuickDocIfPossible();
        this.myActiveElements.put(editor, targetElementUnderMouse);
        this.myDelayedQuickDocInfo = new DelayedQuickDocInfo(documentationManager, editor, targetElementUnderMouse, elementUnderMouse);
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this.myRequest, EditorSettingsExternalizable.getInstance().getQuickDocOnMouseOverElementDelayMillis());
    }

    private void closeQuickDocIfPossible() {
        this.myAlarm.cancelAllRequests();
        DocumentationManager docManager = this.getDocManager();
        if (docManager == null) {
            return;
        }
        JBPopup hint = docManager.getDocInfoHint();
        if (hint == null) {
            return;
        }
        hint.cancel();
        this.myDocumentationManager = null;
    }

    private void allowUpdateFromContext(Project project2, boolean allow) {
        DocumentationManager documentationManager = this.getDocManager();
        if (documentationManager != null && documentationManager.getProject(null) == project2) {
            documentationManager.setAllowContentUpdateFromContext(allow);
        }
    }

    @Nullable
    private DocumentationManager getDocManager() {
        return (DocumentationManager)SoftReference.dereference(this.myDocumentationManager);
    }

    @Nullable
    private Editor getEditor() {
        DocumentationManager manager = this.getDocManager();
        return manager == null ? null : manager.getEditor();
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private MyDocumentListener() {
        }

        public void documentChanged(DocumentEvent e) {
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor.getDocument() == e.getDocument()) {
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }
    }

    private class MyCaretListener
    extends CaretAdapter {
        private MyCaretListener() {
        }

        public void caretPositionChanged(CaretEvent e) {
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor == e.getEditor()) {
                QuickDocOnMouseOverManager.this.allowUpdateFromContext(e.getEditor().getProject(), true);
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor == e.getEditor()) {
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }
    }

    private class MyEditorMouseListener
    extends EditorMouseAdapter
    implements EditorMouseMotionListener {
        private MyEditorMouseListener() {
        }

        public void mouseExited(EditorMouseEvent e) {
            QuickDocOnMouseOverManager.this.processMouseExited();
        }

        public void mouseMoved(EditorMouseEvent e) {
            QuickDocOnMouseOverManager.this.processMouseMove(e);
        }

        public void mouseDragged(EditorMouseEvent e) {
        }
    }

    private class MyEditorFactoryListener
    implements EditorFactoryListener {
        private MyEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyEditorFactoryListener", "editorCreated"));
            }
            if (QuickDocOnMouseOverManager.this.myEnabled) {
                QuickDocOnMouseOverManager.this.registerListeners(event.getEditor());
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyEditorFactoryListener", "editorReleased"));
            }
            if (QuickDocOnMouseOverManager.this.myEnabled) {
                QuickDocOnMouseOverManager.this.unRegisterListeners(event.getEditor());
            }
        }
    }

    private class MyCloseDocCallback
    implements Runnable {
        private MyCloseDocCallback() {
        }

        @Override
        public void run() {
            QuickDocOnMouseOverManager.this.myActiveElements.clear();
            QuickDocOnMouseOverManager.this.myDocumentationManager = null;
        }
    }

    private class MyShowQuickDocRequest
    implements Runnable {
        private final HintManager myHintManager = HintManager.getInstance();

        private MyShowQuickDocRequest() {
        }

        @Override
        public void run() {
            QuickDocOnMouseOverManager.this.myAlarm.cancelAllRequests();
            DelayedQuickDocInfo info = QuickDocOnMouseOverManager.this.myDelayedQuickDocInfo;
            if (info == null || !info.targetElement.equals(QuickDocOnMouseOverManager.this.myActiveElements.get(info.editor))) {
                return;
            }
            if (info.docManager.getDocInfoHint() != null && !info.docManager.isCloseOnSneeze()) {
                return;
            }
            if (!info.docManager.hasActiveDockedDocWindow() && this.myHintManager.hasShownHintsThatWillHideByOtherHint(false)) {
                QuickDocOnMouseOverManager.this.myAlarm.addRequest((Runnable)this, EditorSettingsExternalizable.getInstance().getQuickDocOnMouseOverElementDelayMillis());
                return;
            }
            info.editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, (Object)info.editor.offsetToVisualPosition(info.originalElement.getTextRange().getStartOffset()));
            try {
                info.docManager.showJavaDocInfo(info.editor, info.targetElement, info.originalElement, QuickDocOnMouseOverManager.this.myHintCloseCallback, true);
                QuickDocOnMouseOverManager.this.myDocumentationManager = new WeakReference<DocumentationManager>(info.docManager);
            }
            finally {
                info.editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
            }
        }
    }

    private static class DelayedQuickDocInfo {
        @NotNull
        public final DocumentationManager docManager;
        @NotNull
        public final Editor editor;
        @NotNull
        public final PsiElement targetElement;
        @NotNull
        public final PsiElement originalElement;

        private DelayedQuickDocInfo(@NotNull DocumentationManager docManager, @NotNull Editor editor, @NotNull PsiElement targetElement, @NotNull PsiElement originalElement) {
            if (docManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docManager", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$DelayedQuickDocInfo", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$DelayedQuickDocInfo", "<init>"));
            }
            if (targetElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$DelayedQuickDocInfo", "<init>"));
            }
            if (originalElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$DelayedQuickDocInfo", "<init>"));
            }
            this.docManager = docManager;
            this.editor = editor;
            this.targetElement = targetElement;
            this.originalElement = originalElement;
        }
    }
}

