/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.guess.impl.ExpressionTypeMemoryState;
import com.intellij.codeInsight.guess.impl.MethodPattern;
import com.intellij.codeInsight.guess.impl.MethodPatternMap;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuessManagerImpl
extends GuessManager {
    private final MethodPatternMap myMethodPatternMap = new MethodPatternMap();
    private final Project myProject;
    private static final int CHECK_USAGE = 1;
    private static final int CHECK_UP = 2;
    private static final int CHECK_DOWN = 4;

    private void initMethodPatterns() {
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("contains", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("remove", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("addElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("elementAt", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("firstElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("get", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("insertElementAt", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("removeElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("set", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("setElementAt", 2, 0));
    }

    public GuessManagerImpl(Project project2) {
        this.initMethodPatterns();
        this.myProject = project2;
    }

    @Override
    public PsiType[] guessContainerElementType(PsiExpression containerExpr, TextRange rangeToIgnore) {
        PsiElement refElement;
        HashSet<PsiType> typesSet = new HashSet<PsiType>();
        PsiType type = containerExpr.getType();
        PsiType elemType = GuessManagerImpl.getGenericElementType(type);
        if (elemType != null) {
            return new PsiType[]{elemType};
        }
        if (containerExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)containerExpr).resolve()) instanceof PsiVariable) {
            PsiFile file2 = refElement.getContainingFile();
            if (file2 == null) {
                file2 = containerExpr.getContainingFile();
            }
            HashSet<PsiVariable> checkedVariables = new HashSet<PsiVariable>();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file2, checkedVariables, 5, rangeToIgnore);
            checkedVariables.clear();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file2, checkedVariables, 2, rangeToIgnore);
        }
        return typesSet.toArray(PsiType.createArray((int)typesSet.size()));
    }

    @Nullable
    private static PsiType getGenericElementType(PsiType collectionType) {
        PsiClassType classType;
        PsiType[] parameters;
        if (collectionType instanceof PsiClassType && (parameters = (classType = (PsiClassType)collectionType).getParameters()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    @Override
    public PsiType[] guessTypeToCast(PsiExpression expr) {
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        ContainerUtil.addIfNotNull((Object)this.getControlFlowExpressionType(expr), types);
        this.addExprTypesWhenContainerElement(types, expr);
        this.addExprTypesByDerivedClasses(types, expr);
        return types.toArray(PsiType.createArray((int)types.size()));
    }

    @Override
    @NotNull
    public Map<PsiExpression, PsiType> getControlFlowExpressionTypes(@NotNull PsiExpression forPlace) {
        if (forPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forPlace", "com/intellij/codeInsight/guess/impl/GuessManagerImpl", "getControlFlowExpressionTypes"));
        }
        Map<PsiExpression, PsiType> typeMap = GuessManagerImpl.buildDataflowTypeMap(forPlace);
        if (typeMap != null) {
            Map<PsiExpression, PsiType> map = typeMap;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/guess/impl/GuessManagerImpl", "getControlFlowExpressionTypes"));
            }
            return map;
        }
        Map<PsiExpression, PsiType> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/guess/impl/GuessManagerImpl", "getControlFlowExpressionTypes"));
        }
        return map;
    }

    @Nullable
    private static Map<PsiExpression, PsiType> buildDataflowTypeMap(PsiExpression forPlace) {
        ExpressionTypeInstructionVisitor visitor;
        DataFlowRunner runner;
        PsiCodeBlock scope = DfaPsiUtil.getTopmostBlockInSameClass((PsiElement)forPlace);
        if (scope == null) {
            PsiFile file2 = forPlace.getContainingFile();
            if (!(file2 instanceof PsiCodeFragment)) {
                return Collections.emptyMap();
            }
            scope = file2;
        }
        if ((runner = new DataFlowRunner(){

            @Override
            @NotNull
            protected DfaMemoryState createMemoryState() {
                ExpressionTypeMemoryState expressionTypeMemoryState = new ExpressionTypeMemoryState(this.getFactory());
                if (expressionTypeMemoryState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/guess/impl/GuessManagerImpl$1", "createMemoryState"));
                }
                return expressionTypeMemoryState;
            }
        }).analyzeMethod((PsiElement)scope, visitor = new ExpressionTypeInstructionVisitor((PsiElement)forPlace)) == RunnerResult.OK) {
            return visitor.getResult();
        }
        return null;
    }

    private static Map<PsiExpression, PsiType> getAllTypeCasts(PsiExpression forPlace) {
        assert (forPlace.isValid());
        int start = forPlace.getTextRange().getStartOffset();
        THashMap allCasts = new THashMap(ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY);
        GuessManagerImpl.getTopmostBlock((PsiElement)forPlace).accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)allCasts, start){
            final /* synthetic */ Map val$allCasts;
            final /* synthetic */ int val$start;
            {
                this.val$allCasts = map;
                this.val$start = n;
            }

            public void visitTypeCastExpression(PsiTypeCastExpression expression) {
                PsiType castType = expression.getType();
                PsiExpression operand = expression.getOperand();
                if (operand != null && castType != null) {
                    this.val$allCasts.put(operand, castType);
                }
                super.visitTypeCastExpression(expression);
            }

            public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
                PsiTypeElement castType = expression.getCheckType();
                PsiExpression operand = expression.getOperand();
                if (castType != null) {
                    this.val$allCasts.put(operand, castType.getType());
                }
                super.visitInstanceOfExpression(expression);
            }

            public void visitElement(PsiElement element) {
                if (element.getTextRange().getStartOffset() > this.val$start) {
                    return;
                }
                super.visitElement(element);
            }
        });
        return allCasts;
    }

    private static PsiElement getTopmostBlock(PsiElement scope) {
        PsiFile file2;
        PsiCodeBlock lastCodeBlock;
        assert (scope.isValid());
        PsiElement lastScope = scope;
        while ((lastCodeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)lastScope, PsiCodeBlock.class, (boolean)true)) != null) {
            lastScope = lastCodeBlock;
        }
        if (lastScope == scope && (file2 = scope.getContainingFile()) instanceof PsiCodeFragment) {
            return file2;
        }
        return lastScope;
    }

    private void addExprTypesByDerivedClasses(LinkedHashSet<PsiType> set, PsiExpression expr) {
        PsiType type = expr.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass refClass = PsiUtil.resolveClassInType((PsiType)type);
        if (refClass == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        ClassInheritorsSearch.search((PsiClass)refClass, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        if (processor2.isOverflow()) {
            return;
        }
        for (PsiClass derivedClass : processor2.getCollection()) {
            if (derivedClass instanceof PsiAnonymousClass) continue;
            PsiClassType derivedType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(derivedClass);
            set.add((PsiType)derivedType);
        }
    }

    private void addExprTypesWhenContainerElement(LinkedHashSet<PsiType> set, PsiExpression expr) {
        PsiExpression qualifier;
        PsiMethodCallExpression callExpr;
        PsiReferenceExpression methodExpr;
        String methodName;
        MethodPattern pattern;
        if (expr instanceof PsiMethodCallExpression && (pattern = this.myMethodPatternMap.findPattern(methodName = (methodExpr = (callExpr = (PsiMethodCallExpression)expr).getMethodExpression()).getReferenceName(), callExpr.getArgumentList().getExpressions().length)) != null && pattern.parameterIndex < 0 && (qualifier = methodExpr.getQualifierExpression()) != null) {
            PsiType[] types;
            for (PsiType type : types = this.guessContainerElementType(qualifier, null)) {
                if (type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiAnonymousClass) continue;
                set.add(type);
            }
        }
    }

    private void addTypesByVariable(HashSet<PsiType> typesSet, PsiVariable var, PsiFile scopeFile, HashSet<PsiVariable> checkedVariables, int flags, TextRange rangeToIgnore) {
        if (!checkedVariables.add(var)) {
            return;
        }
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)scopeFile);
        if ((flags & 5) != 0) {
            for (PsiReference varRef : ReferencesSearch.search((PsiElement)var, (SearchScope)searchScope, (boolean)false)) {
                PsiParameter[] parameters;
                PsiMethodCallExpression methodCall;
                PsiMethod method;
                PsiType type;
                PsiElement ref = varRef.getElement();
                if ((flags & 1) != 0 && (type = GuessManagerImpl.guessElementTypeFromReference(this.myMethodPatternMap, ref, rangeToIgnore)) != null && !(type instanceof PsiPrimitiveType)) {
                    typesSet.add(type);
                }
                if ((flags & 4) == 0 || !(ref.getParent() instanceof PsiExpressionList) || !(ref.getParent().getParent() instanceof PsiMethodCallExpression)) continue;
                PsiExpressionList list = (PsiExpressionList)ref.getParent();
                PsiExpression[] args = list.getExpressions();
                int argIndex = -1;
                for (int j = 0; j < args.length; ++j) {
                    PsiExpression arg = args[j];
                    if (!arg.equals(ref)) continue;
                    argIndex = j;
                    break;
                }
                if ((method = (PsiMethod)(methodCall = (PsiMethodCallExpression)list.getParent()).getMethodExpression().resolve()) == null || argIndex >= (parameters = method.getParameterList().getParameters()).length) continue;
                this.addTypesByVariable(typesSet, (PsiVariable)parameters[argIndex], method.getContainingFile(), checkedVariables, flags | 1, rangeToIgnore);
            }
        }
        if ((flags & 2) != 0 && var instanceof PsiParameter && var.getParent() instanceof PsiParameterList && var.getParent().getParent() instanceof PsiMethod) {
            PsiParameterList list = (PsiParameterList)var.getParent();
            PsiParameter[] parameters = list.getParameters();
            int argIndex = -1;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                if (!parameter.equals(var)) continue;
                argIndex = i;
                break;
            }
            PsiMethod method = (PsiMethod)var.getParent().getParent();
            for (PsiReference methodRef : ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope, (boolean)false)) {
                PsiElement refElement;
                PsiExpression arg;
                PsiMethodCallExpression methodCall;
                PsiExpression[] args;
                PsiElement ref = methodRef.getElement();
                if (!(ref.getParent() instanceof PsiMethodCallExpression) || (args = (methodCall = (PsiMethodCallExpression)ref.getParent()).getArgumentList().getExpressions()).length <= argIndex || !((arg = args[argIndex]) instanceof PsiReferenceExpression) || !((refElement = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable)) continue;
                this.addTypesByVariable(typesSet, (PsiVariable)refElement, scopeFile, checkedVariables, flags | 1, rangeToIgnore);
            }
        }
    }

    @Nullable
    private static PsiType guessElementTypeFromReference(MethodPatternMap methodPatternMap, PsiElement ref, TextRange rangeToIgnore) {
        PsiMethodCallExpression methodCall;
        PsiExpression[] args;
        String methodName;
        MethodPattern pattern;
        PsiReferenceExpression parentExpr;
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && ref.equals((parentExpr = (PsiReferenceExpression)refParent).getQualifierExpression()) && parentExpr.getParent() instanceof PsiMethodCallExpression && (pattern = methodPatternMap.findPattern(methodName = parentExpr.getReferenceName(), (args = (methodCall = (PsiMethodCallExpression)parentExpr.getParent()).getArgumentList().getExpressions()).length)) != null) {
            if (pattern.parameterIndex < 0) {
                if (methodCall.getParent() instanceof PsiTypeCastExpression && (rangeToIgnore == null || !rangeToIgnore.contains(methodCall.getTextRange()))) {
                    return ((PsiTypeCastExpression)methodCall.getParent()).getType();
                }
            } else {
                return args[pattern.parameterIndex].getType();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getControlFlowExpressionType(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/guess/impl/GuessManagerImpl", "getControlFlowExpressionType"));
        }
        Map<PsiExpression, PsiType> allCasts = GuessManagerImpl.getAllTypeCasts(expr);
        if (!allCasts.containsKey(expr)) {
            return null;
        }
        Map<PsiExpression, PsiType> fromDfa = GuessManagerImpl.buildDataflowTypeMap(expr);
        if (fromDfa != null) {
            return fromDfa.get(expr);
        }
        return null;
    }

    private static class ExpressionTypeInstructionVisitor
    extends InstructionVisitor {
        private Map<PsiExpression, PsiType> myResult;
        private final PsiElement myForPlace;

        private ExpressionTypeInstructionVisitor(PsiElement forPlace) {
            this.myForPlace = forPlace;
        }

        public Map<PsiExpression, PsiType> getResult() {
            return this.myResult;
        }

        @Override
        public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            memState.pop();
            memState.pop();
            memState.push(new DfaInstanceofValue(runner.getFactory(), instruction.getLeft(), instruction.getCastType()));
            return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState)};
        }

        @Override
        public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            ((ExpressionTypeMemoryState)memState).setExpressionType(instruction.getCasted(), instruction.getCastTo());
            return super.visitTypeCast(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myForPlace == instruction.getCallExpression()) {
                this.addToResult(((ExpressionTypeMemoryState)memState).getStates());
            }
            return super.visitMethodCall(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myForPlace == instruction.getPlace()) {
                this.addToResult(((ExpressionTypeMemoryState)memState).getStates());
            }
            return super.visitPush(instruction, runner, memState);
        }

        private void addToResult(Map<PsiExpression, PsiType> map) {
            if (this.myResult == null) {
                this.myResult = new THashMap(map, ExpressionTypeMemoryState.EXPRESSION_HASHING_STRATEGY);
            } else {
                Iterator<PsiExpression> iterator = this.myResult.keySet().iterator();
                while (iterator.hasNext()) {
                    PsiExpression psiExpression = iterator.next();
                    if (this.myResult.get(psiExpression).equals(map.get(psiExpression))) continue;
                    iterator.remove();
                }
            }
        }
    }
}

