/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BindFieldsFromParametersAction
extends BaseIntentionAction
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CreateFieldFromParameterAction.class);
    private static final Key<Map<SmartPsiElementPointer<PsiParameter>, Boolean>> PARAMS = Key.create((String)"FIELDS_FROM_PARAMS");
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "isAvailable"));
        }
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        PsiMethod method = BindFieldsFromParametersAction.findMethod(psiParameter, editor, file2);
        if (method == null) {
            return false;
        }
        List<PsiParameter> parameters = BindFieldsFromParametersAction.getAvailableParameters(method);
        Object object = LOCK;
        synchronized (object) {
            Collection<SmartPsiElementPointer<PsiParameter>> params = BindFieldsFromParametersAction.getUnboundedParams(method);
            params.clear();
            for (PsiParameter parameter : parameters) {
                params.add((SmartPsiElementPointer<PsiParameter>)SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)parameter));
            }
            if (params.isEmpty()) {
                return false;
            }
            if (params.size() == 1 && psiParameter != null) {
                return false;
            }
            if (psiParameter == null) {
                psiParameter = (PsiParameter)params.iterator().next().getElement();
                LOG.assertTrue(psiParameter != null);
            }
            this.setText(CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.text", (Object[])new Object[]{method.isConstructor() ? "constructor" : "method"}));
        }
        return BindFieldsFromParametersAction.isAvailable(psiParameter);
    }

    @Nullable
    private static PsiMethod findMethod(@Nullable PsiParameter parameter, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "findMethod"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "findMethod"));
        }
        if (parameter == null) {
            PsiElement parent;
            PsiElement elementAt = file2.findElementAt(editor.getCaretModel().getOffset());
            if (elementAt instanceof PsiIdentifier && (parent = elementAt.getParent()) instanceof PsiMethod) {
                return (PsiMethod)parent;
            }
        } else {
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiMethod) {
                return (PsiMethod)declarationScope;
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiParameter> getAvailableParameters(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getAvailableParameters"));
        }
        ArrayList<PsiParameter> parameters = new ArrayList<PsiParameter>();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!BindFieldsFromParametersAction.isAvailable(parameter)) continue;
            parameters.add(parameter);
        }
        ArrayList<PsiParameter> arrayList = parameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getAvailableParameters"));
        }
        return arrayList;
    }

    private static boolean isAvailable(PsiParameter psiParameter) {
        PsiClass targetClass;
        PsiType type = FieldFromParameterUtils.getSubstitutedType(psiParameter);
        return FieldFromParameterUtils.isAvailable(psiParameter, type, targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiParameter, PsiClass.class)) && psiParameter.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> getUnboundedParams(PsiMethod psiMethod) {
        Map params = (Map)psiMethod.getUserData(PARAMS);
        if (params == null) {
            params = ContainerUtil.createConcurrentWeakMap();
            psiMethod.putUserData(PARAMS, (Object)params);
        }
        final Map finalParams = params;
        AbstractCollection<SmartPsiElementPointer<PsiParameter>> abstractCollection = new AbstractCollection<SmartPsiElementPointer<PsiParameter>>(){

            @Override
            public boolean add(SmartPsiElementPointer<PsiParameter> psiVariable) {
                return finalParams.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            public Iterator<SmartPsiElementPointer<PsiParameter>> iterator() {
                return finalParams.keySet().iterator();
            }

            @Override
            public int size() {
                return finalParams.size();
            }

            @Override
            public void clear() {
                finalParams.clear();
            }
        };
        if (abstractCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getUnboundedParams"));
        }
        return abstractCollection;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "invoke"));
        }
        BindFieldsFromParametersAction.invoke(project2, editor, file2, !ApplicationManager.getApplication().isUnitTestMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invoke(Project project2, Editor editor, PsiFile file2, boolean isInteractive) {
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiMethod method = psiParameter != null ? (PsiMethod)psiParameter.getDeclarationScope() : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PsiMethod.class);
        LOG.assertTrue(method != null);
        HashSet<String> usedNames = new HashSet<String>();
        Iterable<PsiParameter> parameters = BindFieldsFromParametersAction.selectParameters(project2, method, BindFieldsFromParametersAction.copyUnboundedParamsAndClearOriginal(method), isInteractive);
        MultiMap types = new MultiMap();
        for (PsiParameter parameter : parameters) {
            types.putValue((Object)parameter.getType(), (Object)parameter);
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2);
        boolean preferLongerNames = settings.PREFER_LONGER_NAMES;
        for (PsiParameter selected : parameters) {
            try {
                settings.PREFER_LONGER_NAMES = preferLongerNames || types.get((Object)selected.getType()).size() > 1;
                BindFieldsFromParametersAction.processParameter(project2, selected, usedNames);
            }
            finally {
                settings.PREFER_LONGER_NAMES = preferLongerNames;
            }
        }
    }

    @NotNull
    private static Iterable<PsiParameter> selectParameters(@NotNull Project project2, @NotNull PsiMethod method, @NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams, boolean isInteractive) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        if (unboundedParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboundedParams", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        if (unboundedParams.size() < 2 || !isInteractive) {
            List<PsiParameter> list = BindFieldsFromParametersAction.revealPointers(unboundedParams);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
            }
            return list;
        }
        ParameterClassMember[] members = BindFieldsFromParametersAction.sortByParameterIndex(BindFieldsFromParametersAction.toClassMemberArray(unboundedParams), method);
        MemberChooser<ParameterClassMember> chooser = BindFieldsFromParametersAction.showChooser(project2, method, members);
        List<ParameterClassMember> selectedElements = chooser.getSelectedElements();
        if (chooser.getExitCode() != 0 || selectedElements == null) {
            List<PsiParameter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
            }
            return list;
        }
        List<PsiParameter> list = BindFieldsFromParametersAction.revealParameterClassMembers(selectedElements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        return list;
    }

    @NotNull
    private static MemberChooser<ParameterClassMember> showChooser(@NotNull Project project2, @NotNull PsiMethod method, @NotNull ParameterClassMember[] members) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        MemberChooser chooser = new MemberChooser((ClassMember[])members, false, true, project2);
        chooser.selectElements(members);
        chooser.setTitle("Choose " + (method.isConstructor() ? "Constructor" : "Method") + " Parameters");
        chooser.show();
        MemberChooser memberChooser = chooser;
        if (memberChooser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        return memberChooser;
    }

    @NotNull
    private static ParameterClassMember[] sortByParameterIndex(@NotNull ParameterClassMember[] members, @NotNull PsiMethod method) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "sortByParameterIndex"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "sortByParameterIndex"));
        }
        final PsiParameterList parameterList = method.getParameterList();
        Arrays.sort(members, new Comparator<ParameterClassMember>(){

            @Override
            public int compare(ParameterClassMember o1, ParameterClassMember o2) {
                return parameterList.getParameterIndex(o1.getParameter()) - parameterList.getParameterIndex(o2.getParameter());
            }
        });
        if (members == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "sortByParameterIndex"));
        }
        return members;
    }

    @NotNull
    private static <T extends PsiElement> List<T> revealPointers(@NotNull Iterable<SmartPsiElementPointer<T>> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealPointers"));
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer<T> pointer : pointers) {
            result2.add(pointer.getElement());
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealPointers"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiParameter> revealParameterClassMembers(@NotNull Iterable<ParameterClassMember> parameterClassMembers) {
        if (parameterClassMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterClassMembers", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealParameterClassMembers"));
        }
        ArrayList<PsiParameter> result2 = new ArrayList<PsiParameter>();
        for (ParameterClassMember parameterClassMember : parameterClassMembers) {
            result2.add(parameterClassMember.getParameter());
        }
        ArrayList<PsiParameter> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealParameterClassMembers"));
        }
        return arrayList;
    }

    @NotNull
    private static ParameterClassMember[] toClassMemberArray(@NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams) {
        if (unboundedParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboundedParams", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "toClassMemberArray"));
        }
        ParameterClassMember[] result2 = new ParameterClassMember[unboundedParams.size()];
        int i = 0;
        for (SmartPsiElementPointer<PsiParameter> pointer : unboundedParams) {
            result2[i++] = new ParameterClassMember((PsiParameter)pointer.getElement());
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "toClassMemberArray"));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> copyUnboundedParamsAndClearOriginal(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "copyUnboundedParamsAndClearOriginal"));
        }
        Object object = LOCK;
        // MONITORENTER : object
        Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams = BindFieldsFromParametersAction.getUnboundedParams(method);
        ArrayList<SmartPsiElementPointer<PsiParameter>> result2 = new ArrayList<SmartPsiElementPointer<PsiParameter>>(unboundedParams);
        unboundedParams.clear();
        ArrayList<SmartPsiElementPointer<PsiParameter>> arrayList = result2;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "copyUnboundedParamsAndClearOriginal"));
    }

    private static void processParameter(final Project project2, final PsiParameter parameter, Set<String> usedNames) {
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        final PsiType type = FieldFromParameterUtils.getSubstitutedType(parameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String parameterName = parameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        final PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiClass.class);
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (!(declarationScope instanceof PsiMethod)) {
            return;
        }
        final PsiMethod method = (PsiMethod)declarationScope;
        final boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind, propertyName, null, type);
        String[] names = suggestedNameInfo.names;
        final boolean isFinal = !isMethodStatic && method.isConstructor();
        String name = names[0];
        if (targetClass != null) {
            for (String curName : names) {
                if (usedNames.contains(curName) || targetClass.findFieldByName(curName, false) == null) continue;
                name = curName;
                break;
            }
        }
        if (usedNames.contains(name)) {
            for (String curName : names) {
                if (usedNames.contains(curName)) continue;
                name = curName;
                break;
            }
        }
        final String fieldName = usedNames.add(name) ? name : JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName(name, (PsiElement)parameter, true);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    FieldFromParameterUtils.createFieldAndAddAssignment(project2, targetClass, method, parameter, type, fieldName, isMethodStatic, isFinal);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

