/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldFromParameterUtils {
    @Nullable
    public static PsiParameter findParameterAtCursor(@NotNull PsiFile file2, @NotNull Editor editor) {
        PsiParameter[] parameters;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "findParameterAtCursor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "findParameterAtCursor"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiParameterList.class, (boolean)false);
        if (parameterList == null) {
            return null;
        }
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            TextRange range = parameter.getTextRange();
            if (range.getStartOffset() > offset || offset > range.getEndOffset()) continue;
            return parameter;
        }
        return null;
    }

    @Nullable
    public static PsiType getType(@Nullable PsiParameter myParameter) {
        if (myParameter == null) {
            return null;
        }
        PsiType type = myParameter.getType();
        return type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type;
    }

    @Nullable
    public static PsiType getSubstitutedType(@Nullable PsiParameter parameter) {
        if (parameter == null) {
            return null;
        }
        PsiType type = FieldFromParameterUtils.getType(parameter);
        if (type instanceof PsiArrayType) {
            return type;
        }
        PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType((PsiType)type);
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return type;
        }
        HashSet<PsiTypeParameter> usedTypeParameters = new HashSet<PsiTypeParameter>();
        RefactoringUtil.collectTypeParameters(usedTypeParameters, (PsiElement)parameter);
        Iterator iterator = usedTypeParameters.iterator();
        while (iterator.hasNext()) {
            PsiTypeParameter usedTypeParameter = (PsiTypeParameter)iterator.next();
            if (parameter.getDeclarationScope() == usedTypeParameter.getOwner()) continue;
            iterator.remove();
        }
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter usedTypeParameter : usedTypeParameters) {
            PsiType bound = TypeConversionUtil.typeParameterErasure((PsiTypeParameter)usedTypeParameter);
            PsiManager manager = usedTypeParameter.getManager();
            subst = subst.put(usedTypeParameter, (PsiType)(bound == null ? PsiWildcardType.createUnbounded((PsiManager)manager) : (bound.equalsToText("java.lang.Object") ? bound : PsiWildcardType.createExtends((PsiManager)manager, (PsiType)bound))));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        Map typeMap = result2.getSubstitutor().getSubstitutionMap();
        Iterator iterator2 = typeMap.keySet().iterator();
        while (iterator2.hasNext()) {
            PsiTypeParameter typeParameter;
            PsiType psiType = (PsiType)typeMap.get(typeParameter = (PsiTypeParameter)iterator2.next());
            substitutor = substitutor.put(typeParameter, psiType != null ? subst.substitute(psiType) : null);
        }
        if (psiClass instanceof PsiTypeParameter) {
            return GenericsUtil.getVariableTypeByExpressionType((PsiType)subst.substitute((PsiTypeParameter)psiClass));
        }
        return JavaPsiFacade.getElementFactory((Project)parameter.getProject()).createType(psiClass, substitutor);
    }

    @Nullable
    public static PsiField getParameterAssignedToField(PsiParameter parameter) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(parameter.getDeclarationScope()), (boolean)false)) {
            PsiElement element;
            PsiExpression lExpression;
            PsiAssignmentExpression assignmentExpression;
            PsiReferenceExpression expression;
            if (!(reference instanceof PsiReferenceExpression) || !((expression = (PsiReferenceExpression)reference).getParent() instanceof PsiAssignmentExpression) || (assignmentExpression = (PsiAssignmentExpression)expression.getParent()).getRExpression() != expression || !((lExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression) || !((element = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField)) continue;
            return (PsiField)element;
        }
        return null;
    }

    public static int findFieldAssignmentAnchor(PsiStatement[] statements, @Nullable Ref<Pair<PsiField, Boolean>> anchorRef, PsiClass targetClass, PsiParameter myParameter) {
        PsiStatement psiStatement;
        int i;
        for (i = 0; i < statements.length && (psiStatement = statements[i]) instanceof PsiExpressionStatement; ++i) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)psiStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                String text = methodCallExpression.getMethodExpression().getText();
                if (!text.equals("super") && !text.equals("this")) break;
                continue;
            }
            if (!(expression instanceof PsiAssignmentExpression)) break;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            PsiExpression rExpression = assignmentExpression.getRExpression();
            if (!(lExpression instanceof PsiReferenceExpression) || !(rExpression instanceof PsiReferenceExpression)) break;
            PsiReferenceExpression lReference = (PsiReferenceExpression)lExpression;
            PsiReferenceExpression rReference = (PsiReferenceExpression)rExpression;
            PsiElement lElement = lReference.resolve();
            PsiElement rElement = rReference.resolve();
            if (!(lElement instanceof PsiField) || ((PsiField)lElement).getContainingClass() != targetClass || !(rElement instanceof PsiParameter)) break;
            if (myParameter.getTextRange().getStartOffset() < rElement.getTextRange().getStartOffset()) {
                if (anchorRef == null) break;
                anchorRef.set((Object)Pair.create((Object)((PsiField)lElement), (Object)Boolean.TRUE));
                break;
            }
            if (anchorRef == null) continue;
            anchorRef.set((Object)Pair.create((Object)((PsiField)lElement), (Object)Boolean.FALSE));
        }
        return i;
    }

    public static void createFieldAndAddAssignment(@NotNull Project project2, @NotNull PsiClass targetClass, @NotNull PsiMethod method, @NotNull PsiParameter parameter, @NotNull PsiType fieldType, @NotNull String fieldName, boolean isStatic, boolean isFinal) throws IncorrectOperationException {
        PsiCodeBlock methodBody;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "createFieldAndAddAssignment"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "createFieldAndAddAssignment"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "createFieldAndAddAssignment"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "createFieldAndAddAssignment"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "createFieldAndAddAssignment"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/codeInsight/intention/impl/FieldFromParameterUtils", "createFieldAndAddAssignment"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        PsiField field = factory.createField(fieldName, fieldType);
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("static", isStatic);
        modifierList.setModifierProperty("final", isFinal);
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (manager.copyNullableAnnotation((PsiModifierListOwner)parameter, (PsiModifierListOwner)field) == null && isFinal) {
            manager.copyNotNullAnnotation((PsiModifierListOwner)parameter, (PsiModifierListOwner)field);
        }
        if ((methodBody = method.getBody()) == null) {
            return;
        }
        PsiStatement[] statements = methodBody.getStatements();
        Ref anchorRef = new Ref();
        int i = FieldFromParameterUtils.findFieldAssignmentAnchor(statements, (Ref<Pair<PsiField, Boolean>>)anchorRef, targetClass, parameter);
        Pair fieldAnchor = (Pair)anchorRef.get();
        String stmtText = fieldName + " = " + parameter.getName() + ";";
        if (fieldName.equals(parameter.getName())) {
            String prefix = isStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
            stmtText = prefix + stmtText;
        }
        PsiStatement assignmentStmt = factory.createStatementFromText(stmtText, (PsiElement)methodBody);
        assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)assignmentStmt);
        if (i == statements.length) {
            methodBody.add((PsiElement)assignmentStmt);
        } else {
            methodBody.addAfter((PsiElement)assignmentStmt, i > 0 ? statements[i - 1] : null);
        }
        if (fieldAnchor != null) {
            PsiVariable psiVariable = (PsiVariable)fieldAnchor.getFirst();
            psiVariable.normalizeDeclaration();
        }
        if (targetClass.findFieldByName(fieldName, false) == null) {
            if (fieldAnchor != null) {
                Boolean insertBefore = (Boolean)fieldAnchor.getSecond();
                PsiField inField = (PsiField)fieldAnchor.getFirst();
                if (insertBefore.booleanValue()) {
                    targetClass.addBefore((PsiElement)field, (PsiElement)inField);
                } else {
                    targetClass.addAfter((PsiElement)field, (PsiElement)inField);
                }
            } else {
                targetClass.add((PsiElement)field);
            }
        }
    }

    public static boolean isAvailable(@Nullable PsiParameter myParameter, @Nullable PsiType type, @Nullable PsiClass targetClass) {
        return myParameter != null && myParameter.isValid() && myParameter.getManager().isInProject((PsiElement)myParameter) && myParameter.getDeclarationScope() instanceof PsiMethod && ((PsiMethod)myParameter.getDeclarationScope()).getBody() != null && type != null && type.isValid() && targetClass != null && !targetClass.isInterface() && FieldFromParameterUtils.getParameterAssignedToField(myParameter) == null;
    }

    private FieldFromParameterUtils() {
    }
}

