/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.proc.VariablesProcessor;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacroUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.macro.MacroUtil");

    @Nullable
    public static PsiType resultToPsiType(Result result2, ExpressionContext context) {
        PsiDeclarationStatement decl;
        if (result2 instanceof PsiTypeResult) {
            return ((PsiTypeResult)result2).getType();
        }
        Project project2 = context.getProject();
        String text = result2.toString();
        if (text == null) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)project2);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
        PsiElement place = file2 != null ? file2.findElementAt(context.getStartOffset()) : null;
        PsiDeclarationStatement psiDeclarationStatement = decl = file2 != null ? (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)place, PsiDeclarationStatement.class) : null;
        if (decl != null) {
            place = file2.findElementAt(decl.getTextOffset() - 1);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        try {
            return factory.createTypeFromText(text, place);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public static PsiExpression resultToPsiExpression(Result result2, ExpressionContext context) {
        PsiElement parentOfParent;
        PsiElement parent;
        PsiElement place;
        PsiElement element;
        if (result2 instanceof PsiElementResult && (element = ((PsiElementResult)result2).getElement()) instanceof PsiExpression) {
            return (PsiExpression)element;
        }
        Project project2 = context.getProject();
        String text = result2.toString();
        if (text == null) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)project2);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
        PsiElement psiElement = place = file2 != null ? file2.findElementAt(context.getStartOffset()) : null;
        if (place != null && (parent = place.getParent()) != null && (parentOfParent = parent.getParent()) instanceof PsiDeclarationStatement) {
            place = file2.findElementAt(parentOfParent.getTextOffset() - 1);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        try {
            return factory.createExpressionFromText(text, place);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @NotNull
    private static PsiExpression[] getStandardExpressions(PsiElement place) {
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)place.getProject()).getElementFactory();
        try {
            array.add(factory.createExpressionFromText("true", null));
            array.add(factory.createExpressionFromText("false", null));
            boolean firstClass = true;
            boolean static_flag = false;
            for (PsiElement scope = place; scope != null; scope = scope.getParent()) {
                if (scope instanceof PsiModifierListOwner && ((PsiModifierListOwner)scope).getModifierList() != null && ((PsiModifierListOwner)scope).hasModifierProperty("static")) {
                    static_flag = true;
                }
                if (scope instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)scope;
                    String name = aClass.getName();
                    PsiExpression expr = null;
                    if (!static_flag) {
                        if (firstClass) {
                            expr = factory.createExpressionFromText("this", place);
                        } else if (name != null) {
                            expr = factory.createExpressionFromText(name + ".this", place);
                        }
                        if (expr != null) {
                            array.add(expr);
                        }
                    }
                    firstClass = false;
                    if (!aClass.hasModifierProperty("static")) continue;
                } else if (!(scope instanceof PsiMember) || !((PsiMember)scope).hasModifierProperty("static")) {
                    continue;
                }
                break;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        PsiExpression[] psiExpressionArray = array.toArray(new PsiExpression[array.size()]);
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/MacroUtil", "getStandardExpressions"));
        }
        return psiExpressionArray;
    }

    @NotNull
    public static PsiExpression[] getStandardExpressionsOfType(PsiElement place, PsiType type) {
        PsiExpression[] expressions;
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        for (PsiExpression expr : expressions = MacroUtil.getStandardExpressions(place)) {
            PsiType type1 = expr.getType();
            if (type != null && (type1 == null || !type.isAssignableFrom(type1))) continue;
            array.add(expr);
        }
        PsiExpression[] psiExpressionArray = array.toArray(new PsiExpression[array.size()]);
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/MacroUtil", "getStandardExpressionsOfType"));
        }
        return psiExpressionArray;
    }

    @NotNull
    public static PsiVariable[] getVariablesVisibleAt(final @Nullable PsiElement place, String prefix) {
        if (place == null) {
            PsiVariable[] psiVariableArray = new PsiVariable[]{};
            if (psiVariableArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/MacroUtil", "getVariablesVisibleAt"));
            }
            return psiVariableArray;
        }
        final HashSet usedNames = ContainerUtil.newHashSet();
        ArrayList list = new ArrayList();
        VariablesProcessor varproc = new VariablesProcessor(prefix, true, list){

            @Override
            public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
                if (pe == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pe", "com/intellij/codeInsight/template/macro/MacroUtil$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/template/macro/MacroUtil$1", "execute"));
                }
                if (pe instanceof PsiVariable) {
                    if (!usedNames.add(((PsiVariable)pe).getName())) {
                        return false;
                    }
                    PsiExpression initializer = ((PsiVariable)pe).getInitializer();
                    if (initializer != null && PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)place, (boolean)false)) {
                        return true;
                    }
                }
                return pe instanceof PsiField && !PsiUtil.isAccessible((PsiMember)((PsiField)pe), (PsiElement)place, null) || super.execute(pe, state);
            }
        };
        PsiScopesUtil.treeWalkUp(varproc, place, null);
        PsiVariable[] psiVariableArray = varproc.getResultsAsArray();
        if (psiVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/MacroUtil", "getVariablesVisibleAt"));
        }
        return psiVariableArray;
    }
}

