/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecationInspection
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "Deprecation";
    @NonNls
    public static final String ID = "deprecation";
    public static final String DISPLAY_NAME = DeprecationUtil.DEPRECATION_DISPLAY_NAME;
    public static final String IGNORE_METHODS_OF_DEPRECATED_NAME = "IGNORE_METHODS_OF_DEPRECATED";
    public boolean IGNORE_INSIDE_DEPRECATED = false;
    public boolean IGNORE_ABSTRACT_DEPRECATED_OVERRIDES = true;
    public boolean IGNORE_IMPORT_STATEMENTS = true;
    public boolean IGNORE_METHODS_OF_DEPRECATED = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/deprecation/DeprecationInspection", "buildVisitor"));
        }
        DeprecationElementVisitor deprecationElementVisitor = new DeprecationElementVisitor(holder, this.IGNORE_INSIDE_DEPRECATED, this.IGNORE_ABSTRACT_DEPRECATED_OVERRIDES, this.IGNORE_IMPORT_STATEMENTS, this.IGNORE_METHODS_OF_DEPRECATED);
        if (deprecationElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "buildVisitor"));
        }
        return deprecationElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getGroupDisplayName"));
        }
        return "";
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @NotNull
    @NonNls
    public String getID() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getID"));
        }
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Ignore inside deprecated members", "IGNORE_INSIDE_DEPRECATED");
        panel.addCheckbox("Ignore inside non-static imports", "IGNORE_IMPORT_STATEMENTS");
        panel.addCheckbox("<html>Ignore overrides of deprecated abstract methods from non-deprecated supers</html>", "IGNORE_ABSTRACT_DEPRECATED_OVERRIDES");
        panel.addCheckbox("Ignore members of deprecated classes", IGNORE_METHODS_OF_DEPRECATED_NAME);
        return panel;
    }

    private static boolean hasDefaultDeprecatedConstructor(PsiClass superClass) {
        if (superClass != null) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = superClass.getConstructors()) {
                if (constructor.getParameterList().getParametersCount() != 0 || !constructor.isDeprecated()) continue;
                return true;
            }
        }
        return false;
    }

    static void checkMethodOverridesDeprecated(MethodSignatureBackedByPsiMethod methodSignature, List<MethodSignatureBackedByPsiMethod> superMethodSignatures, boolean ignoreAbstractDeprecatedOverrides, ProblemsHolder holder) {
        PsiMethod method = methodSignature.getMethod();
        PsiIdentifier methodName = method.getNameIdentifier();
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiClass aClass = superMethod.getContainingClass();
            if (aClass == null || ignoreAbstractDeprecatedOverrides && !aClass.isDeprecated() && superMethod.hasModifierProperty("abstract") || !superMethod.isDeprecated()) continue;
            String description = JavaErrorMessages.message("overrides.deprecated.method", HighlightMessageUtil.getSymbolName((PsiElement)aClass, PsiSubstitutor.EMPTY));
            holder.registerProblem((PsiElement)methodName, description, ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
        }
    }

    public static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, @Nullable TextRange rangeInElement, ProblemsHolder holder) {
        DeprecationInspection.checkDeprecated(refElement, elementToHighlight, rangeInElement, false, false, true, holder);
    }

    public static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, @Nullable TextRange rangeInElement, boolean ignoreInsideDeprecated, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, ProblemsHolder holder) {
        if (!(refElement instanceof PsiDocCommentOwner)) {
            return;
        }
        if (!((PsiDocCommentOwner)refElement).isDeprecated()) {
            if (!ignoreMethodsOfDeprecated) {
                DeprecationInspection.checkDeprecated((PsiElement)((PsiDocCommentOwner)refElement).getContainingClass(), elementToHighlight, rangeInElement, ignoreInsideDeprecated, ignoreImportStatements, false, holder);
            }
            return;
        }
        if (ignoreInsideDeprecated) {
            PsiElement parent = elementToHighlight;
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDocCommentOwner.class, (boolean)true)) != null) {
                if (!((PsiDocCommentOwner)parent).isDeprecated()) continue;
                return;
            }
        }
        if (ignoreImportStatements && PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiImportStatementBase.class) != null) {
            return;
        }
        String description = JavaErrorMessages.message("deprecated.symbol", HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY));
        holder.registerProblem(elementToHighlight, description, ProblemHighlightType.LIKE_DEPRECATED, rangeInElement, new LocalQuickFix[0]);
    }

    private static class DeprecationElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIgnoreInsideDeprecated;
        private final boolean myIgnoreAbstractDeprecatedOverrides;
        private final boolean myIgnoreImportStatements;
        private final boolean myIgnoreMethodsOfDeprecated;

        public DeprecationElementVisitor(ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated) {
            this.myHolder = holder;
            this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
            this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
            this.myIgnoreImportStatements = ignoreImportStatements;
            this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            JavaResolveResult result2 = reference.advancedResolve(true);
            PsiElement resolved = result2.getElement();
            DeprecationInspection.checkDeprecated(resolved, reference.getReferenceNameElement(), null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myHolder);
        }

        public void visitImportStaticStatement(PsiImportStaticStatement statement2) {
            PsiJavaCodeReferenceElement importReference = statement2.getImportReference();
            if (importReference != null) {
                DeprecationInspection.checkDeprecated(importReference.resolve(), importReference.getReferenceNameElement(), null, this.myIgnoreInsideDeprecated, false, true, this.myHolder);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            PsiType type = expression.getType();
            PsiExpressionList list = expression.getArgumentList();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = typeResult.getElement();
            if (aClass == null) {
                return;
            }
            if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0 && list != null) {
                PsiMethod constructor;
                JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type, list, (PsiElement)list);
                MethodCandidateInfo result2 = null;
                if (results.length == 1) {
                    result2 = (MethodCandidateInfo)results[0];
                }
                PsiMethod psiMethod = constructor = result2 == null ? null : result2.getElement();
                if (constructor != null && expression.getClassOrAnonymousClassReference() != null) {
                    if (expression.getClassReference() == null && constructor.getParameterList().getParametersCount() == 0) {
                        return;
                    }
                    DeprecationInspection.checkDeprecated((PsiElement)constructor, (PsiElement)expression.getClassOrAnonymousClassReference(), null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, true, this.myHolder);
                }
            }
        }

        public void visitMethod(PsiMethod method) {
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (!method.isConstructor()) {
                List superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
                DeprecationInspection.checkMethodOverridesDeprecated(methodSignature, superMethodSignatures, this.myIgnoreAbstractDeprecatedOverrides, this.myHolder);
            } else {
                this.checkImplicitCallToSuper(method);
            }
        }

        private void checkImplicitCallToSuper(PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            assert (containingClass != null);
            PsiClass superClass = containingClass.getSuperClass();
            if (DeprecationInspection.hasDefaultDeprecatedConstructor(superClass)) {
                PsiStatement[] statements;
                PsiExpressionList argumentList;
                if (superClass instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)superClass).getArgumentList()) != null && argumentList.getExpressions().length > 0) {
                    return;
                }
                PsiCodeBlock body = method.getBody();
                if (!(body == null || (statements = body.getStatements()).length != 0 && JavaHighlightUtil.isSuperOrThisCall(statements[0], true, true))) {
                    this.registerDefaultConstructorProblem(superClass, (PsiElement)method.getNameIdentifier(), false);
                }
            }
        }

        private void registerDefaultConstructorProblem(PsiClass superClass, PsiElement nameIdentifier, boolean asDeprecated) {
            this.myHolder.registerProblem(nameIdentifier, "Default constructor in " + superClass.getQualifiedName() + " is deprecated", asDeprecated ? ProblemHighlightType.LIKE_DEPRECATED : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }

        public void visitClass(PsiClass aClass) {
            PsiClass superClass;
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] currentConstructors = aClass.getConstructors();
            if (currentConstructors.length == 0 && DeprecationInspection.hasDefaultDeprecatedConstructor(superClass = aClass.getSuperClass())) {
                PsiExpressionList argumentList;
                boolean isAnonymous = aClass instanceof PsiAnonymousClass;
                if (isAnonymous && (argumentList = ((PsiAnonymousClass)aClass).getArgumentList()) != null && argumentList.getExpressions().length > 0) {
                    return;
                }
                this.registerDefaultConstructorProblem(superClass, (PsiElement)(isAnonymous ? ((PsiAnonymousClass)aClass).getBaseClassReference() : aClass.getNameIdentifier()), isAnonymous);
            }
        }
    }
}

