/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseConvertToLocalQuickFix<V extends PsiVariable>
implements LocalQuickFix {
    protected static final Logger LOG = Logger.getInstance(BaseConvertToLocalQuickFix.class);

    @NotNull
    public final String getName() {
        String string = InspectionsBundle.message((String)"inspection.convert.to.local.quickfix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "getName"));
        }
        return string;
    }

    public final void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "applyFix"));
        }
        V variable = this.getVariable(descriptor);
        if (variable == null || !variable.isValid()) {
            return;
        }
        PsiFile myFile = variable.getContainingFile();
        try {
            PsiElement newDeclaration = this.moveDeclaration(project2, variable);
            if (newDeclaration == null) {
                return;
            }
            BaseConvertToLocalQuickFix.positionCaretToDeclaration(project2, myFile, newDeclaration);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    protected abstract V getVariable(@NotNull ProblemDescriptor var1);

    protected static void positionCaretToDeclaration(@NotNull Project project2, @NotNull PsiFile psiFile, @NotNull PsiElement declaration) {
        PsiFile openedFile;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "positionCaretToDeclaration"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "positionCaretToDeclaration"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "positionCaretToDeclaration"));
        }
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor != null && (IJSwingUtilities.hasFocus(editor.getComponent()) || ApplicationManager.getApplication().isUnitTestMode()) && (openedFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) == psiFile) {
            editor.getCaretModel().moveToOffset(declaration.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    protected void beforeDelete(@NotNull Project project2, @NotNull V variable, @NotNull PsiElement newDeclaration) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "beforeDelete"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "beforeDelete"));
        }
        if (newDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDeclaration", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "beforeDelete"));
        }
    }

    @Nullable
    protected PsiElement moveDeclaration(@NotNull Project project2, @NotNull V variable) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "moveDeclaration"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "moveDeclaration"));
        }
        Collection references = ReferencesSearch.search(variable).findAll();
        if (references.isEmpty()) {
            return null;
        }
        return this.moveDeclaration(project2, variable, references, true);
    }

    protected PsiElement moveDeclaration(Project project2, V variable, final Collection<PsiReference> references, boolean delete) {
        final PsiCodeBlock anchorBlock = BaseConvertToLocalQuickFix.findAnchorBlock(references);
        if (anchorBlock == null) {
            return null;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{anchorBlock})) {
            return null;
        }
        final PsiElement firstElement = BaseConvertToLocalQuickFix.getLowestOffsetElement(references);
        String localName = this.suggestLocalName(project2, variable, anchorBlock);
        final PsiElement anchor = BaseConvertToLocalQuickFix.getAnchorElement(anchorBlock, firstElement);
        PsiAssignmentExpression anchorAssignmentExpression = BaseConvertToLocalQuickFix.searchAssignmentExpression(anchor);
        if (anchorAssignmentExpression != null && BaseConvertToLocalQuickFix.isVariableAssignment(anchorAssignmentExpression, variable)) {
            HashSet refsSet = new HashSet(references);
            refsSet.remove(anchorAssignmentExpression.getLExpression());
            return this.applyChanges(project2, localName, anchorAssignmentExpression.getRExpression(), variable, (Collection<PsiReference>)refsSet, delete, new NotNullFunction<PsiDeclarationStatement, PsiElement>(){

                @NotNull
                public PsiElement fun(PsiDeclarationStatement declaration) {
                    if (!BaseConvertToLocalQuickFix.mayBeFinal(firstElement, references)) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiModifierListOwner)declaration.getDeclaredElements()[0]), (String)"final", (boolean)false);
                    }
                    PsiElement psiElement = anchor.replace((PsiElement)declaration);
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix$1", "fun"));
                    }
                    return psiElement;
                }
            });
        }
        return this.applyChanges(project2, localName, variable.getInitializer(), variable, references, delete, new NotNullFunction<PsiDeclarationStatement, PsiElement>(){

            @NotNull
            public PsiElement fun(PsiDeclarationStatement declaration) {
                PsiElement psiElement = anchorBlock.addBefore((PsiElement)declaration, anchor);
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix$2", "fun"));
                }
                return psiElement;
            }
        });
    }

    protected PsiElement applyChanges(final @NotNull Project project2, final @NotNull String localName, final @Nullable PsiExpression initializer, final @NotNull V variable, final @NotNull Collection<PsiReference> references, final boolean delete, final @NotNull NotNullFunction<PsiDeclarationStatement, PsiElement> action) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "applyChanges"));
        }
        if (localName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "applyChanges"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "applyChanges"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "applyChanges"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "applyChanges"));
        }
        final PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        return (PsiElement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                PsiElement newDeclaration = BaseConvertToLocalQuickFix.this.moveDeclaration(elementFactory, localName, variable, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
                if (delete) {
                    BaseConvertToLocalQuickFix.this.beforeDelete(project2, variable, newDeclaration);
                    variable.normalizeDeclaration();
                    variable.delete();
                }
                return newDeclaration;
            }
        });
    }

    protected PsiElement moveDeclaration(PsiElementFactory elementFactory, String localName, V variable, PsiExpression initializer, NotNullFunction<PsiDeclarationStatement, PsiElement> action, Collection<PsiReference> references) {
        PsiDeclarationStatement declaration = elementFactory.createVariableDeclarationStatement(localName, variable.getType(), initializer);
        PsiElement newDeclaration = (PsiElement)action.fun((Object)declaration);
        BaseConvertToLocalQuickFix.retargetReferences(elementFactory, localName, references);
        return newDeclaration;
    }

    @Nullable
    private static PsiAssignmentExpression searchAssignmentExpression(@Nullable PsiElement anchor) {
        if (!(anchor instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression anchorExpression = ((PsiExpressionStatement)anchor).getExpression();
        if (!(anchorExpression instanceof PsiAssignmentExpression)) {
            return null;
        }
        return (PsiAssignmentExpression)anchorExpression;
    }

    private static boolean isVariableAssignment(@NotNull PsiAssignmentExpression expression, @NotNull PsiVariable variable) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "isVariableAssignment"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "isVariableAssignment"));
        }
        if (expression.getOperationTokenType() != JavaTokenType.EQ) {
            return false;
        }
        if (!(expression.getLExpression() instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression leftExpression = (PsiReferenceExpression)expression.getLExpression();
        return leftExpression.isReferenceTo((PsiElement)variable);
    }

    @NotNull
    protected abstract String suggestLocalName(@NotNull Project var1, @NotNull V var2, @NotNull PsiCodeBlock var3);

    private static boolean mayBeFinal(PsiElement firstElement, @NotNull Collection<PsiReference> references) {
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "mayBeFinal"));
        }
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (element == firstElement || !(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) continue;
            return false;
        }
        return true;
    }

    private static void retargetReferences(PsiElementFactory elementFactory, String localName, Collection<PsiReference> refs) throws IncorrectOperationException {
        PsiReferenceExpression refExpr = (PsiReferenceExpression)elementFactory.createExpressionFromText(localName, null);
        for (PsiReference ref : refs) {
            if (!(ref instanceof PsiReferenceExpression)) continue;
            ((PsiReferenceExpression)ref).replace((PsiElement)refExpr);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock anchorBlock, @NotNull PsiElement firstElement) {
        PsiElement element;
        if (firstElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstElement", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "getAnchorElement"));
        }
        for (element = firstElement; element != null && element.getParent() != anchorBlock; element = element.getParent()) {
        }
        return element;
    }

    @Nullable
    private static PsiElement getLowestOffsetElement(@NotNull Collection<PsiReference> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix", "getLowestOffsetElement"));
        }
        PsiElement firstElement = null;
        for (PsiReference reference : refs) {
            PsiElement element = reference.getElement();
            if (firstElement != null && firstElement.getTextRange().getStartOffset() <= element.getTextRange().getStartOffset()) continue;
            firstElement = element;
        }
        return firstElement;
    }

    private static PsiCodeBlock findAnchorBlock(Collection<PsiReference> refs) {
        PsiCodeBlock result2 = null;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
            if (result2 == null || block == null) {
                result2 = block;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)result2, (PsiElement)block);
            result2 = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class, (boolean)false);
        }
        return result2;
    }
}

