/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.codeInspection.varScopeCanBeNarrowed.BaseConvertToLocalQuickFix;
import com.intellij.codeInspection.varScopeCanBeNarrowed.FieldCanBeLocalInspectionBase;
import com.intellij.lang.java.JavaCommenter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldCanBeLocalInspection
extends FieldCanBeLocalInspectionBase {
    @Override
    protected LocalQuickFix createFix() {
        return new ConvertFieldToLocalQuickFix();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel listPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)this.EXCLUDE_ANNOS, InspectionsBundle.message((String)"special.annotations.annotations.list", (Object[])new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)new SingleCheckboxOptionsPanel("Ignore fields used in multiple methods", (InspectionProfileEntry)this, "IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS"), "North");
        panel.add((Component)listPanel, "Center");
        return panel;
    }

    private static class ConvertFieldToLocalQuickFix
    extends BaseConvertToLocalQuickFix<PsiField> {
        private ConvertFieldToLocalQuickFix() {
        }

        @Override
        @Nullable
        protected PsiElement moveDeclaration(final @NotNull Project project2, final @NotNull PsiField variable) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "moveDeclaration"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "moveDeclaration"));
            }
            HashMap<PsiCodeBlock, Collection<PsiReference>> refs = new HashMap<PsiCodeBlock, Collection<PsiReference>>();
            if (!ConvertFieldToLocalQuickFix.groupByCodeBlocks(ReferencesSearch.search((PsiElement)variable).findAll(), refs)) {
                return null;
            }
            PsiElement element = null;
            for (Collection psiReferences : refs.values()) {
                element = super.moveDeclaration(project2, variable, psiReferences, false);
            }
            if (element != null) {
                final PsiElement finalElement = element;
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        ConvertFieldToLocalQuickFix.this.beforeDelete(project2, variable, finalElement);
                        variable.normalizeDeclaration();
                        variable.delete();
                    }
                };
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }
            return element;
        }

        private static boolean groupByCodeBlocks(Collection<PsiReference> allReferences, Map<PsiCodeBlock, Collection<PsiReference>> refs) {
            for (PsiReference psiReference : allReferences) {
                PsiElement element = psiReference.getElement();
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiCodeBlock.class);
                if (block == null) {
                    return false;
                }
                Collection<PsiReference> references = refs.get(block);
                if (references == null) {
                    references = new ArrayList<PsiReference>();
                    if (ConvertFieldToLocalQuickFix.findExistentBlock(refs, psiReference, block, references)) continue;
                    refs.put(block, references);
                }
                references.add(psiReference);
            }
            return true;
        }

        private static boolean findExistentBlock(Map<PsiCodeBlock, Collection<PsiReference>> refs, PsiReference psiReference, PsiCodeBlock block, Collection<PsiReference> references) {
            Iterator<PsiCodeBlock> iterator = refs.keySet().iterator();
            while (iterator.hasNext()) {
                PsiCodeBlock codeBlock = iterator.next();
                if (PsiTreeUtil.isAncestor((PsiElement)codeBlock, (PsiElement)block, (boolean)false)) {
                    refs.get(codeBlock).add(psiReference);
                    return true;
                }
                if (!PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)codeBlock, (boolean)false)) continue;
                references.addAll(refs.get(codeBlock));
                iterator.remove();
                break;
            }
            return false;
        }

        @Override
        @Nullable
        protected PsiField getVariable(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "getVariable"));
            }
            return (PsiField)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiField.class);
        }

        @Override
        protected void beforeDelete(@NotNull Project project2, @NotNull PsiField variable, @NotNull PsiElement newDeclaration) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "beforeDelete"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "beforeDelete"));
            }
            if (newDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDeclaration", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "beforeDelete"));
            }
            PsiDocComment docComment = variable.getDocComment();
            if (docComment != null) {
                ConvertFieldToLocalQuickFix.moveDocCommentToDeclaration(project2, docComment, newDeclaration);
            }
        }

        @Override
        @NotNull
        protected String suggestLocalName(@NotNull Project project2, @NotNull PsiField field, @NotNull PsiCodeBlock scope) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "suggestLocalName"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "suggestLocalName"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "suggestLocalName"));
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            String propertyName = styleManager.variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            String localName = styleManager.propertyNameToVariableName(propertyName, VariableKind.LOCAL_VARIABLE);
            String string = RefactoringUtil.suggestUniqueVariableName(localName, (PsiElement)scope, field);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "suggestLocalName"));
            }
            return string;
        }

        private static void moveDocCommentToDeclaration(@NotNull Project project2, @NotNull PsiDocComment docComment, @NotNull PsiElement declaration) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "moveDocCommentToDeclaration"));
            }
            if (docComment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "moveDocCommentToDeclaration"));
            }
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$ConvertFieldToLocalQuickFix", "moveDocCommentToDeclaration"));
            }
            StringBuilder buf = new StringBuilder();
            for (PsiElement psiElement : docComment.getDescriptionElements()) {
                buf.append(psiElement.getText());
            }
            if (buf.length() > 0) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                JavaCommenter commenter = new JavaCommenter();
                PsiComment comment = elementFactory.createCommentFromText(commenter.getBlockCommentPrefix() + buf.toString() + commenter.getBlockCommentSuffix(), declaration);
                declaration.getParent().addBefore((PsiElement)comment, declaration);
            }
        }
    }
}

