/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import kotlin.CharIterator;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"S\u0015\u0001Q!\u0001\u0005\n\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!5Q!\u0001C\u0003\u000b\u0005AY!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u000e&\u0011\t\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!\u0007\u0003\t\n5\u0011A\u0012\u0001\r\u0006)\u000e\tQ\u0012\u0004E\u0002\u001b\u0005A\"!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003U\u0007\u0005iY\u0002c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ar!\u0007\u0003\t\u00105\u0011A\u0012\u0001\r\u0007)\u000e\tQ2\u0007\u0003\u0002\u0011!i\u0011\u0001\u0007\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rA)!D\u0001\u0019\u000be\u0019\u0001\u0012C\u0007\u00021\u0011I2\u0001C\u0005\u000e\u0003a1\u0011d\u0001E\n\u001b\u0005A\"\u0002V\u0002\u0002\u001bW!\u0011\u0001#\u0006\u000e\u0003aQ\u0011d\u0001\u0005\f\u001b\u0005AR!G\u0002\t\u00135\t\u0001DB\r\u0004\u0011#i\u0011\u0001g\u0006\u001a\u0007!MQ\"\u0001\r\u000b)\u000e\tQ\u0012\u0003\u0005\r\u001b\u0005A\"\"G\u0002\t\u001a5\t\u0001$\u0004+\u0004\u00035u\u00022D\u0007\u00021\u0015IB\u0001#\u0002\u000e\u00051\u0005\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\t!%QB\u0001G\u00011\u0015I2\u0001\u0003\b\u000e\u0003au\u0011d\u0001\u0005\n\u001b\u0005Ab!G\u0002\t\u00145\t\u0001D\u0003+\u0004\u00035i\u0001bD\u0007\u00021/)\u0012\u0001g\b\u001a\f\u0011\t\u0001\"C\u0007\u000215\u00016\u0011\u0001+\u0004\u0003EEA!\u0011\u0005\t\u00015\t\u0001\u0014A)\u0004\u0003\u0015\u0001AkA\u0001"}, strings={"XML_PROLOG", "", "FileBasedStorageKt", "deleteFile", "", "file", "Ljava/io/File;", "requestor", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "detectLineSeparators", "Lcom/intellij/util/LineSeparator;", "chars", "", "defaultSeparator", "doWrite", "content", "lineSeparator", "prependXmlProlog", "", "isEqualContent", "result", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "isProjectOrModuleFile", "fileSpec", "", "writeFile", "element", "Lorg/jdom/Element;", "toBufferExposingByteArray", "Lorg/jdom/Parent;"}, moduleName="configuration-store-impl")
public final class FileBasedStorageKt {
    private static final byte[] XML_PROLOG = StringsKt.toByteArray$default((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", null, (int)1);

    @NotNull
    public static final VirtualFile writeFile(@Nullable File file2, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull Element element, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if (!(file2 == null || virtualFile != null && virtualFile.isValid())) {
            virtualFile2 = StorageUtil.getOrCreateVirtualFile(requestor, file2);
        } else {
            virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
        }
        VirtualFile result2 = virtualFile2;
        if (ComponentStoreImplKt.getLOG().isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            Parent parent = (Parent)element;
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
            BufferExposingByteArrayOutputStream content = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
            VirtualFile virtualFile3 = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"result");
            if (FileBasedStorageKt.isEqualContent(virtualFile3, lineSeparator, content, prependXmlProlog)) {
                throw (Throwable)new IllegalStateException("Content equals, but it must be handled not on this level: " + result2.getName());
            }
            if (StorageUtil.DEBUG_LOG != null && ApplicationManager.getApplication().isUnitTestMode()) {
                StorageUtil.DEBUG_LOG = result2.getPath() + ":" + "\n" + content + "\n" + "Old Content:" + "\n" + LoadTextUtil.loadText(result2) + "\n" + "---------";
            }
        }
        VirtualFile virtualFile4 = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"result");
        FileBasedStorageKt.doWrite(requestor, virtualFile4, element, lineSeparator, prependXmlProlog);
        VirtualFile virtualFile5 = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"result");
        return virtualFile5;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isEqualContent(VirtualFile result2, LineSeparator lineSeparator, BufferExposingByteArrayOutputStream content, boolean prependXmlProlog) {
        int headerLength;
        int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
        if ((int)result2.getLength() != headerLength + content.size()) {
            return false;
        }
        byte[] oldContent = result2.contentsToByteArray();
        if (!(!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes()))) {
            return false;
        }
        int n2 = headerLength;
        int n3 = oldContent.length - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (oldContent[i] != content.getInternalBuffer()[i - headerLength]) {
                    return false;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void doWrite(Object requestor, VirtualFile file2, Object content, LineSeparator lineSeparator, boolean prependXmlProlog) {
        void $receiver$iv;
        Logger logger = ComponentStoreImplKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            void var11_6 = $receiver$iv;
            String string = "Save " + file2.getPresentableUrl();
            var11_6.debug(string);
        }
        AccessToken token$iv = WriteAction.start();
        try {
            try {
                OutputStream out = file2.getOutputStream(requestor);
                try {
                    if (prependXmlProlog) {
                        out.write(XML_PROLOG);
                        out.write(lineSeparator.getSeparatorBytes());
                    }
                    if (content instanceof Element) {
                        JDOMUtil.writeParent((Parent)((Parent)content), (OutputStream)out, (String)lineSeparator.getSeparatorString());
                    } else {
                        Object object = content;
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                        }
                        ((BufferExposingByteArrayOutputStream)object).writeTo(out);
                    }
                }
                finally {
                    out.close();
                }
            }
            catch (FileNotFoundException e) {
                BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
                if (content instanceof Element) {
                    Parent parent = (Parent)content;
                    String string = lineSeparator.getSeparatorString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
                    bufferExposingByteArrayOutputStream = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
                } else {
                    Object object = content;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                    }
                    bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)object;
                }
                BufferExposingByteArrayOutputStream byteArray = bufferExposingByteArrayOutputStream;
                throw (Throwable)new ReadOnlyModificationException(file2, e, new StateStorage.SaveSession(byteArray, file2, requestor, prependXmlProlog, lineSeparator, content){
                    final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
                    final /* synthetic */ VirtualFile $file$inlined;
                    final /* synthetic */ Object $requestor$inlined;
                    final /* synthetic */ boolean $prependXmlProlog$inlined;
                    final /* synthetic */ LineSeparator $lineSeparator$inlined;
                    final /* synthetic */ Object $content$inlined;

                    public final void save() {
                        FileBasedStorageKt.access$doWrite(this.$requestor$inlined, this.$file$inlined, this.$byteArray, this.$lineSeparator$inlined, this.$prependXmlProlog$inlined);
                    }
                    {
                        this.$byteArray = bufferExposingByteArrayOutputStream;
                        this.$file$inlined = virtualFile;
                        this.$requestor$inlined = object;
                        this.$prependXmlProlog$inlined = bl;
                        this.$lineSeparator$inlined = lineSeparator;
                        this.$content$inlined = object2;
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            token$iv.finish();
        }
    }

    @NotNull
    public static final BufferExposingByteArrayOutputStream toBufferExposingByteArray(Parent $receiver, @NotNull String lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)$receiver, (OutputStream)((OutputStream)out), (String)lineSeparator);
        return out;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferExposingByteArrayOutputStream toBufferExposingByteArray$default(Parent parent, String string, int n) {
        if ((n & 1) != 0) {
            string = "\n";
        }
        return FileBasedStorageKt.toBufferExposingByteArray(parent, string);
    }

    public static final boolean isProjectOrModuleFile(@NotNull String fileSpec) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        return Intrinsics.areEqual((Object)"$PROJECT_FILE$", (Object)fileSpec) || StringsKt.startsWith$default((String)fileSpec, (String)"$PROJECT_CONFIG_DIR$", (boolean)false, (int)2) || Intrinsics.areEqual((Object)fileSpec, (Object)"$MODULE_FILE$");
    }

    @NotNull
    public static final LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        CharIterator charIterator = StringsKt.iterator((CharSequence)chars);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == '\r') {
                return LineSeparator.CRLF;
            }
            if (c != '\n') continue;
            return LineSeparator.LF;
        }
        LineSeparator lineSeparator = defaultSeparator;
        if (lineSeparator == null) {
            LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
            lineSeparator = lineSeparator2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
        }
        return lineSeparator;
    }

    private static final void deleteFile(File file2, Object requestor, VirtualFile virtualFile) {
        if (virtualFile == null) {
            ComponentStoreImplKt.getLOG().warn("Cannot find virtual file " + file2.getAbsolutePath());
        }
        if (virtualFile == null) {
            if (file2.exists()) {
                FileUtil.delete((File)file2);
            }
        } else if (virtualFile.exists()) {
            try {
                FileBasedStorageKt.deleteFile(requestor, virtualFile);
            }
            catch (FileNotFoundException e) {
                throw (Throwable)new ReadOnlyModificationException(virtualFile, e, new StateStorage.SaveSession(requestor, virtualFile){
                    final /* synthetic */ Object $requestor;
                    final /* synthetic */ VirtualFile $virtualFile;

                    public final void save() {
                        FileBasedStorageKt.deleteFile(this.$requestor, this.$virtualFile);
                    }
                    {
                        this.$requestor = object;
                        this.$virtualFile = virtualFile;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        AccessToken token$iv = WriteAction.start();
        try {
            virtualFile.delete(requestor);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            token$iv.finish();
        }
    }

    public static final /* synthetic */ void access$deleteFile(@NotNull File file2, @NotNull Object requestor, @Nullable VirtualFile virtualFile) {
        FileBasedStorageKt.deleteFile(file2, requestor, virtualFile);
    }

    public static final /* synthetic */ void access$doWrite(@NotNull Object requestor, @NotNull VirtualFile file2, @NotNull Object content, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        FileBasedStorageKt.doWrite(requestor, file2, content, lineSeparator, prependXmlProlog);
    }
}

