/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.ModuleStateStorageManager;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0011IA\u0002A\r\u00021\u0003i\nQCQ\u000b\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004K\u0011!!\u0001\u0003\u0005\u000e\u0003a\u0015Q\u0005\u0003\u0003\f\u0011#i\u0011\u0001G\u0005\u001a\u0007!MQ\"\u0001\r\u000bS\u001d!\u0011\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0002\u000b\u0001IK\u0002\u0002&\t\u0011\u000fi9\u0001\u0007\u0003R\u0007\u0005!I!U\u0002\u0005\u000b\u0001i!\u0001B\u0003\t\f%RAa\u0013\u0005\t\r5\t\u0001TB)\u0004\t\u0015\u0001QB\u0001\u0003\b\u0011\u001f\u0001"}, strings={"Lcom/intellij/configurationStore/ModuleStoreImpl;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "module", "Lcom/intellij/openapi/module/Module;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/components/PathMacroManager;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/ModuleStateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ModuleStateStorageManager;", "getPathMacroManagerForDefaults", "setPath", "", "path", "", "TestModuleStore"}, moduleName="configuration-store-impl")
public class ModuleStoreImpl
extends ComponentStoreImpl {
    @NotNull
    private final Project project;
    @NotNull
    private final ModuleStateStorageManager storageManager;
    private final PathMacroManager pathMacroManager;

    @Override
    @NotNull
    protected Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public ModuleStateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!this.getStorageManager().addMacro("$MODULE_FILE$", path)) {
            Unit unit;
            FileBasedStorage fileBasedStorage = (FileBasedStorage)CollectionsKt.firstOrNull((Iterable)this.getStorageManager().getCachedFileStorages(CollectionsKt.listOf((Object)"$MODULE_FILE$")));
            if (fileBasedStorage != null) {
                fileBasedStorage.setFile(null, new File(path));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    public ModuleStoreImpl(@NotNull Module module2, @NotNull PathMacroManager pathMacroManager) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
        this.pathMacroManager = pathMacroManager;
        this.project = module2.getProject();
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.pathMacroManager.createTrackingSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)trackingPathMacroSubstitutor, (String)"pathMacroManager.createTrackingSubstitutor()");
        this.storageManager = new ModuleStateStorageManager(trackingPathMacroSubstitutor, module2);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\u000f\u0011\tA\u0002A\r\u00021\u0003\t+\"C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002R\u0007\u0005A1!\n\u0005\u0005\u0017!1Q\"\u0001M\u00073\rAq!D\u0001\u0019\u0010%RAa\u0013\u0005\t\b5\t\u0001\u0004\u0002\u000f,#\u000e\u0019QB\u0001C\u0005\u0011\u0015I\u0003\u0002B!\u001d\u0011\u0017i!\u0001$\u0001\u0019\tE\u001b\u0011!\u0002\u0001"}, strings={"Lcom/intellij/configurationStore/ModuleStoreImpl$TestModuleStore;", "Lcom/intellij/configurationStore/ModuleStoreImpl;", "module", "Lcom/intellij/openapi/module/Module;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/components/PathMacroManager;)V", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "moduleComponentLoadPolicy", "setPath", "", "path", ""}, moduleName="configuration-store-impl")
    private static final class TestModuleStore
    extends ModuleStoreImpl {
        private StateLoadPolicy moduleComponentLoadPolicy;

        @Override
        public void setPath(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            super.setPath(path);
            if (new File(path).exists()) {
                this.moduleComponentLoadPolicy = StateLoadPolicy.LOAD;
            }
        }

        @Override
        @NotNull
        public StateLoadPolicy getLoadPolicy() {
            StateLoadPolicy stateLoadPolicy = this.moduleComponentLoadPolicy;
            if (stateLoadPolicy == null) {
                IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)this.getProject());
                if (iComponentStore == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
                }
                stateLoadPolicy = ((ComponentStoreImpl)iComponentStore).getLoadPolicy();
            }
            return stateLoadPolicy;
        }

        public TestModuleStore(@NotNull Module module2, @NotNull PathMacroManager pathMacroManager) {
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
            super(module2, pathMacroManager);
        }
    }
}

