/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"M\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\u000f\u0015\tAAA\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0004\tMa\u0001!G\u0001\u0019\u0002e\t\u0001$AQ\u0007\u0013\rA\u0019!D\u0001\u0019\u0005E\u001b\u0011\u0001#\u0002&\u0007!aQ\"\u0001M\rK\rAQ\"D\u0001\u0019\u001c\u0015\"Aa\u0003\u0005\u000f\u001b\u0005AZ\"J\u0002\t\u001e5\t\u0001tB\u0013\u0004\u0011=i\u0011\u0001g\u0007&\u0007!}Q\"\u0001\r\u0011K\u001dA\t#D\u0001\u0019\u001ae\u0019\u0001\"E\u0007\u00021G)s\u0001\u0003\n\u000e\u0003ae\u0011d\u0001E\u0013\u001b\u0005A\u0002#\n\t\u0005\u0005!\u0019R\"\u0001M\r3\rA9#D\u0001\u0019\u001ce\u0019\u0001\u0002F\u0007\u00021AI2\u0001#\u000b\u000e\u0003a\u0001\u0012&\u0004\u0003D9!\u0019Q\"\u0001M\u0004#\u000e9Q\u0001A\u0007\u0003\t\u0011AI!\u0005\u0002\u0005\u000b!-\u0011F\u0003\u0003C\u0011!\rQ\"\u0001\r\u0003#\u000e!Q\u0001A\u0007\u0003\t\u0019Ai!K\u0007\u0005\u0007rAq!D\u0001\u0019\u0010E\u001bq!\u0002\u0001\u000e\u0005\u0011A\u0001\u0012C\t\u0003\t%A\u0019\"K\u0005\u0005'\"A!\"D\u0001\u0019\u0016E\u001b1!\u0004\u0002\u0005\u0017!]\u0001"}, strings={"Lcom/intellij/configurationStore/ProjectStoreBase;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;)V", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "getProject", "()Lcom/intellij/openapi/project/impl/ProjectImpl;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "getScheme", "()Lcom/intellij/openapi/components/StorageScheme;", "setScheme", "(Lcom/intellij/openapi/components/StorageScheme;)V", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "clearStorages", "", "getProjectBasePath", "", "getProjectFilePath", "getStorageScheme", "getWorkspaceFilePath", "isOptimiseTestLoadSpeed", "", "loadProjectFromTemplate", "defaultProject", "Lcom/intellij/openapi/project/Project;", "setOptimiseTestLoadSpeed", "value", "setPath", "filePath", "refreshVfs", "useOldWorkspaceContentIfExists"}, moduleName="configuration-store-impl")
public abstract class ProjectStoreBase
extends ComponentStoreImpl
implements IProjectStore {
    @NotNull
    private StorageScheme scheme;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final ProjectImpl project;

    @NotNull
    public final StorageScheme getScheme() {
        return this.scheme;
    }

    public final void setScheme(@NotNull StorageScheme storageScheme) {
        Intrinsics.checkParameterIsNotNull((Object)storageScheme, (String)"<set-?>");
        this.scheme = storageScheme;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    @Override
    public final boolean isOptimiseTestLoadSpeed() {
        return Intrinsics.areEqual((Object)((Object)this.loadPolicy), (Object)((Object)StateLoadPolicy.LOAD)) ^ true;
    }

    @Override
    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.scheme;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    @Override
    public final void setOptimiseTestLoadSpeed(boolean value) {
        this.loadPolicy = value ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.getStorageManager().expandMacro("$PROJECT_FILE$");
    }

    @Override
    @NotNull
    public final String getWorkspaceFilePath() {
        return this.getStorageManager().expandMacro("$WORKSPACE_FILE$");
    }

    @Override
    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    @Override
    public final void loadProjectFromTemplate(@NotNull Project defaultProject) {
        Intrinsics.checkParameterIsNotNull((Object)defaultProject, (String)"defaultProject");
        defaultProject.save();
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)defaultProject);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        Element element = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element != null) {
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this.getStorageManager(), "$PROJECT_FILE$", null, null, null, 14);
            if (stateStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.XmlElementStorage");
            }
            ((XmlElementStorage)stateStorage).setDefaultState(element);
        }
    }

    @Override
    @NotNull
    public final String getProjectBasePath() {
        String path = PathUtilRt.getParentPath((String)this.getProjectFilePath());
        return Intrinsics.areEqual((Object)this.scheme, (Object)StorageScheme.DEFAULT) ? path : PathUtilRt.getParentPath((String)path);
    }

    protected final void setPath(@NotNull String filePath, boolean refreshVfs, boolean useOldWorkspaceContentIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (FileUtilRt.extensionEquals((String)filePath, (String)"ipr")) {
            this.scheme = StorageScheme.DEFAULT;
            storageManager2.addMacro("$PROJECT_FILE$", filePath);
            String workspacePath = ProjectStoreImplKt.access$composeWsPath(filePath);
            storageManager2.addMacro("$WORKSPACE_FILE$", workspacePath);
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<Unit>)((Function0)new Function0<Unit>(fs, filePath, workspacePath){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $filePath;
                    final /* synthetic */ String $workspacePath;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$filePath), this.$fs.refreshAndFindFileByPath(this.$workspacePath)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$filePath = string;
                        this.$workspacePath = string2;
                        super(0);
                    }
                }));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!new File(filePath).exists());
            }
        } else {
            File workspace;
            String string;
            this.scheme = StorageScheme.DIRECTORY_BASED;
            File file2 = new File(filePath);
            boolean isDir = !useOldWorkspaceContentIfExists || file2.isDirectory();
            StringBuilder stringBuilder = new StringBuilder();
            if (isDir) {
                string = filePath;
            } else {
                String string2 = PathUtilRt.getParentPath((String)filePath);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getParentPath(filePath)");
            }
            String configDir = stringBuilder.append(string).append("/").append(".idea").toString();
            storageManager2.addMacro("$PROJECT_CONFIG_DIR$", configDir);
            storageManager2.addMacro("$PROJECT_FILE$", configDir + "/misc.xml");
            storageManager2.addMacro("$WORKSPACE_FILE$", configDir + "/workspace.xml");
            if (!isDir && !(workspace = new File(this.getWorkspaceFilePath())).exists()) {
                ProjectStoreImplKt.access$useOldWorkspaceContent(filePath, workspace);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!file2.exists());
            }
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<Unit>)((Function0)new Function0<Unit>(fs, configDir){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $configDir;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$configDir)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$configDir = string;
                        super(0);
                    }
                }));
            }
        }
    }

    @Override
    @NotNull
    protected final ProjectImpl getProject() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull ProjectImpl project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.scheme = StorageScheme.DEFAULT;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }
}

