/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.SchemeManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.IntProgression;
import kotlin.IntRange;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"S\u0004)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0002\t\r)\u0011\u0001#\u0004\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005!\u0011!B\u0001\t\"\u0015\t\u00012A\u0003\u0002\t\u0011)\u0011\u0001\u0003\t\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001\u0003\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\n\u000b\u0005a\u0011!B\u0001\u0005\b\u0015\tA\"A\u0003\u0002\t\ta\u0001!\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u0002+\u0011!\t\u0001c\u0001\u0016\u0003a\u0011\u0011dB\u0005\u0003\u0013\u0005!\u000b!\u0003\u0002\n\u0003\u0011\u000e\u0001TA\r\u00021\ri\nQPQ\"\u0013\rA9!D\u0001\u0019\t%1\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001(\u0001\u0019\u000b%!\u00012B\u0007\u0003\u0019\u0003Ab!C\u0002\t\u000e5\t\u0001dB\u0005\u0005\t\u0005Ay!D\u0001\u0019\u0011%)A!\u0001E\t\u001b\ta\t\u0001G\u0005R\u0007\u0005A\u0019\"*\b\u0005\u0017!!R\"\u0001M\u00153\rAQ#D\u0001\u001d\u0001e\u0019\u00012F\u0007\u00021G\t6!\u0001\u0005\u0017K%!\u0011\u0001#\f\u000e\u0003a%\u0012\u0004\u0002E\t\u001b\ta\t\u0001G\u0005&\u0011\u0011\t\u0001bF\u0007\u00021GI2\u0001c\f\u000e\u0003aAR\u0005\u0002\u0003\f\u0011ci\u0011\u0001'\u000b&\u001d\u0011\t\u0001\"G\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0003\u00194e1\u0001\u0002E\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u00194\u0015ZA!\u0001\u0005\u001b\u001b\u0005AJ#\u0007\u0004\t65!\u0011BA\u0005\u00021oA2$j\u0006\u0005\u0003!aRB\u0001G\u00019\u0003I2\u0001#\n\u000e\u0003a!\u0011kA\u0001\t:\u0015^Aa\u0003\u0005\u001e\u001b\ta\t\u0001\b\u0001\u001a\u0007!mR\"\u0001\r\u0005#\u000e\t\u0001BH\u0013\b\t-Ai$\u0004\u0003\n\u0005%\t\u0001\u0004\u0002M\u001aKY!1\u0002C\u0010\u000e'%1\u0011\"\u0002I +\ta\t\u0001\b\u0001\u001d\u0001A}R#C\u0005\u0007\u0013\u0015\u0001z$\u0006\u0002\r\u0002q\u0001A\u0004\u0001G\u00011\u0001B2$j\u0004\u0005\u0017!\u0005SB\u0001G\u00019\u0001\t6!\u0001\u0005\"K\u0015!1\u0002c\u0011\u000e\u00051\u0005\u0001\u0004B\u0013\u0006\t\u0005A!%\u0004\u0002\r\u0002aaQ\u0005\u0004\u0003\u0002\u0011\u000bj\u0011\u0001\u0007\u0003\u001a\u0007!\u0015R\"\u0001\r\u00193\rA1%D\u0001\u0019$\u0015\"Aa\u0003E$\u001b\u0005Ar!J\u0007\u0005\u0003!!Sr\u0001M%#\u000e\tA!J\r\u0004\u0011Ui\u0011\u0001(\u0001R\u0007\u0005AY%*\u0006\u0005\u0017!1S\"\u0001M\u00123\rAQ#D\u0001\u001d\u0002E\u001b\u0011\u0001#\u0014&\u0011\u0011\t\u0001bJ\u0007\u00021GI2\u0001c\u0014\u000e\u0003aaQ\u0005\u0003\u0003\u0002\u0011\u001dj\u0011\u0001g\t\u001a\u0007!AS\"\u0001M)K+!\u0011\u0001C\u0015\u000e\u0003a\r\u0012d\u0001E*\u001b\u0005a\n!U\u0002\u0002\u0011\u001b*\u0003\u0002B\u0001\tU5\t\u00014E\r\u0004\u0011Ui\u0011\u0001\u0007\u0002&3\u0011Y\u0001RK\u0007\u00021SI2\u0001C\u0016\u000e\u0003a!\u0011d\u0001E,\u001b\u0005AB&\u0007\u0007\tZ5Q\u0011BA\u0005\u000217J!!C\u0001\u001d\u0001%\u0011\u0011\"\u0001M\u001c15*;\u0003B\u0001\t]5\u0011A\u0012\u0001O\u00013\rA)#D\u0001\u00191e\u0019\u0001RL\u0007\u00021=J2\u0001c\u0018\u000e\u0003a\r\u0012kA\u0001\ta\u0015:Aa\u0003E1\u001b\u0011I!!C\u0001\u001d\u0002aMRU\u0003\u0003\u0002\u0011Ej\u0011\u0001'\u000b\u001a\u0007!\rT\"\u0001\u000f\u0001#\u000e\t\u0001BMS\u0010\t\u0005A)'\u0004\u0002\r\u0002q\u0005\u0011d\u0001E(\u001b\u0005AB\"G\u0002\t`5\t\u00014E)\u0004\u0003!\u0019T%\u0003\u0003\u0002\u0011Oj\u0011\u0001'\u000b\u001a\t!EQB\u0001G\u00011%)3\u0001\u0003\u001b\u000e\u0003a%Re\u0003\u0003\u0002\u0011Sj\u0011\u0001'\u000b\u001a\r!UR\u0002B\u0005\u0003\u0013\u0005A:\u0004G\u000e&\t\u0011\t\u0001\"N\u0007\u00021S)+\u0002B\u0006\tl5\t\u0001\u0014F\r\u0004\u0011Ui\u0011\u0001\b\u0001R\u0007\u0005A!'J\u0006\u0005\u0003!1T\"\u0001M\u00153\u0019Ai'\u0004\u0003\n\u0005%\tA\u0004\u0001\r!K)Aq'D\u0001\u0019*e1\u0001RG\u0007\u0005\u0013\tI\u0011\u0001g\u000e\u00197\u0015vA!\u0001E8\u001b\u0005AJ#G\u0002\t+5\tA\u0014A\r\u0004\u0011aj\u0011\u0001'\u001dR\u0007\u0005A\u0011(j\b\u0005\u0017!MT\"\u0001M\u00153\u0011AQ#\u0004\u0002\r\u0002q\u0001\u0011d\u0001\u0005;\u001b\u0005A\u001a#U\u0002\u0002\u0011Y)S\u0002B\u0006\tv5\t\u0001\u0014F\r\u0005\u0011wi!\u0001$\u0001\u0019\te\u0019\u0001BO\u0007\u00021G)+\u0004B\u0006\tw5\t\u0001\u0014F\r\u0007\u0011[jA!\u0003\u0002\n\u0003q\u0001\u0001\u0004I\r\u0005\u0011oj!\u0001$\u0001\u001d\u0001e9\u0001\u0002P\u0007\u0006\u0013\tI\u0011\u0001\b\u0001\r\u0002ae\u0014kA\u0001\t{\u0015\"Aa\u0003E>\u001b\u0005AB!\n\u0004\u0005\u0003!qT\"\u0001M\u0015+\u0005Az\"\u000b\u0006\u0005\u0004rA!\"\u0004\u0002\r\u0002a!A$\u0001\u0011\u0002#\u000e\tQ\u0001A\u0015\n\t\u0005c\u0002RC\u0007\u0003\u0019\u0003a\u0002!U\u0002\u0003\u000b\u0005A1\"\u000b\u0005\u0005\u0003rA9\"\u0004\u0002\r\u0002aa\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\b5\t\u0001\u0004B)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!eQ\u0002B\u0005\u0003\u0013\u0005AB\u0001G\u0007R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Ai!D\u0001\u0019\u000fE\u001b\u0011!\u0002\u0001*\u0015\u0011\t\u0005\u0002#\u0003\u000e\t%\u0011\u0011\"\u0001O\u00011\u0015\t6!A\u0003\u0001S!!\u0011\t\u0003E\u0006\u001b\ta\t\u0001\u0007\u0004R\u0007\u0005)\u0001!K\u0007\u0005\u0003\"AY\"D\u0004\n\u0005%\t\u0001\u0004B\u0005\u0003\u0013\u0005a\n\u0001\u0007\bR\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Ay!D\u0001\u0019\u0011E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002#\b\u000e\u0003a!\u0011kA\u0001\u0006\u0001%jA!\u0011\u0005\t\u001f59\u0011BA\u0005\u00029\u0003I!!C\u0001\u0019 aq\u0011kA\u0001\u0006\u0001%RA!\u0011\u0005\t!5!\u0011BA\u0005\u00029\u0001A\n#U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011Ei\u0011\u0001g\tR\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A!#D\u0001\u0019$E\u001b\u0011!\u0002\u0001*\u001b\u0011\t\u0005\u0002#\n\u000e\u00051\u0005\u0001\u0004B\u000b\u00021\ta\u0012%U\u0002\u0004\u001b\t!1\u0003c\n"}, strings={"Lcom/intellij/configurationStore/SchemeManagerImpl;", "T", "Lcom/intellij/openapi/options/Scheme;", "E", "Lcom/intellij/openapi/options/ExternalizableScheme;", "Lcom/intellij/openapi/options/SchemesManager;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "fileSpec", "", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "ioDirectory", "Ljava/io/File;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "virtualFileTrackerDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljava/lang/String;Lcom/intellij/openapi/options/SchemeProcessor;Lcom/intellij/configurationStore/StreamProvider;Ljava/io/File;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/Disposable;)V", "currentPendingSchemeName", "currentScheme", "Lcom/intellij/openapi/options/Scheme;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToDelete", "Lgnu/trove/THashSet;", "readOnlyExternalizableSchemes", "Lgnu/trove/THashMap;", "schemeExtension", "schemeToInfo", "Lcom/intellij/configurationStore/SchemeManagerImpl$ExternalInfo;", "schemes", "Ljava/util/ArrayList;", "updateExtension", "", "useVfs", "fileName", "getFileName", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Ljava/lang/String;", "addNewScheme", "", "scheme", "replaceExisting", "(Lcom/intellij/openapi/options/Scheme;Z)V", "addVfsListener", "canRead", "name", "", "clearAllSchemes", "collectExistingNames", "", "deleteFiles", "errors", "", "", "findExternalizableSchemeByFileName", "(Ljava/lang/String;)Lcom/intellij/openapi/options/ExternalizableScheme;", "findSchemeByName", "schemeName", "(Ljava/lang/String;)Lcom/intellij/openapi/options/Scheme;", "getAllSchemeNames", "getAllSchemes", "kotlin.jvm.PlatformType", "", "getCurrentScheme", "()Lcom/intellij/openapi/options/Scheme;", "getCurrentSchemeName", "getDirectory", "getFileExtension", "allowAny", "getRootDirectory", "getState", "Lcom/intellij/openapi/options/SchemeProcessor$State;", "Lorg/jetbrains/annotations/NotNull;", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Lcom/intellij/openapi/options/SchemeProcessor$State;", "isMetadataEditable", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Z", "isMy", "file", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "isOverwriteOnLoad", "existingScheme", "isRenamed", "loadBundledScheme", "resourceName", "requestor", "", "convertor", "Lcom/intellij/util/ThrowableConvertor;", "Lorg/jdom/Element;", "loadScheme", "input", "Ljava/io/InputStream;", "duringLoad", "(Ljava/lang/CharSequence;Ljava/io/InputStream;Z)Lcom/intellij/openapi/options/ExternalizableScheme;", "loadSchemes", "processPendingCurrentSchemeName", "newScheme", "(Lcom/intellij/openapi/options/Scheme;)V", "readSchemeFromFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)Lcom/intellij/openapi/options/ExternalizableScheme;", "refreshVirtualDirectoryAndAddListener", "reload", "removeDirectoryIfEmpty", "removeExternalizableSchemes", "removeScheme", "retainExternalInfo", "newSchemes", "save", "saveScheme", "nameGenerator", "Lcom/intellij/util/text/UniqueNameGenerator;", "(Lcom/intellij/openapi/options/ExternalizableScheme;Lcom/intellij/util/text/UniqueNameGenerator;)V", "setCurrent", "notify", "setCurrentSchemeName", "setSchemes", "newCurrentScheme", "removeCondition", "Lcom/intellij/openapi/util/Condition;", "(Ljava/util/List;Lcom/intellij/openapi/options/Scheme;Lcom/intellij/openapi/util/Condition;)V", "toString", "scheduleDelete", "ExternalInfo"}, moduleName="configuration-store-impl")
public final class SchemeManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends SchemesManager<T, E>
implements SafeWriteRequestor {
    private final ArrayList<T> schemes;
    private final THashMap<String, E> readOnlyExternalizableSchemes;
    private volatile String currentPendingSchemeName;
    private T currentScheme;
    private VirtualFile directory;
    private final String schemeExtension;
    private final boolean updateExtension;
    private final THashSet<String> filesToDelete;
    private final THashMap<E, ExternalInfo> schemeToInfo;
    private final boolean useVfs;
    private final String fileSpec;
    private final SchemeProcessor<E> processor;
    private final StreamProvider provider;
    private final File ioDirectory;
    private final RoamingType roamingType;

    private final void refreshVirtualDirectoryAndAddListener(Disposable virtualFileTrackerDisposable) {
        VirtualFile directory;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        if (virtualFile == null) {
            return;
        }
        this.directory = directory = virtualFile;
        directory.getChildren();
        if (directory instanceof NewVirtualFile) {
            ((NewVirtualFile)directory).markDirty();
        }
        directory.refresh(true, false, new Runnable(this, virtualFileTrackerDisposable){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ Disposable $virtualFileTrackerDisposable;

            public final void run() {
                SchemeManagerImpl.access$addVfsListener(this.this$0, this.$virtualFileTrackerDisposable);
            }
            {
                this.this$0 = schemeManagerImpl;
                this.$virtualFileTrackerDisposable = disposable;
            }
        });
    }

    private final void addVfsListener(Disposable virtualFileTrackerDisposable) {
        Object object = ServiceManager.getService(VirtualFileTracker.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)object;
        String string = "file://" + StringsKt.replace$default((String)this.ioDirectory.getAbsolutePath(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4);
        VirtualFileListener virtualFileListener = (VirtualFileListener)new VirtualFileAdapter(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null || !SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    return;
                }
                String string = event.getFile().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
                ExternalizableScheme oldScheme = SchemeManagerImpl.access$findExternalizableSchemeByFileName(this.this$0, string);
                Scheme oldCurrentScheme = null;
                if (oldScheme != null) {
                    oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$p(this.this$0);
                    ExternalizableScheme externalizableScheme = oldScheme;
                    if (externalizableScheme == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    this.this$0.removeScheme((Scheme)externalizableScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeDeleted(oldScheme);
                }
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                ExternalizableScheme newScheme = SchemeManagerImpl.access$readSchemeFromFile(this.this$0, virtualFile, false);
                if (newScheme != null) {
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).initScheme(newScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeAdded(newScheme);
                    this.updateCurrentScheme(oldCurrentScheme, newScheme);
                }
            }

            private final void updateCurrentScheme(T oldCurrentScheme, E newCurrentScheme) {
                if (Intrinsics.areEqual(oldCurrentScheme, (Object)SchemeManagerImpl.access$getCurrentScheme$p(this.this$0)) ^ true && SchemeManagerImpl.access$getCurrentScheme$p(this.this$0) == null) {
                    Scheme scheme = (Scheme)newCurrentScheme;
                    if (scheme == null) {
                        scheme = (Scheme)CollectionsKt.firstOrNull((List)SchemeManagerImpl.access$getSchemes$p(this.this$0));
                    }
                    this.this$0.setCurrent(scheme);
                }
            }

            static /* bridge */ /* synthetic */ void updateCurrentScheme$default(addVfsListener.1 var0, Scheme scheme, ExternalizableScheme externalizableScheme, int n) {
                if ((n & 2) != 0) {
                    externalizableScheme = null;
                }
                var0.updateCurrentScheme(scheme, externalizableScheme);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        VirtualFile[] virtualFileArray = dir.getChildren();
                        for (int i = 0; i < virtualFileArray.length; ++i) {
                            VirtualFile file2;
                            VirtualFile virtualFile = file2 = virtualFileArray[i];
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                            if (!SchemeManagerImpl.access$isMy(this.this$0, virtualFile)) continue;
                            VirtualFile virtualFile2 = file2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                            this.schemeCreatedExternally(virtualFile2);
                        }
                    }
                } else if (SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                    this.schemeCreatedExternally(virtualFile);
                }
            }

            private final void schemeCreatedExternally(VirtualFile file2) {
                ExternalizableScheme readScheme = SchemeManagerImpl.access$readSchemeFromFile(this.this$0, file2, false);
                if (readScheme != null) {
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).initScheme(readScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeAdded(readScheme);
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                Scheme oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$p(this.this$0);
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory$p(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        SchemeManagerImpl.access$setDirectory$p(this.this$0, null);
                        SchemeManagerImpl.access$removeExternalizableSchemes(this.this$0);
                    }
                } else if (SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    ExternalizableScheme scheme;
                    String string = event.getFile().getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
                    ExternalizableScheme externalizableScheme = SchemeManagerImpl.access$findExternalizableSchemeByFileName(this.this$0, string);
                    if (externalizableScheme == null) {
                        return;
                    }
                    ExternalizableScheme externalizableScheme2 = scheme = externalizableScheme;
                    if (externalizableScheme2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    this.this$0.removeScheme((Scheme)externalizableScheme2);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeDeleted(scheme);
                }
                addVfsListener.1.updateCurrentScheme$default(this, oldCurrentScheme, null, 2);
            }
            {
                this.this$0 = $outer;
            }
        };
        Disposable disposable = virtualFileTrackerDisposable;
        if (disposable == null) {
            Intrinsics.throwNpe();
        }
        virtualFileTracker.addTracker(string, virtualFileListener, false, disposable);
    }

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull(convertor, (String)"convertor");
        try {
            URL url;
            URL uRL = url = requestor instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName);
            if (url == null) {
                ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName);
                return;
            }
            Element element = JDOMUtil.load((InputStream)URLUtil.openStream((URL)url));
            Scheme scheme = (Scheme)convertor.convert((Object)element);
            if (scheme instanceof ExternalizableScheme) {
                String fileName = PathUtilRt.getFileName((String)url.getPath());
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                String extension = this.getFileExtension(charSequence, true);
                ExternalInfo info = new ExternalInfo(StringsKt.substring((String)fileName, (int)0, (int)(fileName.length() - extension.length())), extension);
                info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
                info.setSchemeName(((ExternalizableScheme)scheme).getName());
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                ExternalInfo oldInfo = (ExternalInfo)this.schemeToInfo.put((Object)((ExternalizableScheme)scheme2), (Object)info);
                ComponentStoreImplKt.getLOG().assertTrue(oldInfo == null);
                ExternalizableScheme oldScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.put((Object)((ExternalizableScheme)scheme).getName(), (Object)scheme);
                if (oldScheme != null) {
                    ComponentStoreImplKt.getLOG().warn("Duplicated scheme " + ((ExternalizableScheme)scheme).getName() + " - old: " + oldScheme + ", new " + scheme);
                }
            }
            this.schemes.add(scheme);
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName, e);
        }
    }

    private final String getFileExtension(CharSequence fileName, boolean allowAny) {
        String string;
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.schemeExtension)) {
            string = this.schemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            string = ".xml";
        } else {
            String string2;
            if (allowAny) {
                string2 = PathUtil.getFileExtension((String)((Object)fileName).toString());
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                throw (Throwable)new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
            }
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (allowAny) {\n      Pa\u2026t be filtered out\")\n    }");
        }
        return string;
    }

    private final boolean isMy(VirtualFileEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        return this.isMy(virtualFile);
    }

    private final boolean isMy(VirtualFile file2) {
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file2.getNameSequence(), (CharSequence)this.schemeExtension);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<E> loadSchemes() {
        int n;
        int newSchemesOffset = this.schemes.size();
        if (this.provider != null && this.provider.getEnabled()) {
            this.provider.processChildren(this.fileSpec, this.roamingType, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return SchemeManagerImpl.access$canRead(this.this$0, it);
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(1);
                }
            }), (Function3<? super String, ? super InputStream, ? super Boolean, Boolean>)((Function3)new Function3<String, InputStream, Boolean, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input, boolean readOnly) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    ExternalizableScheme scheme = SchemeManagerImpl.access$loadScheme(this.this$0, name, input, true);
                    if (readOnly && scheme != null) {
                        SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$p(this.this$0).put((Object)scheme.getName(), (Object)scheme);
                    }
                    return true;
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(3);
                }
            }));
        } else {
            Unit unit;
            File[] fileArray = this.ioDirectory.listFiles(new FilenameFilter(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean accept(File parent, String name) {
                    CharSequence charSequence = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"name");
                    return SchemeManagerImpl.access$canRead(this.this$0, charSequence);
                }
                {
                    this.this$0 = schemeManagerImpl;
                }
            });
            if (fileArray != null) {
                File[] $receiver$iv = fileArray;
                File[] it = $receiver$iv;
                for (n = 0; n < it.length; ++n) {
                    File file2 = it[n];
                    if (file2.isDirectory()) continue;
                    try {
                        CharSequence charSequence = file2.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"file.name");
                        this.loadScheme(charSequence, FilesKt.inputStream((File)file2), true);
                        continue;
                    }
                    catch (Throwable e) {
                        ComponentStoreImplKt.getLOG().error("Cannot read scheme " + file2.getPath(), e);
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        SmartList list = new SmartList();
        int it = newSchemesOffset;
        n = this.schemes.size() - 1;
        if (it <= n) {
            while (true) {
                void i;
                T t = this.schemes.get((int)i);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                ExternalizableScheme scheme = (ExternalizableScheme)t;
                this.processor.initScheme(scheme);
                list.add((Object)scheme);
                ExternalizableScheme externalizableScheme = scheme;
                if (externalizableScheme == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                this.processPendingCurrentSchemeName((Scheme)externalizableScheme);
                if (i == n) break;
                ++i;
            }
        }
        return (Collection)list;
    }

    public final void reload() {
        this.removeExternalizableSchemes();
        this.loadSchemes();
    }

    /*
     * Unable to fully structure code
     */
    private final void removeExternalizableSchemes() {
        block6: {
            v0 = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)this.schemes)));
            var1_1 = v0.getFirst();
            var2_2 = v0.getLast();
            var3_3 = v0.getStep();
            v1 = var1_1;
            v2 = var2_2;
            if (!(var3_3 > 0 ? v1 <= v2 : v1 >= v2)) break block6;
            while (true) {
                if (!((scheme = (Scheme)this.schemes.get((int)i)) instanceof ExternalizableScheme)) ** GOTO lbl-1000
                v3 = scheme;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                if (Intrinsics.areEqual((Object)this.getState((ExternalizableScheme)v3), (Object)SchemeProcessor.State.NON_PERSISTENT) ^ true) {
                    if (Intrinsics.areEqual((Object)scheme, this.currentScheme)) {
                        this.currentScheme = null;
                    }
                    v4 = scheme;
                    if (v4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    this.processor.onSchemeDeleted((ExternalizableScheme)v4);
                    v5 = Unit.INSTANCE;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = Unit.INSTANCE;
                }
                if (i == var2_2) break;
                var1_1 = i + var3_3;
            }
        }
        this.retainExternalInfo((List)this.schemes);
    }

    private final E findExternalizableSchemeByFileName(String fileName) {
        for (Scheme scheme : this.schemes) {
            if (!(scheme instanceof ExternalizableScheme) || !Intrinsics.areEqual((Object)fileName, (Object)(this.getFileName((ExternalizableScheme)scheme) + this.schemeExtension))) continue;
            Scheme scheme2 = scheme;
            if (scheme2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            return (E)((ExternalizableScheme)scheme2);
        }
        return (E)((ExternalizableScheme)null);
    }

    private final boolean isOverwriteOnLoad(E existingScheme) {
        if ((ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)existingScheme.getName()) == existingScheme) {
            return true;
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(existingScheme);
        return info != null && Intrinsics.areEqual((Object)this.schemeExtension, (Object)info.getFileExtension()) ^ true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final E loadScheme(CharSequence fileName, InputStream input, boolean duringLoad) {
        try {
            block14: {
                block15: {
                    element = JDOMUtil.load((InputStream)input);
                    v0 = this.processor.readScheme(element, duringLoad);
                    if (v0 == null) {
                        return (E)((ExternalizableScheme)null);
                    }
                    scheme = v0;
                    extension = this.getFileExtension(fileName, false);
                    fileNameWithoutExtension = fileName.subSequence(0, fileName.length() - extension.length()).toString();
                    if (!duringLoad) break block14;
                    if (CollectionsKt.isNotEmpty((Collection)((Collection)this.filesToDelete)) && this.filesToDelete.contains((Object)fileName.toString())) {
                        ComponentStoreImplKt.getLOG().warn("Scheme file " + "\"" + fileName + "\"" + " is not loaded because marked to delete");
                        return (E)((ExternalizableScheme)null);
                    }
                    v1 = scheme.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"scheme.name");
                    existingScheme = this.findSchemeByName(v1);
                    if (existingScheme == null) break block14;
                    if (!(existingScheme instanceof ExternalizableScheme)) break block15;
                    v2 = existingScheme;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    if (!this.isOverwriteOnLoad((ExternalizableScheme)v2)) break block15;
                    this.removeScheme(existingScheme);
                    break block14;
                }
                if (!(Intrinsics.areEqual((Object)this.schemeExtension, (Object)extension) ^ true)) ** GOTO lbl-1000
                v3 = existingScheme;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.options.Scheme");
                }
                v4 = (ExternalInfo)MapsKt.get((Map)((Map)this.schemeToInfo), (Object)((Scheme)v3));
                if (Intrinsics.areEqual((Object)(v4 != null ? v4.getFileNameWithoutExtension() : null), (Object)fileNameWithoutExtension)) {
                    this.filesToDelete.add((Object)fileName.toString());
                } else lbl-1000:
                // 2 sources

                {
                    ComponentStoreImplKt.getLOG().warn("Scheme file " + "\"" + fileName + "\"" + " is not loaded because defines duplicated name " + "\"" + scheme.getName() + "\"");
                }
                return (E)((ExternalizableScheme)null);
            }
            if ((info = (ExternalInfo)this.schemeToInfo.get((Object)scheme)) == null) {
                info = new ExternalInfo(fileNameWithoutExtension, extension);
                this.schemeToInfo.put((Object)scheme, (Object)info);
            } else {
                info.setFileNameWithoutExtension(fileNameWithoutExtension, extension);
            }
            info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
            info.setSchemeName(scheme.getName());
            if (duringLoad) {
                v5 = scheme;
                if (v5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                v6 /* !! */  = Boolean.valueOf(this.schemes.add((Scheme)v5));
            } else {
                v7 = scheme;
                if (v7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                this.addScheme((Scheme)v7);
                v6 /* !! */  = Unit.INSTANCE;
            }
            return (E)scheme;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((ExternalizableScheme)null);
        }
    }

    private final String getFileName(ExternalizableScheme $receiver) {
        ExternalInfo externalInfo = (ExternalInfo)MapsKt.get((Map)((Map)this.schemeToInfo), (Object)$receiver);
        return externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null;
    }

    private final boolean canRead(CharSequence name) {
        return this.updateExtension && StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".xml") || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)this.schemeExtension);
    }

    private final E readSchemeFromFile(VirtualFile file2, boolean duringLoad) {
        CharSequence fileName;
        block5: {
            block4: {
                fileName = file2.getNameSequence();
                if (file2.isDirectory()) break block4;
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                if (this.canRead(charSequence)) break block5;
            }
            return (E)((ExternalizableScheme)null);
        }
        try {
            CharSequence charSequence = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
            InputStream inputStream = file2.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream");
            return this.loadScheme(charSequence, inputStream, duringLoad);
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((ExternalizableScheme)null);
        }
    }

    public final void save(@NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList schemesToSave = new SmartList();
        for (Scheme scheme : this.schemes) {
            Unit unit;
            if (scheme instanceof ExternalizableScheme) {
                String fileName;
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                SchemeProcessor.State state = this.getState((ExternalizableScheme)scheme2);
                if (Intrinsics.areEqual((Object)state, (Object)SchemeProcessor.State.NON_PERSISTENT)) continue;
                hasSchemes = true;
                if (Intrinsics.areEqual((Object)state, (Object)SchemeProcessor.State.UNCHANGED) ^ true) {
                    schemesToSave.add((Object)scheme);
                }
                if ((fileName = this.getFileName((ExternalizableScheme)scheme)) != null) {
                    ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
                    Intrinsics.checkExpressionValueIsNotNull((Object)externalizableScheme, (String)"scheme");
                    if (!this.isRenamed(externalizableScheme)) {
                        nameGenerator.addExistingName(fileName);
                        unit = Unit.INSTANCE;
                        continue;
                    }
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
        for (Scheme scheme : schemesToSave) {
            try {
                Scheme scheme3 = scheme;
                Intrinsics.checkExpressionValueIsNotNull((Object)scheme3, (String)"scheme");
                this.saveScheme(scheme3, nameGenerator);
            }
            catch (Throwable e) {
                errors.add(new RuntimeException("Cannot save scheme " + this.fileSpec + "/" + scheme, e));
            }
        }
        if (!this.filesToDelete.isEmpty()) {
            this.deleteFiles(errors);
            if (!(hasSchemes || this.provider != null && this.provider.getEnabled())) {
                this.removeDirectoryIfEmpty(errors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDirectoryIfEmpty(List<Throwable> errors) {
        VirtualFile dir;
        Object deleteUsingIo;
        Unit unit;
        Comparable<File> file2;
        Ref.BooleanRef $receiver$iv;
        Ref.BooleanRef booleanRef = this.ioDirectory.listFiles();
        if (booleanRef != null) {
            $receiver$iv = booleanRef;
            Ref.BooleanRef it = $receiver$iv;
            for (int i = 0; i < ((File[])it).length; ++i) {
                file2 = it[i];
                if (file2.isHidden()) continue;
                ComponentStoreImplKt.getLOG().info("Directory " + this.ioDirectory.getName() + " is not deleted: at least one file " + file2.getName() + " exists");
                return;
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        ComponentStoreImplKt.getLOG().info("Remove schemes directory " + this.ioDirectory.getName());
        this.directory = null;
        $receiver$iv = new Ref.BooleanRef();
        boolean bl = $receiver$iv.element = !this.useVfs;
        if (!deleteUsingIo.element && (dir = this.getDirectory()) != null) {
            AccessToken token$iv = WriteAction.start();
            try {
                try {
                    dir.delete((Object)this);
                    file2 = Unit.INSTANCE;
                }
                catch (IOException e) {
                    deleteUsingIo.element = true;
                    file2 = errors.add(e);
                }
                File file3 = file2;
            }
            finally {
                token$iv.finish();
            }
        }
        if (deleteUsingIo.element) {
            List<Throwable> $receiver$iv2 = errors;
            try {
                FileUtil.delete((File)this.ioDirectory);
            }
            catch (Throwable e$iv) {
                $receiver$iv2.add(e$iv);
            }
        }
        deleteUsingIo = null;
    }

    private final SchemeProcessor.State getState(E scheme) {
        return this.processor.getState(scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveScheme(E scheme, UniqueNameGenerator nameGenerator) {
        boolean renamed;
        String providerPath;
        Element element;
        Element element2;
        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme);
        String currentFileNameWithoutExtension = externalInfo == null ? (String)null : externalInfo.getFileNameWithoutExtension();
        Parent parent = this.processor.writeScheme(scheme);
        if (parent == null || parent instanceof Element) {
            element2 = (Element)parent;
        } else {
            Parent parent2 = parent;
            if (parent2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jdom.Document");
            }
            element2 = element = ((Document)parent2).detachRootElement();
        }
        if (JDOMUtil.isEmpty((Element)element)) {
            Unit unit;
            ExternalInfo externalInfo2 = externalInfo;
            if (externalInfo2 != null) {
                this.scheduleDelete(externalInfo2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return;
        }
        String fileNameWithoutExtension = currentFileNameWithoutExtension;
        if (fileNameWithoutExtension == null || this.isRenamed((ExternalizableScheme)scheme)) {
            fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeFileName((String)scheme.getName(), (boolean)false));
        }
        Element element3 = element;
        if (element3 == null) {
            Intrinsics.throwNpe();
        }
        int newHash = JDOMUtil.getTreeHash((Element)element3, (boolean)true);
        if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.getHash()) {
            return;
        }
        ExternalizableScheme bundledScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)scheme.getName());
        if (bundledScheme != null) {
            ExternalInfo externalInfo3 = (ExternalInfo)this.schemeToInfo.get((Object)bundledScheme);
            if (Intrinsics.areEqual((Object)(externalInfo3 != null ? Integer.valueOf(externalInfo3.getHash()) : null), (Object)newHash)) {
                Unit unit;
                ExternalInfo externalInfo4 = externalInfo;
                if (externalInfo4 != null) {
                    this.scheduleDelete(externalInfo4);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = fileNameWithoutExtension;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String fileName = stringBuilder.append(string).append(this.schemeExtension).toString();
        this.filesToDelete.remove((Object)fileName);
        BufferExposingByteArrayOutputStream byteOut = FileBasedStorageKt.toBufferExposingByteArray$default((Parent)element, null, 1);
        if (this.provider != null && this.provider.getEnabled()) {
            providerPath = this.fileSpec + '/' + fileName;
            if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                providerPath = null;
            }
        } else {
            providerPath = null;
        }
        boolean bl = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension);
        if (providerPath == null) {
            if (this.useVfs) {
                AccessToken token$iv;
                void file2;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                VirtualFile dir = this.getDirectory();
                if (dir == null || !dir.isValid()) {
                    this.directory = dir = SchemeManagerImplKt.createDir(this.ioDirectory, (Object)this);
                }
                if (renamed) {
                    ExternalInfo externalInfo5 = externalInfo;
                    if (externalInfo5 == null) {
                        Intrinsics.throwNpe();
                    }
                    file2.element = dir.findChild(externalInfo5.getFileName());
                    if ((VirtualFile)file2.element != null) {
                        token$iv = WriteAction.start();
                        try {
                            VirtualFile virtualFile = (VirtualFile)file2.element;
                            if (virtualFile == null) {
                                Intrinsics.throwNpe();
                            }
                            virtualFile.rename((Object)this, fileName);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            token$iv.finish();
                        }
                    }
                }
                if ((VirtualFile)file2.element == null) {
                    file2.element = SchemeManagerImplKt.getFile(fileName, dir, (Object)this);
                }
                token$iv = WriteAction.start();
                try {
                    void $receiver$iv;
                    VirtualFile virtualFile = (VirtualFile)file2.element;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    Closeable $i$a$1 = virtualFile.getOutputStream((Object)this);
                    boolean closed$iv = false;
                    try {
                        OutputStream it = (OutputStream)$receiver$iv;
                        byteOut.writeTo(it);
                        it = Unit.INSTANCE;
                    }
                    catch (Exception e$iv) {
                        closed$iv = true;
                        try {
                            $receiver$iv.close();
                        }
                        catch (Exception closeException$iv) {
                            // empty catch block
                        }
                        throw (Throwable)e$iv;
                    }
                    finally {
                        if (!closed$iv) {
                            $receiver$iv.close();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    token$iv.finish();
                }
                objectRef = null;
            } else {
                if (renamed) {
                    ExternalInfo externalInfo6 = externalInfo;
                    if (externalInfo6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.scheduleDelete(externalInfo6);
                }
                FileUtil.writeToFile((File)new File(this.ioDirectory, fileName), (byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size());
            }
        } else {
            if (renamed) {
                ExternalInfo externalInfo7 = externalInfo;
                if (externalInfo7 == null) {
                    Intrinsics.throwNpe();
                }
                this.scheduleDelete(externalInfo7);
            }
            StreamProvider streamProvider = this.provider;
            if (streamProvider == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = byteOut.getInternalBuffer();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteOut.internalBuffer");
            streamProvider.write(providerPath, byArray, byteOut.size(), this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeToInfo.put(scheme, (Object)externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setHash(newHash);
        externalInfo.setSchemeName(scheme.getName());
    }

    private final void scheduleDelete(ExternalInfo $receiver) {
        this.filesToDelete.add((Object)$receiver.getFileName());
    }

    private final boolean isRenamed(ExternalizableScheme scheme) {
        ExternalInfo info = (ExternalInfo)MapsKt.get((Map)((Map)this.schemeToInfo), (Object)scheme);
        return info != null && Intrinsics.areEqual((Object)scheme.getName(), (Object)info.getSchemeName()) ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void deleteFiles(List<Throwable> errors) {
        VirtualFile file2;
        void $receiver$iv;
        boolean deleteUsingIo;
        if (this.provider != null && this.provider.getEnabled()) {
            deleteUsingIo = false;
            for (String name : this.filesToDelete) {
                VirtualFile virtualFile = errors;
                try {
                    String spec = this.fileSpec + "/" + name;
                    if (!this.provider.isApplicable(spec, this.roamingType)) continue;
                    this.provider.delete(spec, this.roamingType);
                }
                catch (Throwable e$iv) {
                    $receiver$iv.add(e$iv);
                }
            }
        } else if (!this.useVfs) {
            deleteUsingIo = true;
        } else {
            VirtualFile dir = this.getDirectory();
            boolean bl = deleteUsingIo = dir == null;
            if (!deleteUsingIo) {
                AccessToken token = null;
                try {
                    VirtualFile virtualFile = dir;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile[] $i$a$1 = virtualFile.getChildren();
                    for (int spec = 0; spec < $i$a$1.length; ++spec) {
                        file2 = $i$a$1[spec];
                        if (!this.filesToDelete.contains((Object)file2.getName())) continue;
                        if (token == null) {
                            token = WriteAction.start();
                        }
                        VirtualFile e$iv = errors;
                        try {
                            file2.delete((Object)this);
                            continue;
                        }
                        catch (Throwable e$iv2) {
                            void $receiver$iv2;
                            $receiver$iv2.add(e$iv2);
                        }
                    }
                }
                finally {
                    if (token != null) {
                        token.finish();
                    }
                }
            }
        }
        if (deleteUsingIo) {
            for (String name : this.filesToDelete) {
                file2 = errors;
                try {
                    FileUtil.delete((File)new File(this.ioDirectory, name));
                }
                catch (Throwable e$iv) {
                    $receiver$iv.add(e$iv);
                }
            }
        }
        this.filesToDelete.clear();
    }

    private final VirtualFile getDirectory() {
        VirtualFile result2 = this.directory;
        if (result2 == null) {
            this.directory = result2 = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        }
        return result2;
    }

    @NotNull
    public File getRootDirectory() {
        return this.ioDirectory;
    }

    public void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
        Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
        T oldCurrentScheme = this.currentScheme;
        if (removeCondition == null) {
            this.schemes.clear();
        } else {
            CollectionsKt.removeAll((List)this.schemes, (Function1)new Function1<T, Boolean>(removeCondition){
                final /* synthetic */ Condition $removeCondition;

                public final boolean invoke(@NotNull T it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return this.$removeCondition.value(it);
                }
                {
                    this.$removeCondition = condition;
                    super(1);
                }
            });
        }
        this.retainExternalInfo(newSchemes);
        this.schemes.addAll((Collection)newSchemes);
        if (Intrinsics.areEqual(oldCurrentScheme, newCurrentScheme) ^ true) {
            if (newCurrentScheme != null) {
                this.currentScheme = newCurrentScheme;
            } else if (oldCurrentScheme != null && !this.schemes.contains(oldCurrentScheme)) {
                this.currentScheme = (Scheme)CollectionsKt.firstOrNull((List)this.schemes);
            }
            if (Intrinsics.areEqual(oldCurrentScheme, this.currentScheme) ^ true) {
                this.processor.onCurrentSchemeChanged(oldCurrentScheme);
            }
        }
    }

    private final void retainExternalInfo(List<? extends T> newSchemes) {
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        this.schemeToInfo.retainEntries(new TObjectObjectProcedure<E, ExternalInfo>(this, newSchemes){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ List $newSchemes;

            public boolean execute(@NotNull E scheme, @NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                if (Intrinsics.areEqual((Object)((ExternalizableScheme)SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$p(this.this$0).get((Object)scheme.getName())), scheme)) {
                    return true;
                }
                for (Scheme t : this.$newSchemes) {
                    if (t != scheme) continue;
                    if (CollectionsKt.isNotEmpty((Collection)((Collection)SchemeManagerImpl.access$getFilesToDelete$p(this.this$0)))) {
                        SchemeManagerImpl.access$getFilesToDelete$p(this.this$0).remove((Object)String.valueOf(info.getFileName()));
                    }
                    return true;
                }
                SchemeManagerImpl.access$scheduleDelete(this.this$0, info);
                return false;
            }
            {
                this.this$0 = $outer;
                this.$newSchemes = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void addNewScheme(@NotNull T scheme, boolean replaceExisting) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        int toReplace = -1;
        IntRange intRange = CollectionsKt.getIndices((Collection)this.schemes);
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void i;
                Scheme existing;
                if (Intrinsics.areEqual((Object)(existing = (Scheme)this.schemes.get((int)i)).getName(), (Object)scheme.getName())) {
                    if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                        ComponentStoreImplKt.getLOG().warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
                    }
                    toReplace = i;
                    if (!replaceExisting || !(existing instanceof ExternalizableScheme)) break;
                    Scheme scheme2 = existing;
                    if (scheme2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.options.ExternalizableScheme");
                    }
                    ExternalInfo oldInfo = (ExternalInfo)MapsKt.remove((Map)((Map)this.schemeToInfo), (Object)((ExternalizableScheme)scheme2));
                    if (oldInfo == null || !(scheme instanceof ExternalizableScheme)) break;
                    T t = scheme;
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.options.ExternalizableScheme");
                    }
                    if (MapsKt.containsKey((Map)((Map)this.schemeToInfo), (Object)((ExternalizableScheme)t))) break;
                    T t2 = scheme;
                    if (t2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    this.schemeToInfo.put((Object)((ExternalizableScheme)t2), (Object)oldInfo);
                    break;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (toReplace == -1) {
            this.schemes.add(scheme);
        } else if (replaceExisting || !(scheme instanceof ExternalizableScheme)) {
            this.schemes.set(toReplace, scheme);
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            String string = UniqueNameGenerator.generateUniqueName((String)((ExternalizableScheme)scheme).getName(), this.collectExistingNames((Collection)this.schemes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026ctExistingNames(schemes))");
            SchemeManagerImplKt.access$renameScheme(externalizableScheme, string);
            this.schemes.add(scheme);
        }
        if (scheme instanceof ExternalizableScheme && CollectionsKt.isNotEmpty((Collection)((Collection)this.filesToDelete))) {
            T t = scheme;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.options.ExternalizableScheme");
            }
            ExternalInfo info = (ExternalInfo)MapsKt.get((Map)((Map)this.schemeToInfo), (Object)((ExternalizableScheme)t));
            if (info != null) {
                this.filesToDelete.remove((Object)String.valueOf(info.getFileName()));
            }
        }
        this.processPendingCurrentSchemeName(scheme);
    }

    private final Collection<String> collectExistingNames(Collection<? extends T> schemes) {
        THashSet result2 = new THashSet(schemes.size());
        for (Scheme scheme : schemes) {
            result2.add((Object)scheme.getName());
        }
        return (Collection)result2;
    }

    public void clearAllSchemes() {
        this.schemeToInfo.forEachValue((TObjectProcedure)new TObjectProcedure<ExternalInfo>(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            public boolean execute(@NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                SchemeManagerImpl.access$scheduleDelete(this.this$0, info);
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.currentScheme = null;
        this.schemes.clear();
        this.schemeToInfo.clear();
    }

    public List<T> getAllSchemes() {
        return Collections.unmodifiableList((List)this.schemes);
    }

    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
        for (Scheme scheme : this.schemes) {
            if (!Intrinsics.areEqual((Object)scheme.getName(), (Object)schemeName)) continue;
            return (T)scheme;
        }
        return (T)((Scheme)null);
    }

    public void setCurrent(@Nullable T scheme, boolean notify) {
        this.currentPendingSchemeName = null;
        T oldCurrent = this.currentScheme;
        this.currentScheme = scheme;
        if (notify && Intrinsics.areEqual(oldCurrent, scheme) ^ true) {
            this.processor.onCurrentSchemeChanged(oldCurrent);
        }
    }

    public void setCurrentSchemeName(@Nullable String schemeName, boolean notify) {
        Object scheme;
        this.currentPendingSchemeName = schemeName;
        Object object = scheme = schemeName == null ? (Scheme)null : this.findSchemeByName(schemeName);
        if (scheme != null || schemeName == null) {
            this.setCurrent(scheme, notify);
        }
    }

    @Nullable
    public T getCurrentScheme() {
        return this.currentScheme;
    }

    @Nullable
    public String getCurrentSchemeName() {
        Object object = this.currentScheme;
        if (object == null || (object = object.getName()) == null) {
            object = this.currentPendingSchemeName;
        }
        return object;
    }

    private final void processPendingCurrentSchemeName(T newScheme) {
        if (Intrinsics.areEqual((Object)newScheme.getName(), (Object)this.currentPendingSchemeName)) {
            this.setCurrent(newScheme, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeScheme(@NotNull T scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        IntProgression intProgression = RangesKt.downTo((int)(this.schemes.size() - 1), (int)0);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                Scheme s = (Scheme)this.schemes.get((int)i);
                if (Intrinsics.areEqual((Object)scheme.getName(), (Object)s.getName())) {
                    if (Intrinsics.areEqual(this.currentScheme, (Object)s)) {
                        this.currentScheme = null;
                    }
                    if (s instanceof ExternalizableScheme) {
                        Unit unit;
                        Scheme scheme2 = s;
                        if (scheme2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.options.ExternalizableScheme");
                        }
                        ExternalInfo externalInfo = (ExternalInfo)MapsKt.remove((Map)((Map)this.schemeToInfo), (Object)((ExternalizableScheme)scheme2));
                        if (externalInfo != null) {
                            this.scheduleDelete(externalInfo);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                    this.schemes.remove((int)i);
                    break;
                }
                if (i == n2) break;
                n = i + n3;
            }
        }
    }

    @NotNull
    public Collection<String> getAllSchemeNames() {
        if (this.schemes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(this.schemes.size());
        for (Scheme scheme : this.schemes) {
            names.add(scheme.getName());
        }
        return names;
    }

    public boolean isMetadataEditable(@NotNull E scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        return !this.readOnlyExternalizableSchemes.containsKey((Object)scheme.getName());
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    public SchemeManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor2, @Nullable StreamProvider provider, @NotNull File ioDirectory, @NotNull RoamingType roamingType, @Nullable Disposable virtualFileTrackerDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)ioDirectory, (String)"ioDirectory");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        this.fileSpec = fileSpec;
        this.processor = processor2;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.roamingType = roamingType;
        this.schemes = new ArrayList();
        this.readOnlyExternalizableSchemes = new THashMap();
        this.filesToDelete = new THashSet();
        this.schemeToInfo = new THashMap(ContainerUtil.identityStrategy());
        boolean bl = this.useVfs = virtualFileTrackerDisposable != null;
        if (this.processor instanceof SchemeExtensionProvider) {
            String string = ((SchemeExtensionProvider)this.processor).getSchemeExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processor.schemeExtension");
            this.schemeExtension = string;
            this.updateExtension = ((SchemeExtensionProvider)this.processor).isUpgradeNeeded();
        } else {
            this.schemeExtension = ".xml";
            this.updateExtension = false;
        }
        if (this.useVfs && (this.provider == null || !this.provider.getEnabled())) {
            try {
                this.refreshVirtualDirectoryAndAddListener(virtualFileTrackerDisposable);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error(e);
            }
        }
    }

    public /* synthetic */ SchemeManagerImpl(String string, SchemeProcessor schemeProcessor, StreamProvider streamProvider, File file2, RoamingType roamingType, Disposable disposable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            disposable = null;
        }
        this(string, schemeProcessor, streamProvider, file2, roamingType, disposable);
    }

    public static final /* synthetic */ void access$addVfsListener(SchemeManagerImpl $this, @Nullable Disposable virtualFileTrackerDisposable) {
        $this.addVfsListener(virtualFileTrackerDisposable);
    }

    public static final /* synthetic */ boolean access$isMy(SchemeManagerImpl $this, @NotNull VirtualFileEvent event) {
        return $this.isMy(event);
    }

    @Nullable
    public static final /* synthetic */ ExternalizableScheme access$findExternalizableSchemeByFileName(SchemeManagerImpl $this, @NotNull String fileName) {
        return $this.findExternalizableSchemeByFileName(fileName);
    }

    @Nullable
    public static final /* synthetic */ Scheme access$getCurrentScheme$p(SchemeManagerImpl $this) {
        return $this.currentScheme;
    }

    public static final /* synthetic */ void access$setCurrentScheme$p(SchemeManagerImpl $this, @Nullable Scheme scheme) {
        $this.currentScheme = scheme;
    }

    @NotNull
    public static final /* synthetic */ SchemeProcessor access$getProcessor$p(SchemeManagerImpl $this) {
        return $this.processor;
    }

    @Nullable
    public static final /* synthetic */ ExternalizableScheme access$readSchemeFromFile(SchemeManagerImpl $this, @NotNull VirtualFile file2, boolean duringLoad) {
        return $this.readSchemeFromFile(file2, duringLoad);
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getSchemes$p(SchemeManagerImpl $this) {
        return $this.schemes;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory(SchemeManagerImpl $this) {
        return $this.getDirectory();
    }

    public static final /* synthetic */ boolean access$isMy(SchemeManagerImpl $this, @NotNull VirtualFile file2) {
        return $this.isMy(file2);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory$p(SchemeManagerImpl $this) {
        return $this.directory;
    }

    public static final /* synthetic */ void access$setDirectory$p(SchemeManagerImpl $this, @Nullable VirtualFile virtualFile) {
        $this.directory = virtualFile;
    }

    public static final /* synthetic */ void access$removeExternalizableSchemes(SchemeManagerImpl $this) {
        $this.removeExternalizableSchemes();
    }

    public static final /* synthetic */ boolean access$canRead(SchemeManagerImpl $this, @NotNull CharSequence name) {
        return $this.canRead(name);
    }

    @Nullable
    public static final /* synthetic */ ExternalizableScheme access$loadScheme(SchemeManagerImpl $this, @NotNull CharSequence fileName, @NotNull InputStream input, boolean duringLoad) {
        return $this.loadScheme(fileName, input, duringLoad);
    }

    @NotNull
    public static final /* synthetic */ THashMap access$getReadOnlyExternalizableSchemes$p(SchemeManagerImpl $this) {
        return $this.readOnlyExternalizableSchemes;
    }

    @NotNull
    public static final /* synthetic */ THashSet access$getFilesToDelete$p(SchemeManagerImpl $this) {
        return $this.filesToDelete;
    }

    public static final /* synthetic */ void access$scheduleDelete(SchemeManagerImpl $this, ExternalInfo $receiver) {
        $this.scheduleDelete($receiver);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA1B\u0003\u0002\u0011\u0011)\u0011\u0001b\u0002\u0006\u0003!\tQ!\u0001C\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005^\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0003\t\u00055\u0011A\u0012\u0001M\u0002#\u000e\t\u0001RA\u0013\f\u0011\u001bi\u0011\u0001g\u0006\u001a\u0007!aQ\"\u0001M\u00023\rAI\"D\u0001\u0019\u0004\u0015\"Aa\u0003\u0005\u000e\u001b\u0005A\u001a!\u000b\b\u0005\u0007rA!!\u0004\u0002\r\u0002a\r\u0011kA\u0004\u0006\u00015\u0011Aa\u0001E\u0004#\t!A\u0001#\u0003*\u0015\u0011\u0019\u0005\u0002C\u0003\u000e\u0003a\rAdI)\u0004\u00075\u0011A1\u0002E\u0004S5!1\t\b\u0005\u0002\u001b\u0005A\u001a!U\u0002\b\u000b\u0001i!\u0001\u0002\u0004\t\bE\u0011AQ\u0002E\u0005S5!1\t\b\u0005\b\u001b\u0005Az!U\u0002\b\u000b\u0001i!\u0001\u0002\u0005\t\u0012E\u0011A!\u0003E\nS9!1\t\b\u0005\u000b\u001b\ta\t\u0001g\u0001R\u0007\u001d)\u0001!\u0004\u0002\u0005\u0016!\u001d\u0011C\u0001\u0003\f\u0011\u0013\u0001"}, strings={"Lcom/intellij/configurationStore/SchemeManagerImpl$ExternalInfo;", "", "fileNameWithoutExtension", "", "fileExtension", "(Ljava/lang/String;Ljava/lang/String;)V", "getFileExtension", "()Ljava/lang/String;", "setFileExtension", "(Ljava/lang/String;)V", "fileName", "getFileName", "getFileNameWithoutExtension", "setFileNameWithoutExtension", "hash", "", "getHash", "()I", "setHash", "(I)V", "schemeName", "getSchemeName", "setSchemeName", "", "nameWithoutExtension", "extension", "toString"}, moduleName="configuration-store-impl")
    private static final class ExternalInfo {
        @Nullable
        private String schemeName;
        private int hash;
        @NotNull
        private String fileNameWithoutExtension;
        @Nullable
        private String fileExtension;

        @Nullable
        public final String getSchemeName() {
            return this.schemeName;
        }

        public final void setSchemeName(@Nullable String string) {
            this.schemeName = string;
        }

        public final int getHash() {
            return this.hash;
        }

        public final void setHash(int n) {
            this.hash = n;
        }

        @NotNull
        public final String getFileName() {
            return this.fileNameWithoutExtension + this.fileExtension;
        }

        public final void setFileNameWithoutExtension(@NotNull String nameWithoutExtension, @NotNull String extension) {
            Intrinsics.checkParameterIsNotNull((Object)nameWithoutExtension, (String)"nameWithoutExtension");
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            this.fileNameWithoutExtension = nameWithoutExtension;
            this.fileExtension = extension;
        }

        @NotNull
        public String toString() {
            return this.getFileName();
        }

        @NotNull
        public final String getFileNameWithoutExtension() {
            return this.fileNameWithoutExtension;
        }

        public final void setFileNameWithoutExtension(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.fileNameWithoutExtension = string;
        }

        @Nullable
        public final String getFileExtension() {
            return this.fileExtension;
        }

        public final void setFileExtension(@Nullable String string) {
            this.fileExtension = string;
        }

        public ExternalInfo(@NotNull String fileNameWithoutExtension, @Nullable String fileExtension) {
            Intrinsics.checkParameterIsNotNull((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
            this.fileNameWithoutExtension = fileNameWithoutExtension;
            this.fileExtension = fileExtension;
        }
    }
}

