/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.IntRange;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.iq80.snappy.SnappyInputStream;
import org.iq80.snappy.SnappyOutputStream;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u0012\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0012\u000b\u0005!\u0019!B\u0001\t%\u0015\u0001Q!\u0001E\u0006\u000b\u0005!1!B\u0001\t&\u0015\tA!\u0001\u0007\u0001!AI\u0012\u0001'\u0001\u001e\u0002A\t+\u0003B\u0001\n\r!\tQ\u0002B\u0005\u0003\u0013\u0005A\"\u0001g\u0001\n\u000f!\u0015Q\"B\u0005\u0004\u0013\ta\t\u0001'\u0001\u0019\u0007E\u001b\u0011\u0001c\u0002&\u0019!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\u0005e!\u0001BB\u0007\u0003\u0019\u0003Aj!\n\n\t\u000f5\t\u0001$B\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0002\u001a\u0007!=Q\"\u0001\r\u00013\u0019A\u0001\"\u0004\u0003\n\u0005%\t\u0001D\u0001M\tK!A\u0011\"\u0004\u0002\r\u0002a\u0005\u0011d\u0001E\u0006\u001b\u0005A\"!J\n\t\u00145\t\u0001TB\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0002\u001a\u0017\u0011\t\u0001BC\u0007\t\u0013\tI\u0011\u0001\u0007\u0002\n\u0005%\t\u0001T\u0002G\u00011+)S\u0002C\u0006\u000e\u00051\u0005\u0001TB\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0002\u001a\t\u0011\t\u0001\u0012B\u0007\u00021/)s\u0001\u0003\u0007\u000e\u0003a]\u0011d\u0001E\u0006\u001b\u0005A\"!J\u0002\t\u001a5\t\u0001tC\u0013\u0004\u00115i\u0011\u0001g\u0006&\u0012!mQ\u0002B\u0005\u0003\u0013\u0005A\"\u0001g\u0001R\u0007\u0005Aa\"J\u0005\t\u001e59\u0011BA\u0005\u00021\tI!!C\u0001\u0019\u0002ayQ\u0005\u0002\u0003\f\u0011?i\u0011\u0001\u0007\u0002*\u0017\u0011\t\u0005\u0002C\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00031\u0007\t6AA\u0003\u0002\u0011\u0011I3\u0002B!\t\u0011\u000biQ!C\u0002\n\u00051\u0005\u0001\u0014\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/StateMap;", "", "names", "", "", "states", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "([Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicReferenceArray;)V", "[Ljava/lang/String;", "archive", "", "key", "state", "Lorg/jdom/Element;", "compare", "newStates", "diffs", "", "get", "getElement", "newLiveStates", "", "getState", "", "hasState", "hasStates", "isEmpty", "keys", "()[Ljava/lang/String;", "toMutableMap", "", "toString", "Companion"}, moduleName="configuration-store-impl")
public final class StateMap {
    private final String[] names;
    private final AtomicReferenceArray<Object> states;
    private static final Format XML_FORMAT;
    @NotNull
    public static final StateMap EMPTY;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        String string;
        if (Intrinsics.areEqual((Object)this, (Object)Companion.getEMPTY())) {
            string = "EMPTY";
        } else {
            String string2 = this.states.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"states.toString()");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMutableMap() {
        int n;
        THashMap map = new THashMap(((Object[])this.names).length);
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                map.put((Object)this.names[i], this.states.get((int)i));
                if (i == n) break;
                ++i;
            }
        }
        return (Map)map;
    }

    @NotNull
    public final String[] keys() {
        return this.names;
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        return index < 0 ? null : this.states.get(index);
    }

    @NotNull
    public final Element getElement(@NotNull String key, @Nullable Map<String, ? extends Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.stateToElement(key, this.get(key), newLiveStates);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Element getElement$default(StateMap stateMap, String string, Map map, int n) {
        if ((n & 2) != 0) {
            map = null;
        }
        return stateMap.getElement(string, map);
    }

    public final boolean isEmpty() {
        return ArraysKt.isEmpty((Object[])this.names);
    }

    public final boolean hasState(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.get(key) instanceof Element;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasStates() {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                if (this.states.get((int)i) instanceof Element) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final void compare(@NotNull String key, @NotNull StateMap newStates, @NotNull Set<String> diffs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)newStates, (String)"newStates");
        Intrinsics.checkParameterIsNotNull(diffs, (String)"diffs");
        Object oldState = this.get(key);
        Object newState = newStates.get(key);
        if (oldState instanceof Element) {
            if (!JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) {
                diffs.add(key);
            }
        } else {
            Object object = newState;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = oldState;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
            }
            if (Companion.getNewByteIfDiffers(key, object, (byte[])object2) != null) {
                diffs.add(key);
            }
        }
    }

    @Nullable
    public final Element getState(@NotNull String key, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return null;
        }
        Object object = this.states.get(index);
        if (!(object instanceof Element)) {
            object = null;
        }
        Element element = (Element)object;
        if (element == null) {
            return null;
        }
        Element state = element;
        if (!archive) {
            return state;
        }
        return this.states.compareAndSet(index, state, StateMap.Companion.archiveState(state)) ? state : this.getState(key, true);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element getState$default(StateMap stateMap, String string, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stateMap.getState(string, bl);
    }

    public final void archive(@NotNull String key, @Nullable Element state) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return;
        }
        Object currentState = this.states.get(index);
        ComponentStoreImplKt.getLOG().assertTrue(currentState instanceof Element);
        this.states.set(index, state == null ? (byte[])null : StateMap.Companion.archiveState(state));
    }

    private StateMap(String[] names, AtomicReferenceArray<Object> states) {
        this.names = names;
        this.states = states;
    }

    static {
        StateMap stateMap;
        Companion = com.intellij.configurationStore.StateMap$Companion.INSTANCE;
        XML_FORMAT = Format.getRawFormat().setTextMode(Format.TextMode.TRIM).setOmitEncoding(true).setOmitDeclaration(true);
        StateMap stateMap2 = stateMap;
        StateMap stateMap3 = stateMap;
        Object[] objectArray = new String[0];
        stateMap2((String[])objectArray, new AtomicReferenceArray<Object>(0));
        EMPTY = stateMap3;
    }

    public /* synthetic */ StateMap(@NotNull String[] names, @NotNull AtomicReferenceArray states, DefaultConstructorMarker $constructor_marker) {
        this(names, states);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001\"C\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001BE\u0003\u0002\u0011\u001d)\u0011\u0001b\u0002\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0003\u0003\u0002\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\bK5A\u0001\"D\u0001\u0019\u0005eI\u0001\u0012C\u0007\b\u0013\tI\u0011\u0001g\u0005\n\u0005%\t\u0001\u0014\u0001\r\nKAA!\"\u0004\u0002\r\u0002a5\u0011d\u0001E\u000b\u001b\u0005A\u001a\"G\u0002\t\u00175\t\u0001\u0014A\r\u0004\u0011/i\u0011\u0001'\u0004&1!aQ\"\u0001M\b3\rA)\"D\u0001\u0019\u0014e!\u0001bB\u0007\u0003\u0019\u0003A\n!G\u0006\u0005\u0003!eQ\u0002C\u0005\u0003\u0013\u0005A\u001a\"\u0003\u0002\n\u0003a=A\u0012\u0001\r\nK1!\u0011\u0001C\u0007\u000e\u000bA%QC\u0001G\u00011\u001fAz!G\u0002\t\u000f5\t\u0001TB\u0015\f\t\rC\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%zA!\u0011\u0005\t\b5)\u0001\u0013B\u000b\u0003\u0019\u0003AB\u0001\u0007\u0003R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011)\u00012\u0002"}, strings={"Lcom/intellij/configurationStore/StateMap$Companion;", "", "()V", "EMPTY", "Lcom/intellij/configurationStore/StateMap;", "getEMPTY", "()Lcom/intellij/configurationStore/StateMap;", "XML_FORMAT", "Lorg/jdom/output/Format;", "kotlin.jvm.PlatformType", "getXML_FORMAT", "()Lorg/jdom/output/Format;", "archiveState", "", "state", "Lorg/jdom/Element;", "fromMap", "map", "", "", "getNewByteIfDiffers", "key", "newState", "oldState", "stateToElement", "newLiveStates", "unarchiveState"}, moduleName="configuration-store-impl")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final Format getXML_FORMAT() {
            return XML_FORMAT;
        }

        @NotNull
        public final StateMap getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StateMap fromMap(@NotNull Map<String, ? extends Object> map) {
            int n;
            Intrinsics.checkParameterIsNotNull(map, (String)"map");
            if (map.isEmpty()) {
                return this.getEMPTY();
            }
            Collection $receiver$iv = map.keySet();
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv22 = collection;
            String[] stringArray = thisCollection$iv22.toArray(new String[thisCollection$iv22.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] names = (String[])((Object[])stringArray);
            if (!(map instanceof TreeMap)) {
                Arrays.sort(names);
            }
            AtomicReferenceArray<Object> states = new AtomicReferenceArray<Object>(((Object[])names).length);
            IntRange intRange = ArraysKt.getIndices((Object[])names);
            int thisCollection$iv22 = intRange.getFirst();
            if (thisCollection$iv22 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    states.set((int)i, map.get(names[i]));
                    if (i == n) break;
                    ++i;
                }
            }
            return new StateMap(names, states, null);
        }

        @NotNull
        public final Element stateToElement(@NotNull String key, @Nullable Object state, @Nullable Map<String, ? extends Element> newLiveStates) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            if (state instanceof Element) {
                Element element = ((Element)state).clone();
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"state.clone()");
                return element;
            }
            Element element = newLiveStates;
            if (element == null || (element = element.get(key)) == null) {
                Object object = state;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                Element element2 = this.unarchiveState((byte[])object);
                element = element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"unarchiveState(state as ByteArray)");
            }
            return element;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Element stateToElement$default(Companion companion, String string, Object object, Map map, int n) {
            if ((n & 4) != 0) {
                map = null;
            }
            return companion.stateToElement(string, object, map);
        }

        @Nullable
        public final byte[] getNewByteIfDiffers(@NotNull String key, @NotNull Object newState, @NotNull byte[] oldState) {
            byte[] newBytes;
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
            Intrinsics.checkParameterIsNotNull((Object)oldState, (String)"oldState");
            if (newState instanceof Element) {
                byArray = this.archiveState((Element)newState);
            } else {
                Object object = newState;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                byArray = newBytes = (byte[])object;
            }
            if (Arrays.equals(newBytes, oldState)) {
                return null;
            }
            if (SystemProperties.getBooleanProperty((String)"idea.log.changed.components", (boolean)false)) {
                Object after2;
                getNewByteIfDiffers.1 stateToString$ = getNewByteIfDiffers.1.INSTANCE;
                Object before = stateToString$.invoke(oldState);
                if (Intrinsics.areEqual((Object)before, (Object)(after2 = stateToString$.invoke(newState)))) {
                    ComponentStoreImplKt.getLOG().info("Serialization error: serialized are different, but unserialized are equal");
                } else {
                    ComponentStoreImplKt.getLOG().info(key + " " + StringUtil.repeat((String)"=", (int)(80 - key.length())) + "\n" + "Before:" + "\n" + (String)before + "\n" + "After:" + "\n" + (String)after2);
                }
            }
            return newBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final byte[] archiveState(Element state) {
            BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
            Closeable $receiver$iv = new OutputStreamWriter((OutputStream)new SnappyOutputStream((OutputStream)byteOut), CharsetToolkit.UTF8_CHARSET);
            boolean closed$iv = false;
            try {
                OutputStreamWriter it = (OutputStreamWriter)$receiver$iv;
                JDOMUtil.MyXMLOutputter xmlOutputter = new JDOMUtil.MyXMLOutputter();
                xmlOutputter.setFormat(Companion.getXML_FORMAT());
                xmlOutputter.output(state, (Writer)it);
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            finally {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
            }
            byte[] byArray = ArrayUtil.realloc((byte[])byteOut.getInternalBuffer(), (int)byteOut.size());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ArrayUtil.realloc(byteOu\u2026alBuffer, byteOut.size())");
            return byArray;
        }

        private final Element unarchiveState(byte[] state) {
            return JDOMUtil.load((InputStream)((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(state))));
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }

        public static final /* synthetic */ Element access$unarchiveState(Companion $this, @NotNull byte[] state) {
            return $this.unarchiveState(state);
        }
    }
}

