/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BoxingEvaluator
implements Evaluator {
    private final Evaluator myOperand;

    public BoxingEvaluator(Evaluator operand) {
        this.myOperand = new DisableGC(operand);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object result2 = this.myOperand.evaluate(context);
        if (result2 == null || result2 instanceof ObjectReference) {
            return result2;
        }
        if (result2 instanceof BooleanValue) {
            return BoxingEvaluator.convertToWrapper(context, (BooleanValue)result2, "java.lang.Boolean");
        }
        if (result2 instanceof ByteValue) {
            return BoxingEvaluator.convertToWrapper(context, (ByteValue)result2, "java.lang.Byte");
        }
        if (result2 instanceof CharValue) {
            return BoxingEvaluator.convertToWrapper(context, (CharValue)result2, "java.lang.Character");
        }
        if (result2 instanceof ShortValue) {
            return BoxingEvaluator.convertToWrapper(context, (ShortValue)result2, "java.lang.Short");
        }
        if (result2 instanceof IntegerValue) {
            return BoxingEvaluator.convertToWrapper(context, (IntegerValue)result2, "java.lang.Integer");
        }
        if (result2 instanceof LongValue) {
            return BoxingEvaluator.convertToWrapper(context, (LongValue)result2, "java.lang.Long");
        }
        if (result2 instanceof FloatValue) {
            return BoxingEvaluator.convertToWrapper(context, (FloatValue)result2, "java.lang.Float");
        }
        if (result2 instanceof DoubleValue) {
            return BoxingEvaluator.convertToWrapper(context, (DoubleValue)result2, "java.lang.Double");
        }
        throw new EvaluateException("Cannot perform boxing conversion for a value of type " + ((Value)result2).type().name());
    }

    @Override
    @Nullable
    public Modifier getModifier() {
        return null;
    }

    private static Value convertToWrapper(EvaluationContextImpl context, PrimitiveValue value, String wrapperTypeName) throws EvaluateException {
        String methodSignature;
        DebugProcessImpl process = context.getDebugProcess();
        ClassType wrapperClass = (ClassType)process.findClass(context, wrapperTypeName, null);
        List<Method> methods = wrapperClass.methodsByName("valueOf", methodSignature = "(" + JVMNameUtil.getPrimitiveSignature(value.type().name()) + ")L" + wrapperTypeName.replace('.', '/') + ";");
        if (methods.size() == 0) {
            methods = wrapperClass.methodsByName("<init>", methodSignature);
        }
        if (methods.size() == 0) {
            throw new EvaluateException("Cannot construct wrapper object for value of type " + value.type() + ": Unable to find either valueOf() or constructor method");
        }
        return process.invokeMethod((EvaluationContext)context, wrapperClass, methods.get(0), Collections.singletonList(value));
    }
}

