/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ArrayAccessEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ArrayInitializerEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BreakContinueStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ClassObjectEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ConditionalExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.DoWhileStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.FieldEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForeachStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IfStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LiteralEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.NewClassInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PostfixOperationEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThisEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeCastEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.evaluation.expression.WhileStatementEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatorBuilderImpl
implements EvaluatorBuilder {
    private static final EvaluatorBuilderImpl ourInstance = new EvaluatorBuilderImpl();

    private EvaluatorBuilderImpl() {
    }

    public static EvaluatorBuilder getInstance() {
        return ourInstance;
    }

    public static ExpressionEvaluator build(TextWithImports text, @Nullable PsiElement contextElement, SourcePosition position) throws EvaluateException {
        if (contextElement == null) {
            throw EvaluateExceptionUtil.CANNOT_FIND_SOURCE_CLASS;
        }
        Project project2 = contextElement.getProject();
        CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, contextElement);
        JavaCodeFragment codeFragment = factory.createCodeFragment(text, contextElement, project2);
        if (codeFragment == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{text.getText()}));
        }
        codeFragment.forceResolveScope(GlobalSearchScope.allScope((Project)project2));
        DebuggerUtils.checkSyntax((PsiCodeFragment)codeFragment);
        return factory.getEvaluatorBuilder().build((PsiElement)codeFragment, position);
    }

    public ExpressionEvaluator build(PsiElement codeFragment, SourcePosition position) throws EvaluateException {
        return new Builder(position).buildElement(codeFragment);
    }

    private static Evaluator[] wrapVarargs(PsiParameter[] declaredParams, PsiExpression[] actualArgumentExpressions, PsiSubstitutor methodResolveSubstitutor, Evaluator[] argumentEvaluators) {
        int lastParam = declaredParams.length - 1;
        if (lastParam >= 0 && declaredParams[lastParam].isVarArgs() && argumentEvaluators.length > lastParam) {
            if (!TypeConversionUtil.isNullType((PsiType)actualArgumentExpressions[lastParam].getType())) {
                return argumentEvaluators;
            }
            if (argumentEvaluators.length - lastParam == 1 && actualArgumentExpressions[lastParam].getType() instanceof PsiArrayType) {
                return argumentEvaluators;
            }
            PsiEllipsisType declaredParamType = (PsiEllipsisType)methodResolveSubstitutor.substitute(declaredParams[lastParam].getType());
            ArrayInitializerEvaluator varargArrayEvaluator = new ArrayInitializerEvaluator(Arrays.copyOfRange(argumentEvaluators, lastParam, argumentEvaluators.length));
            NewArrayInstanceEvaluator evaluator = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(declaredParamType.toArrayType())), null, varargArrayEvaluator);
            Evaluator[] res = new Evaluator[declaredParams.length];
            System.arraycopy(argumentEvaluators, 0, res, 0, lastParam);
            res[lastParam] = new DisableGC(evaluator);
            return res;
        }
        return argumentEvaluators;
    }

    private static void processBoxingConversions(PsiParameter[] declaredParams, PsiExpression[] actualArgumentExpressions, PsiSubstitutor methodResolveSubstitutor, Evaluator[] argumentEvaluators) {
        if (declaredParams.length > 0) {
            int paramCount = Math.max(declaredParams.length, actualArgumentExpressions.length);
            PsiType varargType = null;
            for (int idx = 0; idx < paramCount && idx < actualArgumentExpressions.length; ++idx) {
                PsiType actualArgType;
                PsiType declaredParamType;
                if (idx < declaredParams.length) {
                    declaredParamType = methodResolveSubstitutor.substitute(declaredParams[idx].getType());
                    if (declaredParamType instanceof PsiEllipsisType) {
                        declaredParamType = varargType = ((PsiEllipsisType)declaredParamType).getComponentType();
                    }
                } else {
                    if (varargType == null) break;
                    declaredParamType = varargType;
                }
                if (!TypeConversionUtil.boxingConversionApplicable((PsiType)declaredParamType, (PsiType)(actualArgType = actualArgumentExpressions[idx].getType()))) continue;
                Evaluator argEval = argumentEvaluators[idx];
                argumentEvaluators[idx] = declaredParamType instanceof PsiPrimitiveType ? new UnBoxingEvaluator(argEval) : new BoxingEvaluator(argEval);
            }
        }
    }

    private static class Builder
    extends JavaElementVisitor {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl");
        private Evaluator myResult = null;
        private PsiClass myContextPsiClass;
        private CodeFragmentEvaluator myCurrentFragmentEvaluator;
        private final Set<JavaCodeFragment> myVisitedFragments = new HashSet<JavaCodeFragment>();
        @Nullable
        private final SourcePosition myPosition;

        private Builder(@Nullable SourcePosition position) {
            this.myPosition = position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitCodeFragment(JavaCodeFragment codeFragment) {
            this.myVisitedFragments.add(codeFragment);
            ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                for (PsiElement child = codeFragment.getFirstChild(); child != null; child = child.getNextSibling()) {
                    child.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        evaluators.add(this.myResult);
                    }
                    this.myResult = null;
                }
                this.myCurrentFragmentEvaluator.setStatements(evaluators.toArray(new Evaluator[evaluators.size()]));
                this.myResult = this.myCurrentFragmentEvaluator;
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        public void visitErrorElement(PsiErrorElement element) {
            Builder.throwExpressionInvalid((PsiElement)element);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiExpression rExpression = expression.getRExpression();
            if (rExpression == null) {
                Builder.throwExpressionInvalid((PsiElement)expression);
            }
            rExpression.accept((PsiElementVisitor)this);
            Evaluator rEvaluator = this.myResult;
            PsiExpression lExpression = expression.getLExpression();
            PsiType lType = lExpression.getType();
            if (lType == null) {
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{lExpression.getText()}));
            }
            IElementType assignmentType = expression.getOperationTokenType();
            PsiType rType = rExpression.getType();
            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)rExpression) && rType != null) {
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{expression.getOperationSign().getText()}));
            }
            lExpression.accept((PsiElementVisitor)this);
            Evaluator lEvaluator = this.myResult;
            rEvaluator = Builder.handleAssignmentBoxingAndPrimitiveTypeConversions(lType, rType, rEvaluator);
            if (assignmentType != JavaTokenType.EQ) {
                IElementType opType = TypeConversionUtil.convertEQtoOperation((IElementType)assignmentType);
                PsiType typeForBinOp = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opType, (boolean)true);
                if (typeForBinOp == null || rType == null) {
                    Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
                }
                rEvaluator = Builder.createBinaryEvaluator(lEvaluator, lType, rEvaluator, rType, opType, typeForBinOp);
            }
            this.myResult = new AssignmentEvaluator(lEvaluator, rEvaluator);
        }

        private static Evaluator handleAssignmentBoxingAndPrimitiveTypeConversions(PsiType lType, PsiType rType, Evaluator rEvaluator) {
            PsiPrimitiveType unboxedLType = PsiPrimitiveType.getUnboxedType((PsiType)lType);
            if (unboxedLType != null) {
                if (rType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)rType)) {
                    if (!rType.equals(unboxedLType)) {
                        rEvaluator = new TypeCastEvaluator(rEvaluator, unboxedLType.getCanonicalText(), true);
                    }
                    rEvaluator = new BoxingEvaluator(rEvaluator);
                }
            } else if (lType instanceof PsiPrimitiveType) {
                PsiPrimitiveType unboxedRType;
                PsiPrimitiveType _rType;
                if (rType instanceof PsiClassType) {
                    rEvaluator = new UnBoxingEvaluator(rEvaluator);
                }
                Object object = _rType = (unboxedRType = PsiPrimitiveType.getUnboxedType((PsiType)rType)) != null ? unboxedRType : rType;
                if (_rType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)_rType) && !lType.equals(_rType)) {
                    rEvaluator = new TypeCastEvaluator(rEvaluator, lType.getCanonicalText(), true);
                }
            }
            return rEvaluator;
        }

        public void visitTryStatement(PsiTryStatement statement2) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(statement2.getText()));
        }

        public void visitStatement(PsiStatement statement2) {
            Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{statement2.getText()}));
        }

        private CodeFragmentEvaluator setNewCodeFragmentEvaluator() {
            CodeFragmentEvaluator old = this.myCurrentFragmentEvaluator;
            this.myCurrentFragmentEvaluator = new CodeFragmentEvaluator(this.myCurrentFragmentEvaluator);
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitBlockStatement(PsiBlockStatement statement2) {
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                PsiStatement[] statements = statement2.getCodeBlock().getStatements();
                Evaluator[] evaluators = new Evaluator[statements.length];
                for (int i = 0; i < statements.length; ++i) {
                    PsiStatement psiStatement = statements[i];
                    psiStatement.accept((PsiElementVisitor)this);
                    evaluators[i] = new DisableGC(this.myResult);
                    this.myResult = null;
                }
                this.myResult = new BlockStatementEvaluator(evaluators);
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        public void visitLabeledStatement(PsiLabeledStatement labeledStatement) {
            PsiStatement statement2 = labeledStatement.getStatement();
            if (statement2 != null) {
                statement2.accept((PsiElementVisitor)this);
            }
        }

        private static String getLabel(PsiElement element) {
            String label = null;
            if (element.getParent() instanceof PsiLabeledStatement) {
                label = ((PsiLabeledStatement)element.getParent()).getName();
            }
            return label;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            Evaluator bodyEvaluator = this.accept((PsiElement)statement2.getBody());
            Evaluator conditionEvaluator = this.accept((PsiElement)statement2.getCondition());
            if (conditionEvaluator != null) {
                this.myResult = new DoWhileStatementEvaluator(new UnBoxingEvaluator(conditionEvaluator), bodyEvaluator, Builder.getLabel((PsiElement)statement2));
            }
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            Evaluator bodyEvaluator = this.accept((PsiElement)statement2.getBody());
            Evaluator conditionEvaluator = this.accept((PsiElement)statement2.getCondition());
            if (conditionEvaluator != null) {
                this.myResult = new WhileStatementEvaluator(new UnBoxingEvaluator(conditionEvaluator), bodyEvaluator, Builder.getLabel((PsiElement)statement2));
            }
        }

        public void visitForStatement(PsiForStatement statement2) {
            Evaluator initializerEvaluator = this.accept((PsiElement)statement2.getInitialization());
            Evaluator conditionEvaluator = this.accept((PsiElement)statement2.getCondition());
            if (conditionEvaluator != null) {
                conditionEvaluator = new UnBoxingEvaluator(conditionEvaluator);
            }
            Evaluator updateEvaluator = this.accept((PsiElement)statement2.getUpdate());
            Evaluator bodyEvaluator = this.accept((PsiElement)statement2.getBody());
            if (bodyEvaluator != null) {
                this.myResult = new ForStatementEvaluator(initializerEvaluator, conditionEvaluator, updateEvaluator, bodyEvaluator, Builder.getLabel((PsiElement)statement2));
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            try {
                String iterationParameterName = statement2.getIterationParameter().getName();
                this.myCurrentFragmentEvaluator.setInitialValue(iterationParameterName, null);
                SyntheticVariableEvaluator iterationParameterEvaluator = new SyntheticVariableEvaluator(this.myCurrentFragmentEvaluator, iterationParameterName);
                Evaluator iteratedValueEvaluator = this.accept((PsiElement)statement2.getIteratedValue());
                Evaluator bodyEvaluator = this.accept((PsiElement)statement2.getBody());
                if (bodyEvaluator != null) {
                    this.myResult = new ForeachStatementEvaluator(iterationParameterEvaluator, iteratedValueEvaluator, bodyEvaluator, Builder.getLabel((PsiElement)statement2));
                }
            }
            catch (EvaluateException e) {
                throw new EvaluateRuntimeException(e);
            }
        }

        @Nullable
        private Evaluator accept(@Nullable PsiElement element) {
            if (element == null || element instanceof PsiEmptyStatement) {
                return null;
            }
            element.accept((PsiElementVisitor)this);
            return this.myResult;
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiExpression condition;
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            thenBranch.accept((PsiElementVisitor)this);
            Evaluator thenEvaluator = this.myResult;
            PsiStatement elseBranch = statement2.getElseBranch();
            Evaluator elseEvaluator = null;
            if (elseBranch != null) {
                elseBranch.accept((PsiElementVisitor)this);
                elseEvaluator = this.myResult;
            }
            if ((condition = statement2.getCondition()) == null) {
                return;
            }
            condition.accept((PsiElementVisitor)this);
            this.myResult = new IfStatementEvaluator(new UnBoxingEvaluator(this.myResult), thenEvaluator, elseEvaluator);
        }

        public void visitBreakStatement(PsiBreakStatement statement2) {
            PsiIdentifier labelIdentifier = statement2.getLabelIdentifier();
            this.myResult = BreakContinueStatementEvaluator.createBreakEvaluator(labelIdentifier != null ? labelIdentifier.getText() : null);
        }

        public void visitContinueStatement(PsiContinueStatement statement2) {
            PsiIdentifier labelIdentifier = statement2.getLabelIdentifier();
            this.myResult = BreakContinueStatementEvaluator.createContinueEvaluator(labelIdentifier != null ? labelIdentifier.getText() : null);
        }

        public void visitExpressionStatement(PsiExpressionStatement statement2) {
            statement2.getExpression().accept((PsiElementVisitor)this);
        }

        public void visitExpression(PsiExpression expression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitExpression " + expression);
            }
        }

        public void visitPolyadicExpression(PsiPolyadicExpression wideExpression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitPolyadicExpression " + wideExpression);
            }
            PsiExpression[] operands = wideExpression.getOperands();
            operands[0].accept((PsiElementVisitor)this);
            Evaluator result2 = this.myResult;
            PsiType lType = operands[0].getType();
            for (int i = 1; i < operands.length; ++i) {
                PsiType typeForBinOp;
                PsiExpression expression = operands[i];
                if (expression == null) {
                    Builder.throwExpressionInvalid((PsiElement)wideExpression);
                }
                expression.accept((PsiElementVisitor)this);
                Evaluator rResult = this.myResult;
                IElementType opType = wideExpression.getOperationTokenType();
                PsiType rType = expression.getType();
                if (rType == null) {
                    Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
                }
                if ((typeForBinOp = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opType, (boolean)true)) == null) {
                    Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{wideExpression.getText()}));
                }
                this.myResult = Builder.createBinaryEvaluator(result2, lType, rResult, rType, opType, typeForBinOp);
                lType = typeForBinOp;
                result2 = this.myResult;
            }
        }

        private static BinaryExpressionEvaluator createBinaryEvaluator(Evaluator lResult, PsiType lType, Evaluator rResult, @NotNull PsiType rType, @NotNull IElementType operation, @NotNull PsiType expressionExpectedType) {
            if (rType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder", "createBinaryEvaluator"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder", "createBinaryEvaluator"));
            }
            if (expressionExpectedType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionExpectedType", "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder", "createBinaryEvaluator"));
            }
            if (Builder.isUnboxingInBinaryExpressionApplicable(lType, rType, operation)) {
                if (rType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(rType.getCanonicalText())) {
                    rResult = new UnBoxingEvaluator(rResult);
                }
                if (lType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(lType.getCanonicalText())) {
                    lResult = new UnBoxingEvaluator(lResult);
                }
            }
            if (Builder.isBinaryNumericPromotionApplicable(lType, rType, operation)) {
                PsiType _lType = lType;
                PsiPrimitiveType unboxedLType = PsiPrimitiveType.getUnboxedType((PsiType)lType);
                if (unboxedLType != null) {
                    _lType = unboxedLType;
                }
                PsiType _rType = rType;
                PsiPrimitiveType unboxedRType = PsiPrimitiveType.getUnboxedType((PsiType)rType);
                if (unboxedRType != null) {
                    _rType = unboxedRType;
                }
                if (PsiType.DOUBLE.equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.DOUBLE)) {
                        rResult = new TypeCastEvaluator(rResult, PsiType.DOUBLE.getCanonicalText(), true);
                    }
                } else if (PsiType.DOUBLE.equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.DOUBLE)) {
                        lResult = new TypeCastEvaluator(lResult, PsiType.DOUBLE.getCanonicalText(), true);
                    }
                } else if (PsiType.FLOAT.equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.FLOAT)) {
                        rResult = new TypeCastEvaluator(rResult, PsiType.FLOAT.getCanonicalText(), true);
                    }
                } else if (PsiType.FLOAT.equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.FLOAT)) {
                        lResult = new TypeCastEvaluator(lResult, PsiType.FLOAT.getCanonicalText(), true);
                    }
                } else if (PsiType.LONG.equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.LONG)) {
                        rResult = new TypeCastEvaluator(rResult, PsiType.LONG.getCanonicalText(), true);
                    }
                } else if (PsiType.LONG.equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.LONG)) {
                        lResult = new TypeCastEvaluator(lResult, PsiType.LONG.getCanonicalText(), true);
                    }
                } else {
                    if (!PsiType.INT.equals((Object)_lType) && TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.INT)) {
                        lResult = new TypeCastEvaluator(lResult, PsiType.INT.getCanonicalText(), true);
                    }
                    if (!PsiType.INT.equals((Object)_rType) && TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.INT)) {
                        rResult = new TypeCastEvaluator(rResult, PsiType.INT.getCanonicalText(), true);
                    }
                }
            }
            return new BinaryExpressionEvaluator(lResult, rResult, operation, expressionExpectedType.getCanonicalText());
        }

        private static boolean isBinaryNumericPromotionApplicable(PsiType lType, PsiType rType, IElementType opType) {
            if (lType == null || rType == null) {
                return false;
            }
            if (!TypeConversionUtil.isNumericType((PsiType)lType) || !TypeConversionUtil.isNumericType((PsiType)rType)) {
                return false;
            }
            if (opType == JavaTokenType.EQEQ || opType == JavaTokenType.NE) {
                if (PsiType.NULL.equals((Object)lType) || PsiType.NULL.equals((Object)rType)) {
                    return false;
                }
                if (lType instanceof PsiClassType && rType instanceof PsiClassType) {
                    return false;
                }
                if (lType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)lType) != null;
                }
                if (rType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)rType) != null;
                }
                return true;
            }
            return opType == JavaTokenType.ASTERISK || opType == JavaTokenType.DIV || opType == JavaTokenType.PERC || opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS || opType == JavaTokenType.LT || opType == JavaTokenType.LE || opType == JavaTokenType.GT || opType == JavaTokenType.GE || opType == JavaTokenType.AND || opType == JavaTokenType.XOR || opType == JavaTokenType.OR;
        }

        private static boolean isUnboxingInBinaryExpressionApplicable(PsiType lType, PsiType rType, IElementType opCode) {
            if (PsiType.NULL.equals((Object)lType) || PsiType.NULL.equals((Object)rType)) {
                return false;
            }
            if (opCode == JavaTokenType.EQEQ || opCode == JavaTokenType.NE) {
                return lType instanceof PsiPrimitiveType && rType instanceof PsiClassType || lType instanceof PsiClassType && rType instanceof PsiPrimitiveType;
            }
            if (opCode == JavaTokenType.PLUS && (lType instanceof PsiClassType && lType.equalsToText("java.lang.String") || rType instanceof PsiClassType && rType.equalsToText("java.lang.String"))) {
                return false;
            }
            return lType instanceof PsiClassType || rType instanceof PsiClassType;
        }

        @Nullable
        private static PsiType calcUnaryNumericPromotionType(PsiPrimitiveType type) {
            if (PsiType.BYTE.equals((Object)type) || PsiType.SHORT.equals((Object)type) || PsiType.CHAR.equals((Object)type) || PsiType.INT.equals((Object)type)) {
                return PsiType.INT;
            }
            return null;
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            PsiElement[] declaredElements;
            ArrayList<AssignmentEvaluator> evaluators = new ArrayList<AssignmentEvaluator>();
            for (PsiElement declaredElement : declaredElements = statement2.getDeclaredElements()) {
                if (declaredElement instanceof PsiLocalVariable) {
                    if (this.myCurrentFragmentEvaluator != null) {
                        PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                        PsiType lType = localVariable.getType();
                        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)localVariable.getProject()).getElementFactory();
                        try {
                            PsiExpression initialValue = elementFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)lType), null);
                            Object value = JavaConstantExpressionEvaluator.computeConstantExpression(initialValue, true);
                            this.myCurrentFragmentEvaluator.setInitialValue(localVariable.getName(), value);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        catch (EvaluateException e) {
                            throw new EvaluateRuntimeException(e);
                        }
                        PsiExpression initializer = localVariable.getInitializer();
                        if (initializer == null) continue;
                        try {
                            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)initializer)) {
                                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.incompatible.variable.initializer.type", (Object[])new Object[]{localVariable.getName()}));
                            }
                            PsiType rType = initializer.getType();
                            initializer.accept((PsiElementVisitor)this);
                            Evaluator rEvaluator = this.myResult;
                            PsiExpression localVarReference = elementFactory.createExpressionFromText(localVariable.getName(), (PsiElement)initializer);
                            localVarReference.accept((PsiElementVisitor)this);
                            Evaluator lEvaluator = this.myResult;
                            rEvaluator = Builder.handleAssignmentBoxingAndPrimitiveTypeConversions(localVarReference.getType(), rType, rEvaluator);
                            AssignmentEvaluator assignment = new AssignmentEvaluator(lEvaluator, rEvaluator);
                            evaluators.add(assignment);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        continue;
                    }
                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.local.variable.declarations.not.supported", (Object[])new Object[0]), null));
                }
                throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.unsupported.declaration", (Object[])new Object[]{declaredElement.getText()}), null));
            }
            if (!evaluators.isEmpty()) {
                CodeFragmentEvaluator codeFragmentEvaluator = new CodeFragmentEvaluator(this.myCurrentFragmentEvaluator);
                codeFragmentEvaluator.setStatements(evaluators.toArray(new Evaluator[evaluators.size()]));
                this.myResult = codeFragmentEvaluator;
            } else {
                this.myResult = null;
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitConditionalExpression " + expression);
            }
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            if (thenExpression == null || elseExpression == null) {
                Builder.throwExpressionInvalid((PsiElement)expression);
            }
            PsiExpression condition = expression.getCondition();
            condition.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                Builder.throwExpressionInvalid((PsiElement)condition);
            }
            UnBoxingEvaluator conditionEvaluator = new UnBoxingEvaluator(this.myResult);
            thenExpression.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                Builder.throwExpressionInvalid((PsiElement)thenExpression);
            }
            Evaluator thenEvaluator = this.myResult;
            elseExpression.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                Builder.throwExpressionInvalid((PsiElement)elseExpression);
            }
            Evaluator elseEvaluator = this.myResult;
            this.myResult = new ConditionalExpressionEvaluator(conditionEvaluator, thenEvaluator, elseEvaluator);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitReferenceExpression " + expression);
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            JavaResolveResult resolveResult = expression.advancedResolve(true);
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                Value labeledValue = (Value)element.getUserData(CodeFragmentFactoryContextWrapper.LABEL_VARIABLE_VALUE_KEY);
                if (labeledValue != null) {
                    this.myResult = new IdentityEvaluator(labeledValue);
                    return;
                }
                PsiFile containingFile = element.getContainingFile();
                if (containingFile instanceof PsiCodeFragment && this.myCurrentFragmentEvaluator != null && this.myVisitedFragments.contains(containingFile)) {
                    this.myResult = new SyntheticVariableEvaluator(this.myCurrentFragmentEvaluator, ((PsiVariable)element).getName());
                    return;
                }
                PsiVariable psiVar = (PsiVariable)element;
                String localName = psiVar.getName();
                PsiClass variableClass = this.getContainingClass(psiVar);
                if (this.getContextPsiClass() == null || this.getContextPsiClass().equals(variableClass)) {
                    PsiParameterListOwner method = DebuggerUtilsEx.getContainingMethod((PsiElement)expression);
                    boolean canScanFrames = method instanceof PsiLambdaExpression || ContextUtil.isJspImplicit(element);
                    this.myResult = new LocalVariableEvaluator(localName, canScanFrames);
                    return;
                }
                int iterationCount = 0;
                PsiClass aClass = Builder.getOuterClass(this.getContextPsiClass());
                while (aClass != null && !aClass.equals(variableClass)) {
                    ++iterationCount;
                    aClass = Builder.getOuterClass(aClass);
                }
                if (aClass != null) {
                    Object value;
                    PsiExpression initializer = psiVar.getInitializer();
                    if (initializer != null && (value = JavaPsiFacade.getInstance((Project)psiVar.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) != null) {
                        PsiType type = resolveResult.getSubstitutor().substitute(psiVar.getType());
                        this.myResult = new LiteralEvaluator(value, type.getCanonicalText());
                        return;
                    }
                    ThisEvaluator objectEvaluator = new ThisEvaluator(iterationCount);
                    PsiClass classAt = this.myPosition != null ? JVMNameUtil.getClassAt(this.myPosition) : null;
                    FieldEvaluator.TargetClassFilter filter = FieldEvaluator.createClassFilter(classAt != null ? classAt : this.getContextPsiClass());
                    this.myResult = Builder.createFallbackEvaluator(new FieldEvaluator(objectEvaluator, filter, "val$" + localName), new LocalVariableEvaluator(localName, true));
                    return;
                }
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.local.variable.missing.from.class.closure", (Object[])new Object[]{localName}));
            } else if (element instanceof PsiField) {
                Evaluator objectEvaluator;
                PsiField psiField = (PsiField)element;
                PsiClass fieldClass = psiField.getContainingClass();
                if (fieldClass == null) {
                    Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.field.class", (Object[])new Object[]{psiField.getName()}));
                    return;
                }
                if (psiField.hasModifierProperty("static")) {
                    objectEvaluator = new TypeEvaluator(JVMNameUtil.getContextClassJVMQualifiedName(SourcePosition.createFromElement((PsiElement)psiField)));
                } else if (qualifier != null) {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                } else if (fieldClass.equals(this.getContextPsiClass()) || this.getContextPsiClass() != null && this.getContextPsiClass().isInheritor(fieldClass, true)) {
                    objectEvaluator = new ThisEvaluator();
                } else {
                    int iterationCount = 0;
                    PsiClass aClass = this.getContextPsiClass();
                    while (aClass != null && !aClass.equals(fieldClass) && !aClass.isInheritor(fieldClass, true)) {
                        ++iterationCount;
                        aClass = Builder.getOuterClass(aClass);
                    }
                    if (aClass == null) {
                        Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.cannot.sources.for.field.class", (Object[])new Object[]{psiField.getName()}));
                    }
                    objectEvaluator = new ThisEvaluator(iterationCount);
                }
                this.myResult = new FieldEvaluator(objectEvaluator, FieldEvaluator.createClassFilter(fieldClass), psiField.getName());
            } else {
                PsiElement nameElement = expression.getReferenceNameElement();
                if (!(nameElement instanceof PsiIdentifier)) {
                    String elementDisplayString = nameElement != null ? nameElement.getText() : "(null)";
                    Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.identifier.expected", (Object[])new Object[]{elementDisplayString}));
                    return;
                }
                String name = nameElement.getText();
                if (qualifier != null) {
                    PsiElement qualifierTarget;
                    PsiElement psiElement = qualifierTarget = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
                    if (qualifierTarget instanceof PsiClass) {
                        PsiClass psiClass = (PsiClass)qualifierTarget;
                        JVMName typeName = JVMNameUtil.getJVMQualifiedName(psiClass);
                        this.myResult = new FieldEvaluator(new TypeEvaluator(typeName), FieldEvaluator.createClassFilter(psiClass), name);
                    } else {
                        qualifier.accept((PsiElementVisitor)this);
                        if (this.myResult == null) {
                            Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{qualifier.getText()}));
                        }
                        this.myResult = new FieldEvaluator(this.myResult, FieldEvaluator.createClassFilter(qualifier.getType()), name);
                    }
                } else {
                    this.myResult = new LocalVariableEvaluator(name, false);
                }
            }
        }

        private static Evaluator createFallbackEvaluator(final Evaluator primary, final Evaluator fallback) {
            return new Evaluator(){

                @Override
                public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
                    try {
                        return primary.evaluate(context);
                    }
                    catch (EvaluateException e) {
                        try {
                            return fallback.evaluate(context);
                        }
                        catch (EvaluateException e1) {
                            throw e;
                        }
                    }
                }

                @Override
                public Modifier getModifier() {
                    return primary.getModifier();
                }
            };
        }

        private static void throwExpressionInvalid(PsiElement expression) {
            Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{expression.getText()}));
        }

        private static void throwEvaluateException(String message) throws EvaluateRuntimeException {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)message));
        }

        public void visitSuperExpression(PsiSuperExpression expression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitSuperExpression " + expression);
            }
            int iterationCount = this.calcIterationCount(expression.getQualifier());
            this.myResult = new SuperEvaluator(iterationCount);
        }

        public void visitThisExpression(PsiThisExpression expression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitThisExpression " + expression);
            }
            int iterationCount = this.calcIterationCount(expression.getQualifier());
            this.myResult = new ThisEvaluator(iterationCount);
        }

        private int calcIterationCount(PsiJavaCodeReferenceElement qualifier) {
            if (qualifier != null) {
                return this.calcIterationCount(qualifier.resolve(), qualifier.getText());
            }
            return 0;
        }

        private int calcIterationCount(PsiElement targetClass, String name) {
            int iterationCount = 0;
            if (targetClass == null || this.getContextPsiClass() == null) {
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{name}));
            }
            try {
                PsiClass aClass = this.getContextPsiClass();
                while (aClass != null && !aClass.equals(targetClass)) {
                    ++iterationCount;
                    aClass = Builder.getOuterClass(aClass);
                }
            }
            catch (Exception e) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((Throwable)e));
            }
            return iterationCount;
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            PsiTypeElement checkType;
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitInstanceOfExpression " + expression);
            }
            if ((checkType = expression.getCheckType()) == null) {
                Builder.throwExpressionInvalid((PsiElement)expression);
            }
            PsiType type = checkType.getType();
            expression.getOperand().accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            this.myResult = new InstanceofEvaluator(operandEvaluator, new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type)));
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiExpression expr;
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitParenthesizedExpression " + expression);
            }
            if ((expr = expression.getExpression()) != null) {
                expr.accept((PsiElementVisitor)this);
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            if (expression.getType() == null) {
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
            }
            PsiExpression operandExpression = expression.getOperand();
            operandExpression.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            IElementType operation = expression.getOperationTokenType();
            PsiType operandType = operandExpression.getType();
            PsiPrimitiveType unboxedOperandType = PsiPrimitiveType.getUnboxedType((PsiType)operandType);
            Evaluator incrementImpl = Builder.createBinaryEvaluator(operandEvaluator, operandType, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, operation == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(unboxedOperandType != null ? unboxedOperandType : operandType));
            if (unboxedOperandType != null) {
                incrementImpl = new BoxingEvaluator(incrementImpl);
            }
            this.myResult = new PostfixOperationEvaluator(operandEvaluator, incrementImpl);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            PsiExpression operandExpression;
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
            }
            if ((operandExpression = expression.getOperand()) == null) {
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.expression.operand", (Object[])new Object[]{expression.getText()}));
            }
            operandExpression.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            PsiType operandType = operandExpression.getType();
            PsiPrimitiveType unboxedOperandType = PsiPrimitiveType.getUnboxedType((PsiType)operandType);
            IElementType operation = expression.getOperationTokenType();
            if (operation == JavaTokenType.PLUSPLUS || operation == JavaTokenType.MINUSMINUS) {
                try {
                    BinaryExpressionEvaluator rightEval = Builder.createBinaryEvaluator(operandEvaluator, operandType, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, operation == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(unboxedOperandType != null ? unboxedOperandType : operandType));
                    this.myResult = new AssignmentEvaluator(operandEvaluator, unboxedOperandType != null ? new BoxingEvaluator(rightEval) : rightEval);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            } else {
                if (JavaTokenType.PLUS.equals(operation) || JavaTokenType.MINUS.equals(operation) || JavaTokenType.TILDE.equals(operation)) {
                    operandEvaluator = Builder.handleUnaryNumericPromotion(operandType, operandEvaluator);
                } else if (unboxedOperandType != null) {
                    operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
                }
                this.myResult = new UnaryExpressionEvaluator(operation, expressionType.getCanonicalText(), operandEvaluator, expression.getOperationSign().getText());
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            Evaluator objectEvaluator;
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitMethodCallExpression " + expression);
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] argExpressions = argumentList.getExpressions();
            Evaluator[] argumentEvaluators = new Evaluator[argExpressions.length];
            for (int idx = 0; idx < argExpressions.length; ++idx) {
                PsiExpression psiExpression = argExpressions[idx];
                psiExpression.accept((PsiElementVisitor)this);
                if (this.myResult == null) {
                    Builder.throwExpressionInvalid((PsiElement)psiExpression);
                }
                argumentEvaluators[idx] = new DisableGC(this.myResult);
            }
            PsiReferenceExpression methodExpr = expression.getMethodExpression();
            JavaResolveResult resolveResult = methodExpr.advancedResolve(false);
            PsiMethod psiMethod = (PsiMethod)resolveResult.getElement();
            PsiExpression qualifier = methodExpr.getQualifierExpression();
            JVMName contextClass = null;
            if (psiMethod != null) {
                PsiClass methodPsiClass = psiMethod.getContainingClass();
                contextClass = JVMNameUtil.getJVMQualifiedName(methodPsiClass);
                if (psiMethod.hasModifierProperty("static")) {
                    objectEvaluator = new TypeEvaluator(contextClass);
                } else if (qualifier != null) {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                } else {
                    int iterationCount = 0;
                    PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
                    if (currentFileResolveScope instanceof PsiClass) {
                        PsiClass aClass = this.getContextPsiClass();
                        while (aClass != null && !aClass.equals(currentFileResolveScope)) {
                            aClass = Builder.getOuterClass(aClass);
                            ++iterationCount;
                        }
                    }
                    objectEvaluator = new ThisEvaluator(iterationCount);
                }
            } else if (qualifier != null) {
                PsiType type = qualifier.getType();
                if (type != null) {
                    contextClass = JVMNameUtil.getJVMQualifiedName(type);
                }
                if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                    if (contextClass == null) {
                        contextClass = JVMNameUtil.getJVMRawText(((PsiReferenceExpression)qualifier).getQualifiedName());
                    }
                    objectEvaluator = new TypeEvaluator(contextClass);
                } else {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                }
            } else {
                objectEvaluator = new ThisEvaluator();
                contextClass = JVMNameUtil.getContextClassJVMQualifiedName(this.myPosition);
                if (contextClass == null && this.myContextPsiClass != null) {
                    contextClass = JVMNameUtil.getJVMQualifiedName(this.myContextPsiClass);
                }
            }
            if (objectEvaluator == null) {
                Builder.throwExpressionInvalid((PsiElement)expression);
            }
            if (psiMethod != null && !psiMethod.isConstructor() && psiMethod.getReturnType() == null) {
                Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.unknown.method.return.type", (Object[])new Object[]{psiMethod.getText()}));
            }
            boolean defaultInterfaceMethod = false;
            boolean mustBeVararg = false;
            if (psiMethod != null) {
                EvaluatorBuilderImpl.processBoxingConversions(psiMethod.getParameterList().getParameters(), argExpressions, resolveResult.getSubstitutor(), argumentEvaluators);
                argumentEvaluators = EvaluatorBuilderImpl.wrapVarargs(psiMethod.getParameterList().getParameters(), argExpressions, resolveResult.getSubstitutor(), argumentEvaluators);
                defaultInterfaceMethod = psiMethod.hasModifierProperty("default");
                mustBeVararg = psiMethod.isVarArgs();
            }
            this.myResult = new MethodEvaluator(objectEvaluator, contextClass, methodExpr.getReferenceName(), psiMethod != null ? JVMNameUtil.getJVMSignature(psiMethod) : null, argumentEvaluators, defaultInterfaceMethod, mustBeVararg);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            HighlightInfo parsingError = HighlightUtil.checkLiteralExpressionParsingError(expression, null, null);
            if (parsingError != null) {
                Builder.throwEvaluateException(parsingError.getDescription());
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                Builder.throwEvaluateException(expression + ": null type");
                return;
            }
            this.myResult = new LiteralEvaluator(expression.getValue(), type.getCanonicalText());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            PsiExpression indexExpression = expression.getIndexExpression();
            if (indexExpression == null) {
                Builder.throwExpressionInvalid((PsiElement)expression);
            }
            indexExpression.accept((PsiElementVisitor)this);
            Evaluator indexEvaluator = Builder.handleUnaryNumericPromotion(indexExpression.getType(), this.myResult);
            expression.getArrayExpression().accept((PsiElementVisitor)this);
            Evaluator arrayEvaluator = this.myResult;
            this.myResult = new ArrayAccessEvaluator(arrayEvaluator, indexEvaluator);
        }

        private static Evaluator handleUnaryNumericPromotion(PsiType operandExpressionType, Evaluator operandEvaluator) {
            PsiType promotionType;
            PsiPrimitiveType _unboxedIndexType;
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)operandExpressionType);
            if (unboxedType != null && !PsiType.BOOLEAN.equals((Object)unboxedType)) {
                operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
            }
            Object object = _unboxedIndexType = unboxedType != null ? unboxedType : operandExpressionType;
            if (_unboxedIndexType instanceof PsiPrimitiveType && (promotionType = Builder.calcUnaryNumericPromotionType(_unboxedIndexType)) != null) {
                operandEvaluator = new TypeCastEvaluator(operandEvaluator, promotionType.getCanonicalText(), true);
            }
            return operandEvaluator;
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            boolean performCastToWrapperClass;
            PsiExpression operandExpr = expression.getOperand();
            if (operandExpr == null) {
                Builder.throwExpressionInvalid((PsiElement)expression);
            }
            operandExpr.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            PsiTypeElement castTypeElem = expression.getCastType();
            if (castTypeElem == null) {
                Builder.throwExpressionInvalid((PsiElement)expression);
            }
            PsiType castType = castTypeElem.getType();
            PsiType operandType = operandExpr.getType();
            if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType) && PsiUtil.resolveClassInType((PsiType)operandType) != null) {
                throw new EvaluateRuntimeException(new EvaluateException(JavaErrorMessages.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(castType))));
            }
            boolean shouldPerformBoxingConversion = operandType != null && TypeConversionUtil.boxingConversionApplicable((PsiType)castType, (PsiType)operandType);
            boolean castingToPrimitive = castType instanceof PsiPrimitiveType;
            if (shouldPerformBoxingConversion && castingToPrimitive) {
                operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
            }
            boolean bl = performCastToWrapperClass = shouldPerformBoxingConversion && !castingToPrimitive;
            if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)castType) instanceof PsiTypeParameter)) {
                PsiPrimitiveType unboxedType;
                String castTypeName = castType.getCanonicalText();
                if (performCastToWrapperClass && (unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)castType)) != null) {
                    castTypeName = unboxedType.getCanonicalText();
                }
                this.myResult = new TypeCastEvaluator(operandEvaluator, castTypeName, castingToPrimitive);
            }
            if (performCastToWrapperClass) {
                this.myResult = new BoxingEvaluator(this.myResult);
            }
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
            PsiType type = expression.getOperand().getType();
            if (type instanceof PsiPrimitiveType) {
                JVMName typeName = JVMNameUtil.getJVMRawText(((PsiPrimitiveType)type).getBoxedTypeName());
                this.myResult = new FieldEvaluator(new TypeEvaluator(typeName), FieldEvaluator.TargetClassFilter.ALL, "TYPE");
            } else {
                this.myResult = new ClassObjectEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type)));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.lambda.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.method.reference.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitNewExpression(PsiNewExpression expression) {
            PsiType expressionPsiType = expression.getType();
            if (expressionPsiType instanceof PsiArrayType) {
                Evaluator dimensionEvaluator = null;
                PsiExpression[] dimensions = expression.getArrayDimensions();
                if (dimensions.length == 1) {
                    PsiExpression dimensionExpression = dimensions[0];
                    dimensionExpression.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        dimensionEvaluator = Builder.handleUnaryNumericPromotion(dimensionExpression.getType(), this.myResult);
                    } else {
                        Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.array.dimension.expression", (Object[])new Object[]{dimensionExpression.getText()}));
                    }
                } else if (dimensions.length > 1) {
                    Builder.throwEvaluateException(DebuggerBundle.message((String)"evaluation.error.multi.dimensional.arrays.creation.not.supported", (Object[])new Object[0]));
                }
                Evaluator initializerEvaluator = null;
                PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
                if (arrayInitializer != null) {
                    if (dimensionEvaluator != null) {
                        Builder.throwExpressionInvalid((PsiElement)expression);
                    }
                    arrayInitializer.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        initializerEvaluator = Builder.handleUnaryNumericPromotion(arrayInitializer.getType(), this.myResult);
                    } else {
                        Builder.throwExpressionInvalid((PsiElement)arrayInitializer);
                    }
                }
                if (dimensionEvaluator == null && initializerEvaluator == null) {
                    Builder.throwExpressionInvalid((PsiElement)expression);
                }
                this.myResult = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(expressionPsiType)), dimensionEvaluator, initializerEvaluator);
            } else if (expressionPsiType instanceof PsiClassType) {
                PsiClass aClass = ((PsiClassType)expressionPsiType).resolve();
                if (aClass instanceof PsiAnonymousClass) {
                    throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.anonymous.class.evaluation.not.supported", (Object[])new Object[0])));
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    Builder.throwExpressionInvalid((PsiElement)expression);
                }
                PsiExpression[] argExpressions = argumentList.getExpressions();
                JavaResolveResult constructorResolveResult = expression.resolveMethodGenerics();
                PsiMethod constructor = (PsiMethod)constructorResolveResult.getElement();
                if (constructor == null && argExpressions.length > 0) {
                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{expression.getText()}), null));
                }
                Evaluator[] argumentEvaluators = new Evaluator[argExpressions.length];
                for (int idx = 0; idx < argExpressions.length; ++idx) {
                    PsiExpression argExpression = argExpressions[idx];
                    argExpression.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        argumentEvaluators[idx] = new DisableGC(this.myResult);
                        continue;
                    }
                    Builder.throwExpressionInvalid((PsiElement)argExpression);
                }
                if (constructor != null) {
                    EvaluatorBuilderImpl.processBoxingConversions(constructor.getParameterList().getParameters(), argExpressions, constructorResolveResult.getSubstitutor(), argumentEvaluators);
                    argumentEvaluators = EvaluatorBuilderImpl.wrapVarargs(constructor.getParameterList().getParameters(), argExpressions, constructorResolveResult.getSubstitutor(), argumentEvaluators);
                }
                if (aClass != null && aClass.getContainingClass() != null && !aClass.hasModifierProperty("static")) {
                    argumentEvaluators = this.addThisEvaluator(argumentEvaluators, aClass.getContainingClass());
                }
                JVMName signature = JVMNameUtil.getJVMConstructorSignature(constructor, aClass);
                this.myResult = new NewClassInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(expressionPsiType)), signature, argumentEvaluators);
            } else if (expressionPsiType != null) {
                Builder.throwEvaluateException("Unsupported expression type: " + expressionPsiType.getPresentableText());
            } else {
                Builder.throwEvaluateException("Unknown type for expression: " + expression.getText());
            }
        }

        private Evaluator[] addThisEvaluator(Evaluator[] argumentEvaluators, PsiClass cls) {
            Evaluator[] res = new Evaluator[argumentEvaluators.length + 1];
            int depth = this.calcIterationCount((PsiElement)cls, "this");
            res[0] = new ThisEvaluator(depth);
            System.arraycopy(argumentEvaluators, 0, res, 1, argumentEvaluators.length);
            return res;
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            PsiExpression[] initializers = expression.getInitializers();
            Evaluator[] evaluators = new Evaluator[initializers.length];
            PsiType type = expression.getType();
            boolean primitive = type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType() instanceof PsiPrimitiveType;
            for (int idx = 0; idx < initializers.length; ++idx) {
                PsiExpression initializer = initializers[idx];
                initializer.accept((PsiElementVisitor)this);
                if (this.myResult != null) {
                    Evaluator coerced = primitive ? Builder.handleUnaryNumericPromotion(initializer.getType(), this.myResult) : new BoxingEvaluator(this.myResult);
                    evaluators[idx] = new DisableGC(coerced);
                    continue;
                }
                Builder.throwExpressionInvalid((PsiElement)initializer);
            }
            this.myResult = new ArrayInitializerEvaluator(evaluators);
            if (type != null && !(expression.getParent() instanceof PsiNewExpression)) {
                this.myResult = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type)), null, this.myResult);
            }
        }

        @Nullable
        private static PsiClass getOuterClass(PsiClass aClass) {
            return aClass == null ? null : (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        }

        private PsiClass getContainingClass(PsiVariable variable) {
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)variable.getParent(), PsiClass.class, (boolean)false);
            return element == null ? this.getContextPsiClass() : (PsiClass)element;
        }

        @Nullable
        public PsiClass getContextPsiClass() {
            return this.myContextPsiClass;
        }

        protected ExpressionEvaluator buildElement(PsiElement element) throws EvaluateException {
            LOG.assertTrue(element.isValid());
            this.myContextPsiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
            try {
                element.accept((PsiElementVisitor)this);
            }
            catch (EvaluateRuntimeException e) {
                throw e.getCause();
            }
            if (this.myResult == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{element.toString()}));
            }
            return new ExpressionEvaluatorImpl(this.myResult);
        }
    }
}

