/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.sun.jdi.ReferenceType;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class BreakpointWithHighlighter<P extends JavaBreakpointProperties>
extends Breakpoint<P> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter");
    @Nullable
    private SourcePosition mySourcePosition;
    private boolean myVisible;
    private volatile Icon myIcon;
    @Nullable
    private String myClassName;
    @Nullable
    private String myPackageName;
    @Nullable
    private String myInvalidMessage;

    protected abstract void createRequestForPreparedClass(DebugProcessImpl var1, ReferenceType var2);

    protected abstract Icon getDisabledIcon(boolean var1);

    protected abstract Icon getInvalidIcon(boolean var1);

    protected abstract Icon getSetIcon(boolean var1);

    protected abstract Icon getVerifiedIcon(boolean var1);

    protected abstract Icon getVerifiedWarningsIcon(boolean var1);

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        SourcePosition pos = this.getSourcePosition();
        if (pos != null && pos.getFile() instanceof JspFile) {
            return this.getClassName();
        }
        return super.getShortClassName();
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.myPackageName;
    }

    @Nullable
    public BreakpointWithHighlighter init() {
        if (!this.isValid()) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateUI();
            this.updateGutter();
        }
        return this;
    }

    private void updateCaches(DebugProcessImpl debugProcess) {
        this.myIcon = this.calcIcon(debugProcess);
        this.myClassName = JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, this.getSourcePosition());
        this.myPackageName = JVMNameUtil.getSourcePositionPackageDisplayName(debugProcess, this.getSourcePosition());
    }

    private Icon calcIcon(@Nullable DebugProcessImpl debugProcess) {
        boolean muted;
        boolean bl = muted = debugProcess != null && this.isMuted(debugProcess);
        if (!this.isEnabled()) {
            return this.getDisabledIcon(muted);
        }
        this.myInvalidMessage = "";
        if (!this.isValid()) {
            return this.getInvalidIcon(muted);
        }
        if (debugProcess == null) {
            return this.getSetIcon(muted);
        }
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        boolean isVerified = this.myCachedVerifiedState || requestsManager.isVerified(this);
        String warning = requestsManager.getWarning(this);
        if (warning != null) {
            this.myInvalidMessage = warning;
            if (!isVerified) {
                return this.getInvalidIcon(muted);
            }
            return this.getVerifiedWarningsIcon(muted);
        }
        if (isVerified) {
            return this.getVerifiedIcon(muted);
        }
        return this.getSetIcon(muted);
    }

    protected BreakpointWithHighlighter(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "<init>"));
        }
        super(project2, xBreakpoint);
        this.myVisible = true;
        this.myIcon = this.getSetIcon(false);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                BreakpointWithHighlighter.this.reload();
            }
        });
    }

    @Override
    public boolean isValid() {
        return BreakpointWithHighlighter.isPositionValid(this.myXBreakpoint.getSourcePosition());
    }

    protected static boolean isPositionValid(final @Nullable XSourcePosition sourcePosition) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return sourcePosition != null && sourcePosition.getFile().isValid();
            }
        });
    }

    @Nullable
    public SourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getDescription() {
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        buf.append(this.getDisplayName());
        if (this.isCountFilterEnabled()) {
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.pass.count", (Object[])new Object[0])).append(": ");
            buf.append(this.getCountFilter());
        }
        if (this.isClassFiltersEnabled()) {
            ClassFilter[] classFilters;
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.class.filters", (Object[])new Object[0])).append(": ");
            for (ClassFilter classFilter : classFilters = this.getClassFilters()) {
                buf.append(classFilter.getPattern()).append(" ");
            }
        }
        if (this.isInstanceFiltersEnabled()) {
            InstanceFilter[] instanceFilters;
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.instance.filters", (Object[])new Object[0]));
            for (InstanceFilter instanceFilter : instanceFilters = this.getInstanceFilters()) {
                buf.append(Long.toString(instanceFilter.getId())).append(" ");
            }
        }
        String string = buf.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "getDescription"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    public void reload() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        PsiFile psiFile = this.getPsiFile();
        if (position != null && psiFile != null) {
            this.mySourcePosition = SourcePosition.createFromLine((PsiFile)psiFile, (int)position.getLine());
            this.reload(psiFile);
        } else {
            this.mySourcePosition = null;
        }
    }

    @Nullable
    public PsiFile getPsiFile() {
        VirtualFile file2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        if (position != null && (file2 = position.getFile()).isValid()) {
            return PsiManager.getInstance((Project)this.myProject).findFile(file2);
        }
        return null;
    }

    @Override
    public void createRequest(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "createRequest"));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            this.createOrWaitPrepare(debugProcess, position);
        } else {
            LOG.error("Unable to create request for breakpoint with null position: " + this.toString() + " at " + this.myXBreakpoint.getSourcePosition());
        }
        this.updateUI();
    }

    protected boolean isMuted(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "isMuted"));
        }
        return debugProcess.areBreakpointsMuted();
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType classType) {
        if (!this.isEnabled() || !this.isValid()) {
            return;
        }
        this.createRequestForPreparedClass((DebugProcessImpl)debugProcess, classType);
        this.updateUI();
    }

    @Override
    public final void updateUI() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Project project2 = this.getProject();
        DebuggerInvocationUtil.swingInvokeLater(project2, new Runnable(){

            @Override
            public void run() {
                if (!BreakpointWithHighlighter.this.isValid()) {
                    return;
                }
                DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
                final DebugProcessImpl debugProcess = context.getDebugProcess();
                if (debugProcess == null || !debugProcess.isAttached()) {
                    BreakpointWithHighlighter.this.updateCaches(null);
                    BreakpointWithHighlighter.this.updateGutter();
                } else {
                    debugProcess.getManagerThread().invoke(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    if (!project2.isDisposed()) {
                                        BreakpointWithHighlighter.this.updateCaches(debugProcess);
                                    }
                                }
                            });
                            DebuggerInvocationUtil.swingInvokeLater(project2, new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointWithHighlighter.this.updateGutter();
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private void updateGutter() {
        if (this.myVisible && this.isValid()) {
            XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
            breakpointManager.updateBreakpointPresentation((XLineBreakpoint)this.myXBreakpoint, this.getIcon(), this.myInvalidMessage);
        }
    }

    public boolean isAt(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "isAt"));
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        int line = document.getLineNumber(offset);
        XSourcePosition position = this.myXBreakpoint.getSourcePosition();
        return position != null && position.getLine() == line && position.getFile().equals(file2);
    }

    protected void reload(PsiFile psiFile) {
    }

    @Override
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
    }

    protected static PsiClass getPsiClassAt(final @Nullable SourcePosition sourcePosition) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return JVMNameUtil.getClassAt(sourcePosition);
            }
        });
    }

    @Override
    public abstract Key<? extends BreakpointWithHighlighter> getCategory();

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    @Nullable
    public Document getDocument() {
        PsiFile file2 = this.getPsiFile();
        if (file2 != null) {
            return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
        }
        return null;
    }

    public int getLineIndex() {
        XSourcePosition sourcePosition = this.myXBreakpoint.getSourcePosition();
        return sourcePosition != null ? sourcePosition.getLine() : -1;
    }

    protected String getFileName() {
        XSourcePosition sourcePosition = this.myXBreakpoint.getSourcePosition();
        return sourcePosition != null ? sourcePosition.getFile().getName() : "";
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        String packageName;
        if (breakpointNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointNode", "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter", "readExternal"));
        }
        super.readExternal(breakpointNode);
        String className = breakpointNode.getAttributeValue("class");
        if (className != null) {
            this.myClassName = className;
        }
        if ((packageName = breakpointNode.getAttributeValue("package")) != null) {
            this.myPackageName = packageName;
        }
    }

    public String toString() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return "<html><body>" + BreakpointWithHighlighter.this.getDescription() + "</body>" + "</html>";
            }
        });
    }
}

