/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PalettePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteToolWindowManager
extends AbstractToolWindowManager {
    private final PalettePanel myToolWindowPanel = new PalettePanel();

    public PaletteToolWindowManager(Project project2, FileEditorManager fileEditorManager) {
        super(project2, fileEditorManager);
    }

    public static PalettePanel getInstance(DesignerEditorPanel designer) {
        PaletteToolWindowManager manager = PaletteToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (PalettePanel)manager.getContent(designer);
        }
        return manager.myToolWindowPanel;
    }

    public static PaletteToolWindowManager getInstance(Project project2) {
        return (PaletteToolWindowManager)project2.getComponent(PaletteToolWindowManager.class);
    }

    @Override
    protected void initToolWindow() {
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow("Palette\t", false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowPalette);
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this.myToolWindowPanel, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)this.myToolWindowPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
    }

    @Override
    protected ToolWindowAnchor getAnchor() {
        DesignerCustomizations customization = PaletteToolWindowManager.getCustomizations();
        return customization != null ? customization.getPaletteAnchor() : ToolWindowAnchor.RIGHT;
    }

    @Override
    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowPanel.loadPalette((DesignerEditorPanel)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @Override
    public void disposeComponent() {
        this.myToolWindowPanel.dispose();
    }

    @NotNull
    public String getComponentName() {
        if ("PaletteToolWindowManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/palette/PaletteToolWindowManager", "getComponentName"));
        }
        return "PaletteToolWindowManager";
    }

    @Override
    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/designer/palette/PaletteToolWindowManager", "createContent"));
        }
        PalettePanel palettePanel = new PalettePanel();
        palettePanel.loadPalette((DesignerEditorPanel)designer);
        return this.createContent(designer, palettePanel, "Palette", AllIcons.Toolwindows.ToolWindowPalette, palettePanel, palettePanel, 180, null);
    }
}

