/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DebugLogManagerKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0003!9Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\u0011\u0002\u0007\u00013\u0005A\n!(A\u000bC\u000b\t6!\u0001\u0005\u0002KAA\u0019!D\u0001\u0019\u0005ea\u0001RA\u0007\u000b\u0013!Iq!\u0003\u0002\n\u0003a!\u0011BA\u0005\u00021\u0013A:\u0001G\u0002&3\u0011\t\u00012A\u0007\u00021\tIB\u0002#\u0002\u000e\u0015%A\u0011bB\u0005\u0003\u0013\u0005AB!\u0003\u0002\n\u0003a%\u0001t\u0001\r\u00043\rAQ!D\u0001\u0019\ne\u0019\u00012B\u0007\u00021\u0019)#\u0004B\u0001\t\u000e5q\u0011\u0002D\u0005\f\u0013\u0019IQ\u0001E\u0004\u0016\u00051\u0005\u0001\u0004\u0002\r\u0005\u0013\tI\u0011\u0001'\u0003\u0019\ba\u0019\u0011\u0004\u0002E\b\u001b\ta\t\u0001\u0007\u0003\u001a\u0007!)Q\"\u0001M\u0005K5!\u0011\u0001\u0003\u0005\u000e\u0015%A\u0011bB\u0005\u0003\u0013\u0005AB!\u0003\u0002\n\u0003a%\u0001t\u0001\r\u0004K1A\t\"\u0004\u0006\n\u0011%9\u0011BA\u0005\u00021\u0011I!!C\u0001\u0019\na\u001d\u0001dA\u0013\u0005\t-A\u0011\"D\u0001\u0019\u0005\u0015\u0002\u00022C\u0007\u00021\tIB\u0002#\u0002\u000e\u0015%A\u0011bB\u0005\u0003\u0013\u0005AB!\u0003\u0002\n\u0003a%\u0001t\u0001\r\u0004KY!\u0011\u0001\u0003\u0006\u000e\u00051\u0005\u0001\u0004B\r\r\u0011\u000bi!\"\u0003\u0005\n\u000f%\u0011\u0011\"\u0001\r\u0005\u0013\tI\u0011\u0001'\u0003\u0019\ba\u0019\u0011d\u0001\u0005\u0006\u001b\u0005AJ\u0001"}, strings={"Lcom/intellij/diagnostic/DebugLogManager;", "Lcom/intellij/openapi/components/ApplicationComponent$Adapter;", "()V", "applyCategories", "", "categories", "", "Lkotlin/Pair;", "", "Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "level", "log4jLevel", "Lorg/apache/log4j/Level;", "fromString", "kotlin.jvm.PlatformType", "text", "getCurrentCategories", "getSavedCategories", "initComponent", "saveCategories", "toString", "DebugLogLevel"}, moduleName="platform-impl")
public final class DebugLogManager
extends ApplicationComponent.Adapter {
    @NotNull
    public final List<Pair<String, DebugLogLevel>> getSavedCategories() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        return CollectionsKt.plus((Collection)this.fromString(properties.getValue(DebugLogManagerKt.access$getLOG_DEBUG_CATEGORIES$p()), DebugLogLevel.DEBUG), (Iterable)this.fromString(properties.getValue(DebugLogManagerKt.access$getLOG_TRACE_CATEGORIES$p()), DebugLogLevel.TRACE));
    }

    public void initComponent() {
        List<Pair<String, DebugLogLevel>> categories = this.getSavedCategories();
        if (categories.isEmpty()) {
            this.saveCategories(this.getCurrentCategories());
        } else {
            this.applyCategories(categories);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, DebugLogLevel>> fromString(String text, DebugLogLevel level) {
        List list;
        if (text != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Object[] $receiver$iv = StringUtil.splitByLines((String)text, (boolean)true);
            Object[] objectArray = $receiver$iv;
            Collection collection = new ArrayList($receiver$iv.length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void it;
                void item$iv$iv = $receiver$iv$iv[i];
                String string = (String)item$iv$iv;
                void var12_9 = destination$iv$iv;
                Pair pair = new Pair((Object)it, (Object)level);
                var12_9.add(pair);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void applyCategories(@NotNull List<? extends Pair<String, ? extends DebugLogLevel>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        this.applyCategories(categories, DebugLogLevel.DEBUG, level);
        Level level2 = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
        this.applyCategories(categories, DebugLogLevel.TRACE, level2);
    }

    private final void applyCategories(List<? extends Pair<String, ? extends DebugLogLevel>> categories, DebugLogLevel level, Level log4jLevel) {
        Collection destination$iv$iv;
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = categories;
        Iterator iterator = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)((DebugLogLevel)((Object)it.getSecond()))), (Object)((Object)level))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            String string = (String)it.getFirst();
            collection2.add(string);
        }
        List filtered = (List)destination$iv$iv;
        $receiver$iv = filtered;
        for (Object element$iv : $receiver$iv) {
            String it2 = (String)element$iv;
            Logger logger = LogManager.getLogger((String)it2);
            if (logger == null) continue;
            logger.setLevel(log4jLevel);
        }
        if (!filtered.isEmpty()) {
            DebugLogManagerKt.access$getLOG$p().info("Set " + level.name() + " for the following categories: " + CollectionsKt.joinToString$default((Iterable)filtered, null, null, null, (int)0, null, null, (int)63));
        }
    }

    public final void saveCategories(@NotNull List<? extends Pair<String, ? extends DebugLogLevel>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        PropertiesComponent.getInstance().setValue(DebugLogManagerKt.access$getLOG_DEBUG_CATEGORIES$p(), this.toString(categories, DebugLogLevel.DEBUG), (String)null);
        PropertiesComponent.getInstance().setValue(DebugLogManagerKt.access$getLOG_TRACE_CATEGORIES$p(), this.toString(categories, DebugLogLevel.TRACE), (String)null);
    }

    private final String toString(List<? extends Pair<String, ? extends DebugLogLevel>> categories, DebugLogLevel level) {
        Collection destination$iv$iv;
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = categories;
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)((DebugLogLevel)((Object)it.getSecond()))), (Object)((Object)level))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            String string = (String)it.getFirst();
            collection2.add(string);
        }
        List filtered = (List)destination$iv$iv;
        return CollectionsKt.isNotEmpty((Collection)filtered) ? CollectionsKt.joinToString$default((Iterable)filtered, (CharSequence)"\n", null, null, (int)0, null, null, (int)62) : (String)null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, DebugLogLevel>> getCurrentCategories() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        List currentLoggers = CollectionsKt.filterIsInstance((Iterable)CollectionsKt.toList((Enumeration)LogManager.getCurrentLoggers()), Logger.class);
        Iterable $receiver$iv = currentLoggers;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Logger logger = (Logger)item$iv$iv;
            void var13_10 = destination$iv$iv;
            String category = it.getName();
            com.intellij.openapi.diagnostic.Logger logger2 = com.intellij.openapi.diagnostic.Logger.getInstance((String)category);
            Pair pair = logger2.isTraceEnabled() ? new Pair((Object)category, (Object)DebugLogLevel.TRACE) : (logger2.isDebugEnabled() ? new Pair((Object)category, (Object)DebugLogLevel.DEBUG) : (Pair)null);
            var13_10.add(pair);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001b\u0001\u0005\u0007\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t\u00141\u0001\u00026\u0003\u0011\rQ'\u0001\u0003\u0003"}, strings={"Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "", "(Ljava/lang/String;I)V", "DEBUG", "TRACE"}, moduleName="platform-impl")
    public static final class DebugLogLevel
    extends Enum<DebugLogLevel> {
        public static final /* enum */ DebugLogLevel DEBUG;
        public static final /* enum */ DebugLogLevel TRACE;
        private static final /* synthetic */ DebugLogLevel[] $VALUES;

        static {
            DebugLogLevel[] debugLogLevelArray = new DebugLogLevel[2];
            DebugLogLevel[] debugLogLevelArray2 = debugLogLevelArray;
            debugLogLevelArray[0] = DEBUG = new DebugLogLevel();
            debugLogLevelArray[1] = TRACE = new DebugLogLevel();
            $VALUES = debugLogLevelArray;
        }

        public static DebugLogLevel[] values() {
            return (DebugLogLevel[])$VALUES.clone();
        }

        public static DebugLogLevel valueOf(String string) {
            return Enum.valueOf(DebugLogLevel.class, string);
        }
    }
}

