/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCherryPickAction
extends DumbAwareAction {
    private static final String NAME = "Cherry-Pick";
    private static final Logger LOG = Logger.getInstance(VcsCherryPickAction.class);
    @NotNull
    private final Set<Hash> myIdsInProgress = ContainerUtil.newHashSet();

    public VcsCherryPickAction() {
        super(NAME, null, DvcsImplIcons.CherryPick);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        final List commits = log.getSelectedDetails();
        for (VcsFullCommitDetails commit : commits) {
            this.myIdsInProgress.add((Hash)commit.getId());
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final ChangeListManagerEx changeListManagerEx = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project2);
        changeListManagerEx.blockModalNotifications();
        new Task.Backgroundable(project2, "Cherry-picking", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/cherrypick/VcsCherryPickAction$1", "run"));
                }
                try {
                    List<VcsFullCommitDetails> sortedCommits = VcsCherryPickAction.sortCommits(commits);
                    Map groupedCommits = VcsCherryPickAction.groupByVcs(project2, sortedCommits);
                    for (Map.Entry entry : groupedCommits.entrySet()) {
                        ((VcsCherryPicker)entry.getKey()).cherryPick((List)entry.getValue());
                    }
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            changeListManagerEx.unblockModalNotifications();
                            for (VcsFullCommitDetails commit : commits) {
                                VcsCherryPickAction.this.myIdsInProgress.remove(commit.getId());
                            }
                        }
                    });
                    throw throwable;
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }.queue();
    }

    @NotNull
    public static List<VcsFullCommitDetails> sortCommits(@NotNull List<VcsFullCommitDetails> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "sortCommits"));
        }
        Collections.reverse(commits);
        List<VcsFullCommitDetails> list = commits;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "sortCommits"));
        }
        return list;
    }

    private static Map<VcsCherryPicker, List<VcsFullCommitDetails>> groupByVcs(@NotNull Project project2, @NotNull List<VcsFullCommitDetails> commits) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "groupByVcs"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "groupByVcs"));
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        HashMap resultMap = new HashMap();
        for (VcsFullCommitDetails commit : commits) {
            VcsCherryPicker cherryPicker = VcsCherryPickAction.getCherryPickerForCommit(project2, projectLevelVcsManager, commit);
            if (cherryPicker == null) {
                LOG.warn("Cherry pick is not supported for " + commit.getRoot().getName());
                return Collections.emptyMap();
            }
            ArrayList<VcsFullCommitDetails> list = (ArrayList<VcsFullCommitDetails>)resultMap.get(cherryPicker);
            if (list == null) {
                list = new ArrayList<VcsFullCommitDetails>();
                resultMap.put(cherryPicker, list);
            }
            list.add(commit);
        }
        return resultMap;
    }

    @Nullable
    private static VcsCherryPicker getCherryPickerFor(@NotNull Project project2, final @NotNull VcsKey key) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getCherryPickerFor"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getCherryPickerFor"));
        }
        return (VcsCherryPicker)ContainerUtil.find((Object[])Extensions.getExtensions((ExtensionPointName)VcsCherryPicker.EXTENSION_POINT_NAME, (AreaInstance)project2), (Condition)new Condition<VcsCherryPicker>(){

            public boolean value(VcsCherryPicker picker) {
                return picker.getSupportedVcs().equals((Object)key);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "update"));
        }
        super.update(e);
        e.getPresentation().setVisible(true);
        final VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        Project project2 = VcsCherryPickAction.getEventProject((AnActionEvent)e);
        List<VcsCherryPicker> cherryPickers = VcsCherryPickAction.getActiveCherryPickersForProject(project2);
        if (log == null || cherryPickers.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        final List details = log.getSelectedDetails();
        VcsCherryPicker enabledCherryPicker = (VcsCherryPicker)ContainerUtil.find(cherryPickers, (Condition)new Condition<VcsCherryPicker>(){

            public boolean value(VcsCherryPicker picker) {
                return picker.isEnabled(log, details);
            }
        });
        e.getPresentation().setEnabled(enabledCherryPicker != null);
        e.getPresentation().setText(enabledCherryPicker == null ? VcsCherryPickAction.concatActionNamesForAllAvailable(cherryPickers) : enabledCherryPicker.getActionTitle());
    }

    @NotNull
    private static String concatActionNamesForAllAvailable(@NotNull List<VcsCherryPicker> pickers) {
        if (pickers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pickers", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "concatActionNamesForAllAvailable"));
        }
        String string = StringUtil.join(pickers, (Function)new Function<VcsCherryPicker, String>(){

            public String fun(VcsCherryPicker picker) {
                return picker.getActionTitle();
            }
        }, (String)"/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "concatActionNamesForAllAvailable"));
        }
        return string;
    }

    @NotNull
    private static List<VcsCherryPicker> getActiveCherryPickersForProject(final @Nullable Project project2) {
        if (project2 != null) {
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
            Object[] vcss = projectLevelVcsManager.getAllActiveVcss();
            List list = ContainerUtil.mapNotNull((Object[])vcss, (Function)new Function<AbstractVcs, VcsCherryPicker>(){

                public VcsCherryPicker fun(AbstractVcs vcs) {
                    return vcs != null ? VcsCherryPickAction.getCherryPickerFor(project2, vcs.getKeyInstanceMethod()) : null;
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getActiveCherryPickersForProject"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getActiveCherryPickersForProject"));
        }
        return list;
    }

    @Nullable
    private static VcsCherryPicker getCherryPickerForCommit(@NotNull Project project2, @NotNull ProjectLevelVcsManager projectLevelVcsManager, @NotNull VcsFullCommitDetails commitDetails) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getCherryPickerForCommit"));
        }
        if (projectLevelVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLevelVcsManager", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getCherryPickerForCommit"));
        }
        if (commitDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitDetails", "com/intellij/dvcs/cherrypick/VcsCherryPickAction", "getCherryPickerForCommit"));
        }
        AbstractVcs vcs = projectLevelVcsManager.getVcsFor(commitDetails.getRoot());
        if (vcs == null) {
            return null;
        }
        VcsKey key = vcs.getKeyInstanceMethod();
        return VcsCherryPickAction.getCherryPickerFor(project2, key);
    }
}

