/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsStatusWidget<T extends Repository>
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe {
    protected static final Logger LOG = Logger.getInstance(DvcsStatusWidget.class);
    private static final String MAX_STRING = "VCS: Rebasing feature-12345";
    @NotNull
    private final String myPrefix;
    @Nullable
    private String myText;
    @Nullable
    private String myTooltip;

    protected DvcsStatusWidget(@NotNull Project project2, @NotNull String prefix) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/DvcsStatusWidget", "<init>"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/dvcs/ui/DvcsStatusWidget", "<init>"));
        }
        super(project2);
        this.myPrefix = prefix;
    }

    @Nullable
    protected abstract T guessCurrentRepository(@NotNull Project var1);

    @NotNull
    protected abstract String getFullBranchName(@NotNull T var1);

    protected abstract boolean isMultiRoot(@NotNull Project var1);

    @NotNull
    protected abstract ListPopup getPopup(@NotNull Project var1, @NotNull T var2);

    protected abstract void subscribeToRepoChangeEvents(@NotNull Project var1);

    protected abstract void rememberRecentRoot(@NotNull String var1);

    public void activate() {
        Project project2 = this.getProject();
        if (project2 != null) {
            this.installWidgetToStatusBar(project2, this);
        }
    }

    public void deactivate() {
        Project project2 = this.getProject();
        if (project2 != null) {
            this.removeWidgetFromStatusBar(project2, this);
        }
    }

    @Override
    public void dispose() {
        this.deactivate();
        super.dispose();
    }

    @NotNull
    public String ID() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/DvcsStatusWidget", "ID"));
        }
        return string;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dvcs/ui/DvcsStatusWidget", "getPresentation"));
        }
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/ui/DvcsStatusWidget", "selectionChanged"));
        }
        LOG.debug("selection changed");
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dvcs/ui/DvcsStatusWidget", "fileOpened"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/ui/DvcsStatusWidget", "fileOpened"));
        }
        LOG.debug("file opened");
        this.update();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dvcs/ui/DvcsStatusWidget", "fileClosed"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/ui/DvcsStatusWidget", "fileClosed"));
        }
        LOG.debug("file closed");
        this.update();
    }

    @Nullable
    public String getSelectedValue() {
        return StringUtil.isEmpty((String)this.myText) ? "" : this.myPrefix + ": " + this.myText;
    }

    @Deprecated
    @NotNull
    public String getMaxValue() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/DvcsStatusWidget", "getMaxValue"));
        }
        return "";
    }

    @Nullable
    public String getTooltipText() {
        return this.myTooltip;
    }

    @Nullable
    public ListPopup getPopupStep() {
        Project project2 = this.getProject();
        if (project2 == null || project2.isDisposed()) {
            return null;
        }
        T repository = this.guessCurrentRepository(project2);
        if (repository == null) {
            return null;
        }
        return this.getPopup(project2, repository);
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return null;
    }

    protected void updateLater() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LOG.debug("update after repository change");
                DvcsStatusWidget.this.update();
            }
        });
    }

    private void update() {
        this.myText = null;
        this.myTooltip = null;
        Project project2 = this.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        T repository = this.guessCurrentRepository(project2);
        if (repository == null) {
            return;
        }
        int maxLength = MAX_STRING.length() - 1;
        this.myText = StringUtil.shortenTextWithEllipsis((String)this.getFullBranchName(repository), (int)maxLength, (int)5);
        this.myTooltip = this.getToolTip(project2);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
        this.rememberRecentRoot(repository.getRoot().getPath());
    }

    @Nullable
    private String getToolTip(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/DvcsStatusWidget", "getToolTip"));
        }
        T currentRepository = this.guessCurrentRepository(project2);
        if (currentRepository == null) {
            return null;
        }
        String branchName = this.getFullBranchName(currentRepository);
        if (this.isMultiRoot(project2)) {
            return branchName + "\n" + "Root: " + currentRepository.getRoot().getName();
        }
        return branchName;
    }

    private void installWidgetToStatusBar(final @NotNull Project project2, final @NotNull StatusBarWidget widget) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/DvcsStatusWidget", "installWidgetToStatusBar"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/intellij/dvcs/ui/DvcsStatusWidget", "installWidgetToStatusBar"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
                if (statusBar != null && !DvcsStatusWidget.this.isDisposed()) {
                    statusBar.addWidget(widget, "after " + (SystemInfo.isMac ? "Encoding" : "InsertOverwrite"), (Disposable)project2);
                    DvcsStatusWidget.this.subscribeToMappingChanged();
                    DvcsStatusWidget.this.subscribeToRepoChangeEvents(project2);
                    DvcsStatusWidget.this.update();
                }
            }
        });
    }

    private void removeWidgetFromStatusBar(final @NotNull Project project2, final @NotNull StatusBarWidget widget) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/DvcsStatusWidget", "removeWidgetFromStatusBar"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/intellij/dvcs/ui/DvcsStatusWidget", "removeWidgetFromStatusBar"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
                if (statusBar != null && !DvcsStatusWidget.this.isDisposed()) {
                    statusBar.removeWidget(widget.ID());
                }
            }
        });
    }

    private void subscribeToMappingChanged() {
        this.myProject.getMessageBus().connect().subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, (Object)new VcsRepositoryMappingListener(){

            @Override
            public void mappingChanged() {
                LOG.debug("repository mappings changed");
                DvcsStatusWidget.this.updateLater();
            }
        });
    }
}

