/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance(ProgramRunnerUtil.class);

    private ProgramRunnerUtil() {
    }

    @Nullable
    public static ProgramRunner getRunner(@NotNull String executorId, RunnerAndConfigurationSettings configuration) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ProgramRunnerUtil", "getRunner"));
        }
        return configuration == null ? null : RunnerRegistry.getInstance().getRunner(executorId, (RunProfile)configuration.getConfiguration());
    }

    public static void executeConfiguration(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (ExecutorRegistry.getInstance().isStarting(environment)) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings != null) {
            ConfigurationType configurationType;
            if (!ExecutionTargetManager.canRun((ExecutionEnvironment)environment)) {
                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(StringUtil.escapeXml((String)("Cannot run '" + environment.getRunProfile().getName() + "' on '" + environment.getExecutionTarget().getDisplayName() + "'"))));
                return;
            }
            if (!RunManagerImpl.canRunConfiguration(environment) || showSettings && runnerAndConfigurationSettings.isEditBeforeRun()) {
                if (!RunDialog.editConfiguration(environment, "Edit configuration")) {
                    return;
                }
                while (!RunManagerImpl.canRunConfiguration(environment) && 0 == Messages.showYesNoDialog((Project)environment.getProject(), (String)"Configuration is still incorrect. Do you want to edit it again?", (String)"Change Configuration Settings", (String)"Edit", (String)"Continue Anyway", (Icon)Messages.getErrorIcon())) {
                    if (RunDialog.editConfiguration(environment, "Edit configuration")) continue;
                    return;
                }
            }
            if ((configurationType = runnerAndConfigurationSettings.getType()) != null) {
                UsageTrigger.trigger("execute." + ConvertUsagesUtil.ensureProperKey(configurationType.getId()) + "." + environment.getExecutor().getId());
            }
        }
        try {
            if (assignNewId) {
                environment.assignNewExecutionId();
            }
            environment.getRunner().execute(environment);
        }
        catch (ExecutionException e) {
            String name;
            String string = name = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getName() : null;
            if (name == null) {
                name = environment.getRunProfile().getName();
            }
            if (name == null && environment.getContentToReuse() != null) {
                name = environment.getContentToReuse().getDisplayName();
            }
            if (name == null) {
                name = "<Unknown>";
            }
            ExecutionUtil.handleExecutionError((Project)environment.getProject(), (String)environment.getExecutor().getToolWindowId(), (String)name, (ExecutionException)e);
        }
    }

    public static void executeConfiguration(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        ExecutionEnvironmentBuilder builder;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ProgramRunnerUtil", "executeConfiguration"));
        }
        try {
            builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return;
        }
        ProgramRunnerUtil.executeConfiguration(builder.contentToReuse(null).dataContext(null).activeTarget().build(), true, true);
    }

    public static Icon getConfigurationIcon(RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        Icon icon = ProgramRunnerUtil.getRawIcon(settings);
        Icon icon2 = configurationIcon = settings.isTemporary() ? ProgramRunnerUtil.getTemporaryIcon(icon) : icon;
        if (invalid) {
            return LayeredIcon.create((Icon)configurationIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
        }
        return configurationIcon;
    }

    @NotNull
    public static Icon getRawIcon(RunnerAndConfigurationSettings settings) {
        Icon icon;
        RunConfiguration configuration = settings.getConfiguration();
        ConfigurationFactory factory = settings.getFactory();
        Icon icon2 = icon = factory != null ? factory.getIcon(configuration) : null;
        if (icon == null) {
            icon = AllIcons.RunConfigurations.Unknown;
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ProgramRunnerUtil", "getRawIcon"));
        }
        return icon3;
    }

    public static Icon getTemporaryIcon(@NotNull Icon rawIcon) {
        if (rawIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawIcon", "com/intellij/execution/ProgramRunnerUtil", "getTemporaryIcon"));
        }
        return IconLoader.getTransparentIcon((Icon)rawIcon, (float)0.3f);
    }

    public static String shortenName(@Nullable String name, int toBeAdded) {
        if (name == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        return name.length() < symbols ? name : name.substring(0, symbols) + "...";
    }
}

