/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHyperlinkSupport {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.EditorHyperlinkSupport");
    public static final Key<TextAttributes> OLD_HYPERLINK_TEXT_ATTRIBUTES = Key.create((String)"OLD_HYPERLINK_TEXT_ATTRIBUTES");
    private static final Key<HyperlinkInfoTextAttributes> HYPERLINK = Key.create((String)"HYPERLINK");
    private static final int HYPERLINK_LAYER = 5877;
    private static final int HIGHLIGHT_LAYER = 5889;
    private final Editor myEditor;
    @NotNull
    private final Project myProject;

    public EditorHyperlinkSupport(final @NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/EditorHyperlinkSupport", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/EditorHyperlinkSupport", "<init>"));
        }
        this.myEditor = editor;
        this.myProject = project2;
        editor.addEditorMouseListener((EditorMouseListener)new EditorMouseAdapter(){

            public void mouseClicked(EditorMouseEvent e) {
                Runnable runnable2;
                MouseEvent mouseEvent = e.getMouseEvent();
                if (mouseEvent.getButton() == 1 && !mouseEvent.isPopupTrigger() && (runnable2 = EditorHyperlinkSupport.this.getLinkNavigationRunnable(EditorHyperlinkSupport.this.myEditor.xyToLogicalPosition(e.getMouseEvent().getPoint()))) != null) {
                    runnable2.run();
                }
            }
        });
        editor.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HyperlinkInfo info = EditorHyperlinkSupport.this.getHyperlinkInfoByPoint(e.getPoint());
                if (info != null) {
                    EditorHyperlinkSupport.this.myEditor.getContentComponent().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    Cursor cursor = editor instanceof EditorEx ? UIUtil.getTextCursor((Color)((EditorEx)editor).getBackgroundColor()) : Cursor.getPredefinedCursor(2);
                    EditorHyperlinkSupport.this.myEditor.getContentComponent().setCursor(cursor);
                }
            }
        });
    }

    public void clearHyperlinks() {
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            this.removeHyperlink(highlighter);
        }
    }

    @Deprecated
    public Map<RangeHighlighter, HyperlinkInfo> getHyperlinks() {
        LinkedHashMap result2 = new LinkedHashMap();
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(highlighter);
            if (info == null) continue;
            result2.put((Object)highlighter, (Object)info);
        }
        return result2;
    }

    @Nullable
    public Runnable getLinkNavigationRunnable(final LogicalPosition logical) {
        HyperlinkInfo hyperlinkInfo;
        if (EditorUtil.inVirtualSpace(this.myEditor, logical)) {
            return null;
        }
        final RangeHighlighter range = this.findLinkRangeAt(this.myEditor.logicalPositionToOffset(logical));
        if (range != null && (hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(range)) != null) {
            return new Runnable(){

                @Override
                public void run() {
                    if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                        Point point = EditorHyperlinkSupport.this.myEditor.logicalPositionToXY(logical);
                        MouseEvent event = new MouseEvent(EditorHyperlinkSupport.this.myEditor.getContentComponent(), 0, 0L, 0, point.x, point.y, 1, false);
                        ((HyperlinkInfoBase)hyperlinkInfo).navigate(EditorHyperlinkSupport.this.myProject, new RelativePoint(event));
                    } else {
                        hyperlinkInfo.navigate(EditorHyperlinkSupport.this.myProject);
                    }
                    EditorHyperlinkSupport.linkFollowed(EditorHyperlinkSupport.this.myEditor, EditorHyperlinkSupport.getHyperlinks(0, EditorHyperlinkSupport.this.myEditor.getDocument().getTextLength(), EditorHyperlinkSupport.this.myEditor), range);
                }
            };
        }
        return null;
    }

    @Nullable
    public static HyperlinkInfo getHyperlinkInfo(@NotNull RangeHighlighter range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/execution/impl/EditorHyperlinkSupport", "getHyperlinkInfo"));
        }
        HyperlinkInfoTextAttributes attributes = (HyperlinkInfoTextAttributes)((Object)range.getUserData(HYPERLINK));
        return attributes != null ? attributes.getHyperlinkInfo() : null;
    }

    @Nullable
    private RangeHighlighter findLinkRangeAt(int offset) {
        Iterator<RangeHighlighter> iterator = EditorHyperlinkSupport.getHyperlinks(offset, offset, this.myEditor).iterator();
        if (iterator.hasNext()) {
            RangeHighlighter highlighter = iterator.next();
            return highlighter;
        }
        return null;
    }

    @Nullable
    private HyperlinkInfo getHyperlinkAt(int offset) {
        RangeHighlighter range = this.findLinkRangeAt(offset);
        return range == null ? null : EditorHyperlinkSupport.getHyperlinkInfo(range);
    }

    public List<RangeHighlighter> findAllHyperlinksOnLine(int line) {
        int lineStart = this.myEditor.getDocument().getLineStartOffset(line);
        int lineEnd = this.myEditor.getDocument().getLineEndOffset(line);
        return EditorHyperlinkSupport.getHyperlinks(lineStart, lineEnd, this.myEditor);
    }

    public static List<RangeHighlighter> getHyperlinks(int startOffset, int endOffset, final Editor editor) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new FilteringProcessor((Condition)new Condition<RangeHighlighterEx>(){

            public boolean value(RangeHighlighterEx rangeHighlighterEx) {
                return rangeHighlighterEx.getEditorFilter().avaliableIn(editor) && 5877 == rangeHighlighterEx.getLayer() && rangeHighlighterEx.isValid() && EditorHyperlinkSupport.getHyperlinkInfo(rangeHighlighterEx) != null;
            }
        }, (Processor)processor2));
        return new ArrayList<RangeHighlighter>(processor2.getResults());
    }

    public void removeHyperlink(@NotNull RangeHighlighter hyperlink) {
        if (hyperlink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlink", "com/intellij/execution/impl/EditorHyperlinkSupport", "removeHyperlink"));
        }
        this.myEditor.getMarkupModel().removeHighlighter(hyperlink);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByLineAndCol(int line, int col) {
        return this.getHyperlinkAt(this.myEditor.logicalPositionToOffset(new LogicalPosition(line, col)));
    }

    public void addHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkInfo", "com/intellij/execution/impl/EditorHyperlinkSupport", "addHyperlink"));
        }
        this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo);
    }

    @NotNull
    public RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkInfo", "com/intellij/execution/impl/EditorHyperlinkSupport", "createHyperlink"));
        }
        RangeHighlighter rangeHighlighter = this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo, null);
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/EditorHyperlinkSupport", "createHyperlink"));
        }
        return rangeHighlighter;
    }

    @NotNull
    private RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
        if (hyperlinkInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkInfo", "com/intellij/execution/impl/EditorHyperlinkSupport", "createHyperlink"));
        }
        TextAttributes textAttributes = highlightAttributes != null ? highlightAttributes : EditorHyperlinkSupport.getHyperlinkAttributes();
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, 5877, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, followedHyperlinkAttributes);
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/EditorHyperlinkSupport", "createHyperlink"));
        }
        return rangeHighlighter;
    }

    public static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/execution/impl/EditorHyperlinkSupport", "associateHyperlink"));
        }
        if (hyperlinkInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkInfo", "com/intellij/execution/impl/EditorHyperlinkSupport", "associateHyperlink"));
        }
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, null);
    }

    private static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/execution/impl/EditorHyperlinkSupport", "associateHyperlink"));
        }
        if (hyperlinkInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkInfo", "com/intellij/execution/impl/EditorHyperlinkSupport", "associateHyperlink"));
        }
        highlighter.putUserData(HYPERLINK, (Object)new HyperlinkInfoTextAttributes(hyperlinkInfo, followedHyperlinkAttributes));
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByPoint(Point p) {
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(new Point(p.x, p.y));
        if (EditorUtil.inVirtualSpace(this.myEditor, pos)) {
            return null;
        }
        return this.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
    }

    @Deprecated
    public void highlightHyperlinks(final Filter customFilter, final Filter predefinedMessageFilter, int line1, int endLine) {
        this.highlightHyperlinks(new Filter(){

            @Nullable
            public Filter.Result applyFilter(String line, int entireLength) {
                Filter.Result result2 = customFilter.applyFilter(line, entireLength);
                return result2 != null ? result2 : predefinedMessageFilter.applyFilter(line, entireLength);
            }
        }, line1, endLine);
    }

    public void highlightHyperlinks(Filter customFilter, int line1, int endLine) {
        int startLine;
        Document document = this.myEditor.getDocument();
        for (int line = startLine = Math.max(0, line1); line <= endLine; ++line) {
            String text;
            Filter.Result result2;
            int endOffset = document.getLineEndOffset(line);
            if (endOffset < document.getTextLength()) {
                ++endOffset;
            }
            if ((result2 = customFilter.applyFilter(text = EditorHyperlinkSupport.getLineText(document, line, true), endOffset)) == null) continue;
            for (Filter.ResultItem resultItem : result2.getResultItems()) {
                int start = resultItem.getHighlightStartOffset();
                int end = resultItem.getHighlightEndOffset();
                if (end < start || end > document.getTextLength()) {
                    LOG.error("Filter returned wrong range: start=" + start + "; end=" + end + "; length=" + document.getTextLength() + "; filter=" + customFilter);
                    continue;
                }
                TextAttributes attributes = resultItem.getHighlightAttributes();
                if (resultItem.getHyperlinkInfo() != null) {
                    this.createHyperlink(start, end, attributes, resultItem.getHyperlinkInfo(), resultItem.getFollowedHyperlinkAttributes());
                    continue;
                }
                if (attributes == null) continue;
                this.addHighlighter(start, end, attributes);
            }
        }
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes) {
        this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, 5889, highlightAttributes, HighlighterTargetArea.EXACT_RANGE);
    }

    private static TextAttributes getHyperlinkAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    }

    @NotNull
    private static TextAttributes getFollowedHyperlinkAttributes(@NotNull RangeHighlighter range) {
        TextAttributes result2;
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/execution/impl/EditorHyperlinkSupport", "getFollowedHyperlinkAttributes"));
        }
        HyperlinkInfoTextAttributes attrs = (HyperlinkInfoTextAttributes)((Object)HYPERLINK.get((UserDataHolder)range));
        TextAttributes textAttributes = result2 = attrs != null ? attrs.getFollowedHyperlinkAttributes() : null;
        if (result2 == null) {
            result2 = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
        }
        TextAttributes textAttributes2 = result2;
        if (textAttributes2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/EditorHyperlinkSupport", "getFollowedHyperlinkAttributes"));
        }
        return textAttributes2;
    }

    @Nullable
    public static OccurenceNavigator.OccurenceInfo getNextOccurrence(final Editor editor, int delta, final Consumer<RangeHighlighter> action) {
        RangeHighlighter range;
        int i;
        final List<RangeHighlighter> ranges = EditorHyperlinkSupport.getHyperlinks(0, editor.getDocument().getTextLength(), editor);
        if (ranges.isEmpty()) {
            return null;
        }
        for (i = 0; i < ranges.size() && (range = ranges.get(i)).getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES) == null; ++i) {
        }
        int newIndex = i %= ranges.size();
        while (newIndex < ranges.size() && newIndex >= 0) {
            newIndex = (newIndex + delta + ranges.size()) % ranges.size();
            final RangeHighlighter next = ranges.get(newIndex);
            if (editor.getFoldingModel().getCollapsedRegionAtOffset(next.getStartOffset()) == null) {
                return new OccurenceNavigator.OccurenceInfo((Navigatable)new NavigatableAdapter(){

                    public void navigate(boolean requestFocus) {
                        action.consume((Object)next);
                        EditorHyperlinkSupport.linkFollowed(editor, ranges, next);
                    }
                }, newIndex == -1 ? -1 : newIndex + 1, ranges.size());
            }
            if (newIndex != i) continue;
            break;
        }
        return null;
    }

    private static void linkFollowed(Editor editor, Collection<RangeHighlighter> ranges, RangeHighlighter link) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        for (RangeHighlighter range : ranges) {
            TextAttributes oldAttr = (TextAttributes)range.getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES);
            if (oldAttr != null) {
                markupModel.setRangeHighlighterAttributes(range, oldAttr);
                range.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, null);
            }
            if (range != link) continue;
            range.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, (Object)range.getTextAttributes());
            markupModel.setRangeHighlighterAttributes(range, EditorHyperlinkSupport.getFollowedHyperlinkAttributes(range));
        }
        markupModel.addRangeHighlighter(0, 0, 5877, EditorHyperlinkSupport.getHyperlinkAttributes(), HighlighterTargetArea.EXACT_RANGE).dispose();
    }

    public static String getLineText(Document document, int lineNumber, boolean includeEol) {
        int endOffset = document.getLineEndOffset(lineNumber);
        if (includeEol && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        return document.getCharsSequence().subSequence(document.getLineStartOffset(lineNumber), endOffset).toString();
    }

    private static class HyperlinkInfoTextAttributes
    extends TextAttributes {
        private final HyperlinkInfo myHyperlinkInfo;
        private final TextAttributes myFollowedHyperlinkAttributes;

        public HyperlinkInfoTextAttributes(@NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
            if (hyperlinkInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkInfo", "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes", "<init>"));
            }
            this.myHyperlinkInfo = hyperlinkInfo;
            this.myFollowedHyperlinkAttributes = followedHyperlinkAttributes;
        }

        @NotNull
        public HyperlinkInfo getHyperlinkInfo() {
            HyperlinkInfo hyperlinkInfo = this.myHyperlinkInfo;
            if (hyperlinkInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes", "getHyperlinkInfo"));
            }
            return hyperlinkInfo;
        }

        @Nullable
        public TextAttributes getFollowedHyperlinkAttributes() {
            return this.myFollowedHyperlinkAttributes;
        }
    }
}

