/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.IProcessList;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

class ProcessListLinux
implements IProcessList {
    ProcessInfo[] empty = new ProcessInfo[0];

    @Override
    public ProcessInfo[] getProcessList() {
        File proc = new File("/proc");
        File[] pidFiles = null;
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isPID = false;
                    try {
                        Integer.parseInt(name);
                        isPID = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return isPID;
                }
            };
            pidFiles = proc.listFiles(filter);
        }
        catch (SecurityException filter) {
            // empty catch block
        }
        ProcessInfo[] processInfo = this.empty;
        if (pidFiles != null) {
            processInfo = new ProcessInfo[pidFiles.length];
            for (int i = 0; i < pidFiles.length; ++i) {
                String name;
                File cmdLine = new File(pidFiles[i], "cmdline");
                try {
                    name = new String(ProcessUtils.loadFileText(cmdLine, null)).replace('\u0000', ' ');
                }
                catch (IOException e) {
                    name = "";
                }
                if (name.length() == 0) {
                    name = "Unknown";
                }
                processInfo[i] = new ProcessInfo(pidFiles[i].getName(), name);
            }
        } else {
            pidFiles = new File[]{};
        }
        return processInfo;
    }
}

