/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.stacktrace;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.stacktrace.MethodLineLocation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;

public class StackTraceLine {
    private final Project myProject;
    private final String myLine;
    @NonNls
    protected static final String AT_STR = "at";
    protected static final String AT__STR = "at ";
    @NonNls
    protected static final String INIT_MESSAGE = "<init>";

    public StackTraceLine(Project project2, String line) {
        this.myProject = project2;
        this.myLine = line;
    }

    public String getClassName() {
        int index = this.myLine.indexOf(AT_STR);
        if (index < 0) {
            return null;
        }
        index += AT__STR.length();
        int lastDot = this.getLastDot();
        if (lastDot < 0) {
            return null;
        }
        if (lastDot <= index) {
            return null;
        }
        return this.myLine.substring(index, lastDot);
    }

    private int getLastDot() {
        return this.myLine.lastIndexOf(46, this.getOpenBracket());
    }

    private int getOpenBracket() {
        return this.myLine.indexOf(40);
    }

    private int getCloseBracket() {
        return this.myLine.indexOf(41);
    }

    public int getLineNumber() throws NumberFormatException {
        int close = this.getCloseBracket();
        int lineNumberStart = this.myLine.lastIndexOf(58) + 1;
        if (close < 0 || lineNumberStart < 1 || lineNumberStart >= close) {
            throw new NumberFormatException(this.myLine);
        }
        return Integer.parseInt(this.myLine.substring(lineNumberStart, close)) - 1;
    }

    public OpenFileDescriptor getOpenFileDescriptor(VirtualFile file2) {
        int lineNumber;
        try {
            lineNumber = this.getLineNumber();
        }
        catch (NumberFormatException e) {
            return new OpenFileDescriptor(this.myProject, file2);
        }
        return new OpenFileDescriptor(this.myProject, file2, lineNumber, 0);
    }

    public OpenFileDescriptor getOpenFileDescriptor(Project project2) {
        Location<PsiMethod> location = this.getMethodLocation(project2);
        if (location == null) {
            return null;
        }
        return this.getOpenFileDescriptor(((PsiMethod)location.getPsiElement()).getContainingFile().getVirtualFile());
    }

    public String getMethodName() {
        int lastDot = this.getLastDot();
        if (lastDot == -1) {
            return null;
        }
        return this.myLine.substring(this.getLastDot() + 1, this.getOpenBracket());
    }

    public Location<PsiMethod> getMethodLocation(Project project2) {
        PsiClass psiClass;
        int lineNumber;
        String className = this.getClassName();
        String methodName = this.getMethodName();
        if (className == null || methodName == null) {
            return null;
        }
        try {
            lineNumber = this.getLineNumber();
        }
        catch (NumberFormatException e) {
            return null;
        }
        int dollarIndex = className.indexOf(36);
        if (dollarIndex != -1) {
            className = className.substring(0, dollarIndex);
        }
        if ((psiClass = StackTraceLine.findClass(project2, className, lineNumber)) == null || psiClass.getNavigationElement() instanceof PsiCompiledElement) {
            return null;
        }
        PsiMethod psiMethod = StackTraceLine.getMethodAtLine(psiClass = (PsiClass)psiClass.getNavigationElement(), methodName, lineNumber);
        if (psiMethod != null) {
            return new MethodLineLocation(project2, psiMethod, (Location<PsiClass>)PsiLocation.fromPsiElement((PsiElement)psiClass), lineNumber);
        }
        return null;
    }

    private static PsiClass findClass(Project project2, String className, int lineNumber) {
        if (project2 == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className, GlobalSearchScope.allScope((Project)project2));
        if (psiClass == null || psiClass.getNavigationElement() instanceof PsiCompiledElement) {
            return null;
        }
        psiClass = (PsiClass)psiClass.getNavigationElement();
        PsiFile psiFile = psiClass.getContainingFile();
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(StackTraceLine.offsetOfLine(psiFile, lineNumber)), PsiClass.class, (boolean)false);
    }

    private static PsiMethod getMethodAtLine(PsiClass psiClass, String methodName, int lineNumber) {
        PsiMethod[] methods = INIT_MESSAGE.equals(methodName) ? psiClass.getConstructors() : psiClass.findMethodsByName(methodName, true);
        if (methods.length == 0) {
            return null;
        }
        PsiFile psiFile = methods[0].getContainingFile();
        int offset = StackTraceLine.offsetOfLine(psiFile, lineNumber);
        for (PsiMethod method : methods) {
            if (!method.getTextRange().contains(offset)) continue;
            return method;
        }
        return null;
    }

    private static int offsetOfLine(PsiFile psiFile, int lineNumber) {
        LineTokenizer lineTokenizer = new LineTokenizer(psiFile.getViewProvider().getContents());
        for (int i = 0; i < lineNumber; ++i) {
            lineTokenizer.advance();
        }
        return lineTokenizer.getOffset();
    }
}

